import { Component } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { UsermanagementService } from '../usermanagement.service'
import { Router } from '@angular/router';

@Component({
  selector: 'app-preference',
  templateUrl: './preference.component.html',
  styleUrls: ['./preference.component.css']
})

export class PreferenceComponent extends AppComponentClass<any, any> {
  
  listdata: any;
  preferenceForm : FormGroup
  didForm: FormGroup;
  smsForm : FormGroup
  voiceForm : FormGroup
  public submitted : boolean = false;
  suppliers: any;
  preferenceDID: any = [];
  preferenceSMS: any = [];
  preferenceVoice: any = [];
  responseMessage: any;
  voiceSupplier = [];
  smsSupplier = [];
  didSupplier = [];
  status: boolean = false;
  

  constructor(public data: UsermanagementService, public router: Router, public fb: FormBuilder) {
		super(data, router, fb);
		//this [formGroupName]="idx".dis_toggle = true;

		this.preferenceForm = this.fb.group({
			name:['', [Validators.required, Validators.minLength(3)]],
			description: ['', [Validators.required, Validators.minLength(10)]],
		  })

		this.didForm = this.fb.group({
            preference1: ['', [Validators.required]],
            preference2: [''],
            preference3: [''],
		}
		);

		this.smsForm = this.fb.group({
            preference1: ['', [Validators.required]],
		}
		);

		this.voiceForm = this.fb.group({
            preference1: ['', [Validators.required]],
		}
		);
	}
  
  ngOnInit(): void {

	this.data.getSuppliers().subscribe(supplier => {
		this.suppliers = supplier.data;

		supplier.data.forEach(element => {
			if(element.sms == "yes"){
				this.smsSupplier.push(element);
			}
			if(element.voice == "yes"){
				this.voiceSupplier.push(element);
			}
			if(element.did == "yes"){
				this.didSupplier.push(element);
			}
		});
	});

    this.data.getpreference().subscribe((result) => {
      this.listdata = result ; 
    });
  }


	addPreference(){
		this.submitted = false;
		if(this.preferenceForm.invalid){
		return ;
		}
		else{
		
		}
	}

  	onPreference(e, type){
	  this.didSupplier.forEach(element => {
		if(e.target[e.target.options.selectedIndex].value == element.key){
			element.selected = "true";
		  }
	  });
	 
		let addedUserId = sessionStorage.getItem("addedUserId");
		let index = e.target.id;
		this.preferenceDID[index] = { index:index, "idsupplier":e.target.value,"idcustomer":addedUserId, "priority": index, type: type };
		
	}

	onSMS(e, type){
		this.didSupplier.forEach(element => {
		  if(e.target[e.target.options.selectedIndex].value == element.key){
			  element.selected = "true";
			}
		});
	   
		  let addedUserId = sessionStorage.getItem("addedUserId");
		  let index = e.target.id;
		  this.preferenceSMS[index] = { index:index, "idsupplier":e.target.value,"idcustomer":addedUserId, "priority": index, type: type };
		 
	}

	onVoice(e, type){
	this.didSupplier.forEach(element => {
		if(e.target[e.target.options.selectedIndex].value == element.key){
			element.selected = "true";
		}
	});
	
		let addedUserId = sessionStorage.getItem("addedUserId");
		let index = e.target.id;
		this.preferenceVoice[index] = { index:index, "idsupplier":e.target.value,"idcustomer":addedUserId, "priority": index, type: type };
		
	}

	resetOptions(){

		$('select').prop('selectedIndex', 0);
		this.didSupplier.forEach(element => {
			element.selected = "false";
		});
	}

	// @to save/update form data
	onSetPreference() {

		this.submitted = true;
		if(this.didForm.invalid){
			return false;
		}
		else{
			this.data.savePreference(JSON.stringify(this.preferenceDID)).subscribe(res => {
				this.responseMessage=res.message;
				setTimeout(()=>{
					this.responseMessage= "";
				  }, 5000);
			}, err => {
				this.responseMessage = err.message;
				setTimeout(()=>{
					this.responseMessage= "";
				  }, 5000);
			});
		}
	}

	onSetSMS(){
		this.submitted = true
		if(this.smsForm.invalid){
			return false;
		}
		else{
			this.data.savePreference(JSON.stringify(this.preferenceSMS)).subscribe(res => {
				this.responseMessage=res.message;
				setTimeout(()=>{
					this.responseMessage= "";
					}, 5000);
			}, err => {
				this.responseMessage=err.message;
				setTimeout(()=>{
					this.responseMessage= "";
					}, 5000);
			});
		}
	}

	onSetVoice(){
		this.submitted = true;
		if(this.voiceForm.invalid){
			return false;
		}
		else{
			this.data.savePreference(JSON.stringify(this.preferenceVoice)).subscribe(res => {
				this.responseMessage=res.message;
				setTimeout(()=>{
					this.responseMessage= "";
					}, 5000);
			}, err => {
				this.responseMessage = err.message;
				setTimeout(()=>{
					this.responseMessage= "";
					}, 5000);
			});
		}
	}
}
