import { Component,EventEmitter,Inject, OnInit, Output } from '@angular/core';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';
import { Router } from '@angular/router';
import { environment } from 'src/environments/environment';
import { UsermanagementService } from '../../usermanagement.service';

@Component({
  selector: 'app-add-card',
  templateUrl: './add-card.component.html',
  styleUrls: ['./add-card.component.css']
})
export class AddCardComponent implements OnInit {
  @Output() addCardClicked = new EventEmitter<any>();
  public cardHeader: any;
  public cardAction: any;
  responseMessage: any;
  errMessage: any;
  stripeCards: any = [];
  isCard: Boolean = false;
  paymentHandler: any;
  isLimitExceeded: Boolean = false;
  auhtorizebutton: boolean;

  constructor(public dialogRef: MatDialogRef<AddCardComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any = {}, public data1: UsermanagementService,
    public router: Router) { 
    }

  ngOnInit(): void {
    this.data1.get_addcard().subscribe((result)=>{
      this.cardHeader = result[0].card_headers;
      this.cardAction = result[0].heading;
    });

    this.data1.stripeCards().subscribe(res => {
      if (res.status == 200) {
        if (res.data.length > 0) {
          this.stripeCards = res.data;
          this.stripeCards.forEach((stripeCard) => {
            if (stripeCard.card_pdf && stripeCard.card_pdf !== null && stripeCard.card_pdf.includes('card_pdf')) {
                stripeCard.authorize = true;
            } else {
                stripeCard.authorize = false;
            }
        });
        if (this.stripeCards.length === 1 && this.stripeCards[0].default && !this.stripeCards[0].authorize) {
           this.auhtorizebutton = true;
          }          
          this.isCard = true;
          if (this.stripeCards.length >= 5) {
            this.isLimitExceeded = true;
          }
          else {
            this.isLimitExceeded = false;
          }
        }
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  cardAuthorization(idstripecard){
    this.router.navigate(['/user/invoice-card-auth/' + idstripecard]);
    this.dialogRef.close({ data: this.data, reload: false });
  }
  
  onClose() {
    this.dialogRef.close({ data: this.data, reload: false });
    window.location.reload();
  }
  closeComponent(){
    this.dialogRef.close('closed');
  }
  createCard(event) {
    const paymentHandler = (<any>window).StripeCheckout.configure({
      key: environment.PublicKey,
      locale: 'auto',
      token: (stripeToken: any) => {
        this.data1.createCard(stripeToken).subscribe(res => {
          if (res.status == 201) {
          this.responseMessage = res.message;
            if(event=='default'){
              this.setDefaultCard(res.customer_id);
            }
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
            this.ngOnInit();
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
          this.data1.sendUpdate(res.message);
        }, err => {
          this.errMessage = err.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        });
      }
    });
    paymentHandler.open({
      name: 'signalmash',
      description: `Enter card Details`,
      amount: 0 * 100,
      panelLabel: 'Add Card',
      shippingAddress: false,
      billingAddress: true,
    });
  }

  deleteCard(customer_id, status, index) {
    if (status == 'true' || status == true) {
      this.errMessage = "Default Card can not be delete!";
      this.addCardClicked.emit({status:'502',message:this.errMessage});
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    }
    else {
      if (confirm("Are You Sure")) {
        this.data1.deleteCard(customer_id).subscribe(res => {
          if (res.status == 201) {
            this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
            this.stripeCards.splice(index, 1);
            this.ngOnInit();
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000)
          }
          this.data1.sendUpdate(res.message);
        }, err => {
          this.errMessage = err.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000)
        });
      }
      else {
        return
      }
    }
  }

  setDefault(customer_id, card_pdf, idstripecard) {
    if(card_pdf && card_pdf!== null && card_pdf.includes('card_pdf')){
      if (confirm("Are You Sure ?")) {
        this.data1.setDefaultCard(customer_id).subscribe(res => {
          if (res.status == 201) {
            this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
            this.ngOnInit();
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
          this.data1.sendUpdate(res.message);
        }, err => {
          this.errMessage = err.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        });
      }
      else {
        return
      }
    }
    else{
      if (confirm("You have to authorized card before make it default card.")) {
        this.dialogRef.close({});
        this.router.navigate(['/user/invoice-card-auth/'+ idstripecard]);
      }
      else{
        return
      }
    }
  }

  setDefaultCard(customer_id) {
    this.data1.setDefaultCard(customer_id).subscribe(res => {
      if (res.status == 201) {
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
        this.ngOnInit();
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

}
