import { Component, ElementRef, EventEmitter, OnInit, Output, ViewChild } from '@angular/core';
import { UsermanagementService } from '../../usermanagement.service';
import * as pdfMake from 'pdfmake/build/pdfmake.js';
import * as pdfFonts from 'pdfmake/build/vfs_fonts.js';
import { environment } from 'src/environments/environment';
import { HttpClient, HttpRequest } from '@angular/common/http';
pdfMake.vfs = pdfFonts.pdfMake.vfs;
(pdfMake as any).vfs = pdfFonts.pdfMake.vfs;
import { DatePipe } from '@angular/common';
import html2PDF from 'jspdf-html2canvas';
import htmlToPdfmake from 'html-to-pdfmake';
import { AuthenticationService } from 'src/app/authentication/authentication.service';
import { MatDialogRef } from '@angular/material/dialog';
@Component({
  selector: 'app-final-invoice',
  templateUrl: './final-invoice.component.html',
  styleUrls: ['./final-invoice.component.css']
})
export class FinalInvoiceComponent implements OnInit {
  @ViewChild('htmlTable') pdfTable: ElementRef;
  @Output() submitClicked = new EventEmitter<any>();
  billData: any = [];
  public billingAddress: any;
  onLoad: boolean = false;
  username: any;
  monthYear: any;
  lastDate: any;
  total: any;
  fromHTML: any;
  current: any;
  responseMessage: any = "";
  idinvoice: any;
  errMessage: any = "";
  currentInvoice: any = [];
  invoiceData1_1: any = [];
  invoiceData1_2: any = [];
  invoiceData2_1: any = [];
  invoiceData2_2: any = [];
  invoiceData3_1: any = [];
  invoiceData3: any = [];
  invoiceData4: any = [];
  invoiceData5: any = [];
  invoiceData6: any = [];
  invoiceData7: any = [];
  invoiceData10: any = [];
  lastMonthInvoice: any = {};
  GrandTotal: number = 0;
  iNumber: any = "";
  calls: any;
  date: any = "";
  newFmt: any = [];
  body: any = [];
  body1: any = [];
  issueDate: any = "";
  status: boolean = false;
  idaccount: any = "";
  invoiceDataForCount: any = [];
  invoiceData1: any = [];
  invoiceData2: any = [];
  totalamt: any = 0;
  totalDue: any;
  finalCharge: any;
  previousDue: any;
  remainingWallet: any;
  taxes: any;
  showModel: boolean = false;
  getextradidMrc: any = 0;
  totalAccSummary: any = "";
  getextradidMrcQty: any;
  Idinvoice: any;
  iduser: any
  constructor(public data: UsermanagementService, public _http: HttpClient, private datePipe: DatePipe, protected authService: AuthenticationService, public dialogRef: MatDialogRef<FinalInvoiceComponent>) { }
  public userInfo: any;
  ngOnInit(): void {

    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.idaccount = session.idaccount;
    this.iduser = session.iduser;
    this.data.get_addcard().subscribe((result) => {
      this.userInfo = result[2].finalinvoice;
    });
    this.data.getInvoiceDetails().subscribe(res => {
      if (res.status == 200) {
        this.submitClicked.emit({ status: res.status, message: res.message });
        this.currentInvoice = res.data;
        this.billingAddress = res.billingAddress;
        this.Idinvoice = this.currentInvoice[0].idinvoice
        this.previousDue = res.previousDue;
        this.totalamt = res.totalamt && res.totalamt ? res.totalamt : 0;
        this.taxes = res.taxes && res.taxes != 'null' ? res.taxes : 0;
        this.remainingWallet = res.remainingWallet && res.remainingWallet != 'null' ? res.remainingWallet.toFixed(2) : '0.00';
        this.finalCharge = res.finalCharge && this.finalCharge != 'null' ? res.finalCharge : '0.00';
        this.totalDue = res.totaldue;
        this.getextradidMrc = res.getextradidMrc.cost ? res.getextradidMrc.cost : 0;
        this.getextradidMrcQty = res.getextradidMrc.did_qty ? res.getextradidMrc.did_qty : 0;
        // this.totalAccSummary = parseFloat(res.getextradidMrc.cost) + parseFloat(this.taxes) + parseFloat(this.previousDue);
        this.totalAccSummary = (parseFloat(res.getextradidMrc.cost) || 0) + (parseFloat(this.taxes) || 0);
        this.status = true;
        this.body.push(
          [{ text: 'Item', style: 'header3' }, { text: 'Quantity', style: 'header3' }, { text: 'Total', style: 'header3' }],
          [{ text: 'Usage/Event Based Charges:\n\nCalling Activity:\n\nCalling/Inbound:', style: 'header3' }, '', ''],
        );
        this.currentInvoice.forEach(data => {
          if (data.category == 1 && data.subcategory == 1) {
            this.invoiceData1_1.push(data);
            this.body.push([{ text: `${data.label}`, style: 'subcategory' }, `${data.value && data.value != 'null' ? data.value : '0'}`, `${data.cost && data.cost != 'null' ? data.cost : '0.00'}`],)
          }
        });
        this.body.push(
          [{ text: '\nCalling/Outbound:', style: 'header3' }, '', ''],
        );
        this.currentInvoice.forEach(data => {
          if (data.category == 1 && data.subcategory == 2) {
            this.invoiceData1_2.push(data);
            this.body.push([{ text: `${data.label}`, style: 'subcategory' }, `${data.value && data.value != 'null' ? data.value : '0'}`, `${data.cost && data.cost != 'null' ? data.cost : '0.00'}`],)
          }
        });
        this.body.push([{ text: '\nMessaging Activity:\n\nSMS/Inbound:', style: 'header3' }, '', ''],);
        this.currentInvoice.forEach(data => {
          if (data.category == 2 && data.subcategory == 1) {
            this.invoiceData2_1.push(data);
            this.body.push([{ text: `${data.label}`, style: 'subcategory' }, `${data.value && data.value != 'null' ? data.value : '0'}`, `${data.cost && data.cost != 'null' ? data.cost : '0.00'}`],)
          }
        });
        this.body.push([{ text: '\nSMS/Outbound:', style: 'header3' }, '', ''],);
        this.currentInvoice.forEach(data => {
          if (data.category == 2 && data.subcategory == 2) {
            this.invoiceData2_2.push(data);
            this.body.push([{ text: `${data.label}`, style: 'subcategory' }, `${data.value && data.value != 'null' ? data.value : '0'}`, `${data.cost && data.cost != 'null' ? data.cost : '0.00'}`],)
          }
        });
        this.body.push([{ text: '\nInformation Services Activity:', style: 'header3' }, '', ''],);
        this.currentInvoice.forEach(data => {
          if (data.category == 8) {
            this.invoiceData3_1.push(data);
            this.body.push([{ text: `${data.label}`, style: 'subcategory' }, `${data.value && data.value != 'null' ? data.value : '0'}`, `${data.cost && data.cost != 'null' ? data.cost : '0.00'}\n`],)
          }
        });
        this.body.push([{ text: '\nNew One-Time and Monthly Recurring Activity:\n Numbering and Campaign Activity:\n\nNumbers:', style: 'header3' }, '', ''],);

        this.currentInvoice.forEach(data => {
          if (data.category == 3 && data.subcategory == 1 || (data.category == 3 && data.subcategory == 0) || (data.category == 3 && data.subcategory == 4) || (data.category == 3 && data.subcategory == 5) || (data.category == 3 && data.subcategory == 6) || (data.category == 3 && data.subcategory == 7) || (data.category == 3 && data.subcategory == 8)) {
            this.invoiceData3.push(data);
            this.body.push([{ text: `${data.label}`, style: 'subcategory' }, `${data.value && data.value != 'null' ? data.value : '0'}`, `${data.cost && data.cost != 'null' ? data.cost : '0.00'}`],)
          }
        });
        this.body.push([{ text: '\nA2P Campaign:', style: 'header3' }, '', ''],);
        this.currentInvoice.forEach(data => {
          if (data.category == 4) {
            this.invoiceData4.push(data);
            this.body.push([{ text: `${data.label}`, style: 'subcategory' }, `${data.value && data.value != 'null' ? data.value : '0'}`, `${data.cost && data.cost != 'null' ? data.cost : '0.00'}`],)
          }
        });

        // this.body.push([{ text: '\nSubscription:', style: 'header3' }, '', ''],);
        // this.currentInvoice.forEach(data => {
        //   if (data.category == 10) {
        //     this.invoiceData10.push(data);

        //     this.body.push([{ text: `${data.label}`, style: 'subcategory' }, `${data.value && data.value != 'null' ? data.value : '0'}`, `${data.cost && data.cost != 'null' ? data.cost : '0.00'}`],)
        //   }
        // })
        const invoiceData10 = this.currentInvoice.filter(data => data.category == 10);
        if (invoiceData10.length > 0) {
          this.body.push([{ text: '\nSubscription:', style: 'header3' }, '', '']);

          invoiceData10.forEach(data => {
            this.invoiceData10.push(data);

            this.body.push([
              { text: `${data.label}`, style: 'subcategory' },
              `${data.value && data.value != 'null' ? data.value : '0'}`,
              `${data.cost && data.cost != 'null' ? data.cost : '0.00'}`
            ]);
          });
        }


        if (Array.isArray(res.data) && res.data.length > 0) {
          this.date = this.datePipe.transform(this.currentInvoice[0].created_at, "MM-dd-yyyy");
          // this.GrandTotal = this.currentInvoice[0].grand_total;
        }
        this.showModel = true;
        this.createPDf();
      }
      else {
        this.submitClicked.emit({ status: res.status, message: res.message });
      }
    }, err => {
      this.errMessage = 'Connection lost on final invoice!';
      setTimeout(() => {
        this.errMessage = "";
      }, 3000);
    }
    );
  }
  createPDf() {
    var target = environment.SERVER + "sendInvoicePdf";
    var _http = this._http
    let payload = JSON.stringify({
      idaccount: this.idaccount,
      iduser: this.iduser,
      federal_status: '2',
      invoice: this.Idinvoice
    });

    const documentDefinition = {
      content: [
        {
          columns: [
            {
              width: '45%',
              text: 'Final Invoice',
              style: 'mr'
            },
            {
              // if you specify both width and height - image will be stretched
              image: 'data:image/png;base64,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\n\n',
              width: 250,
              height: 65
            },
          ],
          // optional space between columns
          columnGap: 50
        },
        {
          columns: [
            {

              width: '87%',
              text: 'Address',
              style: 'header1',
            },

            {

              width: '13%',
              text: 'Invoice No',
              style: 'header1'
            },
          ],
        },
        {
          columns: [
            {

              width: '75%',
              text: '3 Centerpointe Dr # 190',

            },

            {

              width: '25%',
              text: `${this.billingAddress.invoice_number}`,
              style: 'anotherStyle'
            },
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: 'Lake Oswego, OR 97035\n\n'
            }
          ]
        },
        {
          columns: [
            {

              width: '30%',
              text: 'Billed To',
              style: 'header1',
            },
            {

              width: '22%',
              text: 'SAN',
              style: 'header1',
            },
            {

              width: '28%',
              text: 'Customer Name',
              style: 'header1',
            },

            {

              width: '20%',
              text: 'Invoice Date',
              style: 'header1'
            },
          ],
          columnGap: 50
        },
        {
          columns: [
            {

              width: '30%',
              text: `${this.billingAddress.address1}`,

            },
            {

              width: '22%',
              text: `${this.billingAddress.san}`,

            },
            {

              width: '28%',
              text: `${this.billingAddress.customer_name}`,

            },

            {

              width: '20%',
              text: `${this.date}`,
              style: 'anotherStyle',
            },
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `${this.billingAddress.city}, ${this.billingAddress.state}`
            }
          ]
        },
        {
          columns: [
            {
              width: '100%',
              text: `${this.billingAddress.postal_code}`
            }
          ]
        },
        {
          columns: [
            {
              width: '100%',
              text: `${this.billingAddress.country}`
            }
          ]
        },
        {
          columns: [
            {
              width: '100%',
              text: `${this.billingAddress.email}\n\n`
            }
          ]
        },
        { text: '', style: 'space' },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.5, lineColor: '#b6b2b2' }] },
        { text: '', style: 'space' },
        { text: 'Final Account Summary', style: 'header2' },
        { text: '', style: 'space' },
        {
          columns: [
            {
              width: '50%',
              text: 'Item',
              style: 'header',
            },

            {
              width: '30%',
              text: 'Quantity',
              style: 'header'
            },
            {
              width: '20%',
              text: 'Total',
              style: 'header'
            }
          ],
        },
        { text: '', style: 'space' },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.5, lineColor: '#b6b2b2' }] },
        { text: '', style: 'space' },
        {
          columns: [
            {

              width: '50%',
              text: 'Previous Balance Due',
            },

            {
              width: '30%',
              text: ''
            },
            {
              width: '20%',
              text: `${this.previousDue !== undefined && this.previousDue !== null && this.previousDue ? this.previousDue : '0.00'}`
            }
          ],
        },
        { text: '', style: 'space' },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.5, lineColor: '#b6b2b2' }] },
        { text: '', style: 'space' },
        {
          columns: [
            {

              width: '50%',
              text: 'Final Charges',
            },

            {
              width: '30%',
              text: `${this.getextradidMrcQty}`
            },
            {
              width: '20%',
              text: `${(this.getextradidMrc.toFixed(2))}`
            }
          ],
        },
        { text: '', style: 'space' },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.5, lineColor: '#b6b2b2' }] },
        { text: '', style: 'space' },
        {
          columns: [
            {

              width: '50%',
              text: '',
            },

            {
              width: '30%',
              text: 'Taxes'
            },
            {
              width: '20%',
              text: `${this.taxes}`
            }
          ],
        },
        { text: '', style: 'space' },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.5, lineColor: '#b6b2b2' }] },
        { text: '', style: 'space' },
        {
          columns: [
            {

              width: '50%',
              text: '',
            },

            {
              width: '30%',
              text: 'Total Due'
            },
            {
              width: '20%',
              text: `${(this.totalAccSummary).toFixed(2)}`
            }
          ],
        },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.5, lineColor: '#b6b2b2' }] },
        { text: '', style: 'space1' },
        { text: '\nFinal Recurring Charges', style: 'header2' },
        { text: '', style: 'space' },
        {
          columns: [
            {
              width: '50%',
              text: 'Item',
              style: 'header',
            },

            {
              width: '30%',
              text: 'Quantity',
              style: 'header'
            },
            {
              width: '20%',
              text: 'Total',
              style: 'header'
            }
          ],
        },
        { text: '', style: 'space' },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 2, lineColor: 'black' }] },
        { text: '', style: 'space' },
        {
          columns: [
            {

              width: '50%',
              text: 'Numbers:', style: 'number',
            },

            {
              width: '30%',
              text: ''
            },
            {
              width: '20%',
              text: ''
            }
          ],
        },
        { text: '', style: 'space' },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.1, lineColor: '#b6b2b2' }] },
        {
          columns: [
            {
              width: '50%',
              text: 'Remaining Wallet',
            },
            {
              width: '30%',
              text: '0'
            },
            {
              width: '20%',
              text: `${this.remainingWallet !== undefined && this.remainingWallet !== null && this.remainingWallet ? this.remainingWallet : '0.00'}`
            }
          ]
        },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.1, lineColor: '#b6b2b2' }] },
        {
          columns: [
            {
              width: '50%',
              text: 'Extra Did MRC',
            },
            {
              width: '30%',
              text: `${this.getextradidMrcQty}`
            },
            {
              width: '20%',
              text: `${(this.getextradidMrc).toFixed(2)}`
            }
          ]
        },
        { text: '', style: 'space' },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.5, lineColor: '#b6b2b2' }] },
        { text: '', style: 'space' },
        // dynomic data under Platform Activity Charges
        {
          columns: [
            {
              width: '80%',
              // text: `\nPlatform Activity Charges (${this.currentInvoice[0].last_date})\n\n`,
              text: `\nPlatform Activity Charges\n\n`,
              style: 'header1',
            }
          ]
        },
        {
          layout: 'lightHorizontalLines',
          table: {
            headerRows: 1,
            widths: ['50%', "30%", '20%'],

            body: this.body,
          }
        },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.1, lineColor: '#b6b2b2' }] },
        {
          columns: [
            {
              width: '80%',
              text: 'Total Amount(USD):',
              style: 'anotherStyle1'
            },
            {
              width: '20%',
              text: `$ ${(+this.totalamt + +this.totalAccSummary).toFixed(2)}\n\n`,
              style: 'anotherStyle1'
            }
          ]
        },
        {
          columns: [
            {
              width: '67%',
              text: 'Payment Information',
              style: 'header1'
            },
            {
              width: '33%',
              text: 'Questions regarding this note?\n\n',
              style: 'header2'
            }
          ]
        },
        {
          columns: [
            {
              width: '45%',
              text: 'One-time credit card payments may be made via the Signalmash portal. Automated payment controls and account reminders can also be accessed in the My Profile section of the Signalmash portal.\n\n Bank Wire / ACH payments - please contact us at billing@signalmash.com for ACH and/or Wire Transfer instructions.',
              style: 'payment'
            },

            {
              width: '20%',
              text: ' ',

            },
            {
              width: '35%',
              text: 'Contact: billing@signalmash.com',
              style: 'payment',
            }
          ]
        },
      ],

      styles: {
        header: {
          fontSize: 12,
          bold: true,
          color: '#000000',
          padding: [5, 5, 5, 0]
        },
        header1: {
          fontSize: 13,
          bold: true,
          color: '#0339fc'
        },
        header2: {
          fontSize: 12,
          bold: true,
          color: '#0339fc'
        },
        column: {
          background: '#0339fc',

        },
        header3: {
          fontSize: 12,
          bold: true,
          padding: [5, 5, 5, 0]
        },
        subcategory: {
          margin: [18, 0, 0, 0],
        },
        note: {
          fontSize: 7,
        },
        date: {
          color: '#0339fc'
        },
        payment: {
          fontSize: 10,
        },
        mr: {
          fontSize: 18,
          bold: true,
          color: '#0339fc',
          margin: [0, 18, 0, 0],
        },
        anotherStyle: {
          alignment: 'right',
          bold: 'true'
        },
        anotherStyle1: {
          fontSize: 14,
          bold: 'true',
          color: '#0339fc',
          paddingTop: '20px',
        }
      }
    };

    //pdfMake.createPdf(documentDefinition).download(`chakrawarti`);
    const pdfDocGenerator = pdfMake.createPdf(documentDefinition);
    pdfDocGenerator.getBlob((blob) => {
      const pdfBlob = new Blob([blob], { type: 'application/pdf' });
      const fd = new FormData();
      fd.append("UPLOAD", pdfBlob, 'pdf');
      fd.append("data", payload);
      const req = new HttpRequest('POST', target, fd, {
        reportProgress: true
      });
      _http.request(req).subscribe((res: any) => {

      }, err => {
        this.errMessage = 'Connection lost while generating pdf!';
        setTimeout(() => {
          this.errMessage = "";
        }, 3000);
      })
    });
  }


  logoutSession() {
    this.data.confirmInvoice(this.idaccount).subscribe(res => {
      if (res.status == 200) {
        this.dialogRef.close({ data: {}, reload: false });
        this.authService.logout();
      }
      else {
        this.errMessage = res.message;
      }
    });
  }
}
