import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { environment } from 'src/environments/environment';
import { UsermanagementService } from '../../usermanagement.service';

@Component({
  selector: 'app-payment-method',
  templateUrl: './payment-method.component.html',
  styleUrls: ['./payment-method.component.css']
})
export class PaymentMethodComponent implements OnInit {

  submitted: boolean;
  responseMessage: any;
  subbmitted: boolean = false;
  errMessage: any = "";
  stripeCards: any = [];
  isCard: Boolean = false;
  paymentHandler: any;
  isNewCard: Boolean = false;
  auhtorizebutton: boolean =false;

  userType:any;
  curaccount: any
  roles_permissions: any = [];
  onlyRead: boolean = false;

  loaded: boolean =false;
 
  constructor(private data: UsermanagementService, public router: Router) { }

  ngOnInit(): void {
    this.curaccount = JSON.parse(sessionStorage.getItem("isLoggedIn"));
    this.userType = this.curaccount.type;

    this.data.stripeCards().subscribe(res => {
      if (res.status == 200) {
        if (res.data.length > 0) {
          this.stripeCards = res.data;
          this.stripeCards.forEach((stripeCard) => {
            if (stripeCard.card_pdf && stripeCard.card_pdf !== null && stripeCard.card_pdf.includes('card_pdf')) {
                stripeCard.authorize = true;
            } else {
                stripeCard.authorize = false;
            }
        });
        if (this.stripeCards.length === 1 && this.stripeCards[0].default && !this.stripeCards[0].authorize) {
           this.auhtorizebutton = true;
          }
          this.isCard = true;
          this.loaded = true;
          if (this.stripeCards.length >= 5) {
            this.isNewCard = true;
          }
          else {
            this.isNewCard = false;
          }
        }
      }
      else {
        this.loaded = true;
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });

    this.invokeStripe();
    this.getUserPermissions();
  }

  getUserPermissions() {
    this.data.getPermissions().subscribe((res) => {
      if (res.status == 200) {
        this.roles_permissions = res.data;
        this.roles_permissions.forEach((item) => {
          let user_type_name : any = item.id_user_type == '1' ? '201' :item.id_user_type == '2' ? '202' :item.id_user_type == '3' ? '203' : item.id_user_type == '4' ? '231' : item.id_user_type == '5' ? '232' : ''
          if (item.feature_id == 4 && item.read == 1 && item.write == 0 && (this.userType==user_type_name)) {
            this.onlyRead = true;
          }
          else if (item.feature_id == 4 && item.write == 1 && item.read == 0 && (this.userType==user_type_name)) {
            this.onlyRead = false;
          }
        });
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 3000);
      }
    });
  }


  cardAuthorization(idstripecard){
    this.router.navigate(['/user/invoice-card-auth/' + idstripecard]);
  }
  createCard() {
    const paymentHandler = (<any>window).StripeCheckout.configure({
      key: environment.PublicKey,
      locale: 'auto',
      token: (stripeToken: any) => {
        this.data.createCard(stripeToken).subscribe(res => {
          if (res.status == 201) {
            this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        }, err => {
          this.errMessage = err.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        });
        this.ngOnInit();
      }

    });
    paymentHandler.open({
      name: 'signalmash',
      description: `Enter card Details`,
      amount: 0 * 100,
      panelLabel: 'Add Card',
      shippingAddress: false,
      billingAddress: true,
    });


  }


  setDefault(customer_id, card_pdf, idstripecard) {
    if(card_pdf && card_pdf!== null && card_pdf.includes('card_pdf')){
      if (confirm("Are You Sure ?")) {
        this.data.setDefaultCard(customer_id).subscribe(res => {
          if (res.status == 201) {
            this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
            this.ngOnInit();
          }

          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        }, err => {
          this.errMessage = err.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        });
      }
      else {
        return
      }
    }
    else {
      if (confirm("You have to authorized card before make it default card.")) {
        this.router.navigate(['/user/invoice-card-auth/' + idstripecard]);
      }
      else {
        return
      }
    }
  }

  deleteCard(customer_id, status, index) {
    if (status == 'true') {
      this.errMessage = "Default Card can not be delete!";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    }
    else {
      if (confirm("Are You Sure")) {
        this.data.deleteCard(customer_id).subscribe(res => {
          if (res.status == 201) {
            this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
            this.stripeCards.splice(index, 1);
            this.ngOnInit();
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000)
          }
        }, err => {
          this.errMessage = err.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000)
        });
      }
      else {
        return;
      }
    }
  }


  invokeStripe() {
    if (!window.document.getElementById('stripe-script')) {
      const script = window.document.createElement("script");
      script.id = "stripe-script";
      script.type = "text/javascript";
      script.src = "https://checkout.stripe.com/checkout.js";
      //script.src = "https://js.stripe.com/v3";
      script.onload = () => {
        this.paymentHandler = (<any>window).StripeCheckout.configure({
          key: environment.PublicKey,
          locale: 'auto',
          token: (stripeToken: any) => {
            alert('Payment has been successfull!');
          }
        });
      }
      window.document.body.appendChild(script);
    }
  }

  current_datetime() {
    let now = new Date();
    let year = "" + now.getFullYear();
    let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
    let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
    let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
    let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
    let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
    return year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second;
  }

}
