import { Component, Input, OnInit, Output, EventEmitter } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { element } from 'protractor';
import { Observable } from 'rxjs';
import { TariffService } from 'src/app/tariff/tariff.service';
import { UsermanagementService } from '../usermanagement.service';

@Component({
  selector: 'app-rates',
  templateUrl: './rates.component.html',
  styleUrls: ['./rates.component.css']
})
export class RatesComponent implements OnInit {
  
  @Input() rates?:Observable<any>;
  @Input() features:Observable<any>;
  @Input() type:boolean=false;
  @Output() OnRates = new EventEmitter();
  @Input() idtariff?: any;
  @Input() inboundRates?: any;
  
  newFeatures: any;
  public rateForm:FormGroup;
  public rateshow1: boolean = false;
  headers:any;
  list: any;
  responseMessage = "";
  status: boolean = false;

  constructor( private data: UsermanagementService, public fb: FormBuilder, private tariffService: TariffService ) { }

  ngOnInit(): void {


		this.data.getrecord().subscribe((result) => {
			this.headers = result[0].headers_details;
			this.list = result[0].profile_details;
		});

		if(this.inboundRates!=undefined){
			this.inboundRates.subscribe(res=>{
				this.newFeatures = res.data;
				this.status = true;
				let tmp=[];	
				res.data.forEach(element => {
					tmp["idbillingrate_"+ element.idinbound_rates] = [element.idbilling_rate];
					tmp["idpriority_"+ element.idinbound_rates] = [element.idinbound_rates];
					tmp["idtariff_"+ element.idinbound_rates] = [this.idtariff];
					tmp["feature_"+element.idinbound_rates] = [element.feature];
					tmp["usage_"+element.idinbound_rates]=[element.usage];
					tmp["recurringmrc_"+element.idinbound_rates]=[element.recurring_mrc];
					tmp["setup_"+element.idinbound_rates]=[element.setup];
					tmp["portinnrc_"+element.idinbound_rates]=[element.port_in_nrc];
					tmp["portoutnrc_"+element.idinbound_rates]=[element.port_out_nrc];
					tmp["disconnect_"+element.idinbound_rates]=[element.disconnect];
				});

				this.rateForm = this.fb.group(tmp);
				this.rateshow1=true;
			});
		}
		else{
			this.features.subscribe(features => {
				this.newFeatures = features.data;
				let tmp=[];
				this.status = true;
				this.newFeatures.forEach(element => {
					tmp["idpriority_"+ element.idinbound_rates] = [element.idinbound_rates];
					tmp["idtariff_"+ element.idinbound_rates] = [this.idtariff];
					tmp["feature_"+element.idinbound_rates] = [element.feature];
					tmp["usage_"+element.idinbound_rates]=[0];
					tmp["recurringmrc_"+element.idinbound_rates]=[0];
					tmp["setup_"+element.idinbound_rates]=[0];
					tmp["portinnrc_"+element.idinbound_rates]=[0];
					tmp["portoutnrc_"+element.idinbound_rates]=[0];
					tmp["disconnect_"+element.idinbound_rates]=[0];
				});
				this.rateForm = this.fb.group(tmp);
				this.rateshow1=true;
			});
		}
  	}

 	saveRates(){

	let response: any = [];
    response[0]=[];
    response[1]=[];
    response[2]=[];
    response[3]=[];
    response[4]=[];
    response[5]=[];
    response[6]=[];
    response[7]=[];
    response[8]=[];
    response[9]=[];
	response[10]=[];
	response[11]=[];
	response[12]=[];

    for(let key of Object.keys(this.rateForm.value)){
      let tmp=key.split('_');
      response[tmp[1]].push({field: tmp[0], value: this.rateForm.value[key]});
    }
         let temp = response.slice(1, 13);
        if(this.inboundRates != undefined){
          this.data.updaterates(temp).subscribe(resp => {
            this.responseMessage = resp.message;  
            setTimeout(()=>{
              this.responseMessage= "";
            }, 5000);
          });
        }
        else{
          this.data.saveRates(temp).subscribe(resp => {
            this.responseMessage = resp.message;  
            setTimeout(()=>{
              this.responseMessage= "";
            }, 5000);
          });
        }

		
		// let tmp:any=this.rateForm.value;
		// console.log(tmp);
		// let data:any=[];
		// let values:any={};
		// //values[0]={"type":1};
		// Object.keys(tmp).forEach(key => {
		// 	let array = key.split('_');
		// 	if(array[0]=="usage")
		// 		values={};
		// 	values[array[0].toString()]=tmp[key];

		// 	if(array[0]=="disconnect")
		// 		data.push({key:array[1], data: values});
		// });

		// this.OnRates.emit(data);
	}
}
