import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { FormBuilder, FormGroup, FormControl} from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { UsermanagementService } from '../usermanagement.service';

@Component({
  selector: 'app-tier',
  templateUrl: './tier.component.html',
  styleUrls: ['./tier.component.css']
})

export class TierComponent extends AppComponentClass<any, any> {

	showMsg: boolean = false;
 	p: number = 1;
	rowdata: any;
	ro: any;
	row: any;
	details: any;
	listdata: any;
	record:any;
	list:any;
	// defaultSelect : any = 1;
	page = 1;
	count = 0;
	tableSize = 5;
	tableSizes = [ 5, 9, 12];
	modelform:any;

  public show: boolean = false;
  public package: any;
  public buttonName: any = "Add";
  public tiermanagementForm: FormGroup;
  public submitted : boolean = false;
  filterTerm: string;
  fileToUpload: File = null;
  file:any;


    suppliers:any = '';
	billing_rate:any = '';
	feature:any = '';

	tier0BillData: any = [];
	tier1BillData: any = [];
	tier2BillData: any = [];
	tier3BillData: any = [];
	tier4BillData: any = [];
	tier5BillData: any = [];
	tier6BillData: any = [];
	tier7BillData: any = [];
	tier8BillData: any = [];
	tier9BillData: any = [];
	tier10BillData: any = [];
	tier11BillData: any = [];

  constructor(public data: UsermanagementService, public router: Router, public fb: FormBuilder) {
		super(data, router, fb);
	}

  
  ngOnInit(): void {

	this.data.getSuppliers().subscribe(supplier => {
		this.suppliers = supplier.data;
		console.log(this.suppliers);
	});

		this.data.gettier().subscribe((result) => {
			this.listdata = result[0].headers
			this.row = result[0].invoice
			console.log(this.listdata)
		  });

		  this.data.getrecord().subscribe((result) => {
			this.record = result[0].headers_details  ;
			this.list = result[0].profile_details ;
	
			console.log(this.list)
		  });  
  	}

	onSubmit(){
		console.log("data", this.tiermanagementForm);
	}

	downloadMyFile(): void {
		this.data
		  .download('./assets/sample-csv/ratelist-sample.csv')
		  .subscribe(blob => {
			const a = document.createElement('a')
			const objectUrl = URL.createObjectURL(blob)
			a.href = objectUrl
			a.download = 'ratelist-sample.csv';
			a.click();
			URL.revokeObjectURL(objectUrl);
		  })
	  }

	handleFileInput(files) {
		let sessionid = 32;
		let filetype = "agent guide";
		files.item(0)["sessionid"] = sessionid;
		files.item(0)["filetyepe"] = filetype;
		this.fileToUpload = files.item(0);
		console.log(files.item(0));
		this.data.postFile(this.fileToUpload,sessionid,filetype).subscribe(res => {
		  console.log(res);
		  this.file = res.filename;
		  console.log("check1");
		}, error => {
		  console.log(error);
		});
	}

  //   Tier Management Code

  loadData(e: any) {
	  console.log("e::", e)
	  let id_supplier = e.srcElement.value
	  // alert(id_supplier)

	  this.data.getRate(id_supplier).subscribe((result)=>{
		  console.log("result rate ::", result)

		  this.billing_rate = result.data;
		  console.log(this.billing_rate);
	  })
  }

  loadBill(e: any, tier: any) {
	  console.log("e::", e)
	  let tierId = e.srcElement.value
	  console.log("Bill ID::", tierId)
	  console.log("tier::", tier)
	  
	  // @for tier 0 data
	  if (tier == "Tier 0 DID") {
		  this.tier0BillData = []
		  for (let x of this.billing_rate) {
			  if (x.idinbound_rates == tierId) {
				  this.tier0BillData.push(x)
			  }
		  }
		  console.log("this.tier0BillData::", this.tier0BillData)
	  }

	  // @for tier 1 data
	  if (tier == "Tier 1 DID") {
		  this.tier1BillData = []
		  for (let x of this.billing_rate) {
			  if (x.idinbound_rates == tierId) {
				  this.tier1BillData.push(x)
			  }
		  }
		  console.log("this.tier1BillData::", this.tier1BillData)
	  }

	  // @for tier 2 data
	  if (tier == "Tier 2 DID") {
		  this.tier2BillData = []
		  for (let x of this.billing_rate) {
			  if (x.idinbound_rates == tierId) {
				  this.tier2BillData.push(x)
			  }
		  }
		  console.log("this.tier2BillData::", this.tier2BillData)
	  }

	  // @for tier 3 data
	  if (tier == "Tier 3 DID") {
		  this.tier3BillData = []
		  for (let x of this.billing_rate) {
			  if (x.idinbound_rates == tierId) {
				  this.tier3BillData.push(x)
			  }
		  }
		  console.log("this.tier3BillData::", this.tier3BillData)
	  }
	  // @for tier 4 data
	  if (tier == "Tier 4 DID") {
		  this.tier4BillData = []
		  for (let x of this.billing_rate) {
			  if (x.idinbound_rates == tierId) {
				  this.tier4BillData.push(x)
			  }
		  }
		  console.log("this.tier4BillData::", this.tier4BillData)
	  }
	  // @for tier 5 data
	  if (tier == "Toll Free DID") {
		  this.tier5BillData = []
		  for (let x of this.billing_rate) {
			  if (x.idinbound_rates == tierId) {
				  this.tier5BillData.push(x)
			  }
		  }
		  console.log("this.tier5BillData::", this.tier5BillData)
	  }
  }

  loadBilling(e: any, tier: any) {
	  console.log("e::", e)
	  let checkId = e.srcElement.value
	  console.log("Bill ID::", checkId)

	  // @for tier 6 data
	  if (tier == "e911") {
		  this.tier6BillData = []
		  for (let x of this.billing_rate) {
			  if (x.idinbound_rates == checkId) {
				  this.tier6BillData.push(x)
			  }
		  }
		  console.log("this.tier6BillData::", this.tier6BillData)
	  }
	  // @for tier 7 data
	  if(tier == "Cnam Out") {
		  this.tier7BillData = []
		  for (let x of this.billing_rate) {
			  if (x.idinbound_rates == checkId) {
				  this.tier7BillData.push(x)
			  }
		  }
	  console.log("this.tier7BillData::", this.tier7BillData)
	  }

	  // @for tier 8 data
	  if(tier == "Cnam In") {
		  this.tier8BillData = []
		  for (let x of this.billing_rate) {
			  if (x.idinbound_rates == checkId) {
				  this.tier8BillData.push(x)
			  }
		  }
	  console.log("this.tier8BillData::", this.tier8BillData)
	  }

	  // @for tier 7 data
	  if(tier == "PSTN") {
		  this.tier9BillData = []
		  for (let x of this.billing_rate) {
			  if (x.idinbound_rates == checkId) {
				  this.tier9BillData.push(x)
			  }
		  }
	  console.log("this.tier9BillData::", this.tier9BillData)
	  }
	  // @for tier 7 data
	  if(tier == "LNP Cancel") {
		  this.tier10BillData = []
		  for (let x of this.billing_rate) {
			  if (x.idinbound_rates == checkId) {
				  this.tier10BillData.push(x)
			  }
		  }
	  console.log("this.tier10BillData::", this.tier10BillData)
	  }
	  // @for tier 7 data
	  if(tier == "Unprovisioned e911") {
		  this.tier11BillData = []
		  for (let x of this.billing_rate) {
			  if (x.idinbound_rates == checkId) {
				  this.tier11BillData.push(x)
			  }
		  }
	  console.log("this.tier11BillData::", this.tier11BillData)
	  }
	  
  }
}

