import { Component, EventEmitter, OnInit, Output } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { Router } from '@angular/router';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { UsermanagementService } from '../usermanagement.service';

@Component({
  selector: 'app-upload',
  templateUrl: './upload.component.html',
  styleUrls: ['./upload.component.css']
})
export class UploadComponent extends AppComponentClass<any, any> {

	@Output() onFile = new EventEmitter();

	p: number = 1;
	rowdata: any;
	listdata: any;
  modelform: any;
  public show: boolean = false;
  public package: any;
  public buttonName: any = "Add";
  public fileForm: FormGroup;
  public submitted : boolean = false;
  filterTerm: string;
  fileType: any;
  fileName: any;

  constructor(public data: UsermanagementService, public router: Router, public fb: FormBuilder) {
		super(data, router, fb);
		
	}
  
  ngOnInit(): void {

	this.fileForm = new FormGroup({
		fileName: new FormControl(null,[Validators.required])
	});

    this.data.getdidupload().subscribe((result) => {
	  this.modelform = result ; 
      console.log(result)
    });
}

	onFilePicked(event: Event){
		const file = (event.target as HTMLInputElement).files[0];
		this.fileForm.patchValue({
			fileName: file,
		});
		this.fileName = file.name;

		this.fileForm.get("fileName").updateValueAndValidity();
	}


	onSaveFile(event: Event) {
    const file = (event.target as HTMLInputElement).files[0];
		this.fileForm.patchValue({
			fileName: file,
		});
		// this.fileName = file.name;

	    	this.fileForm.get("fileName").updateValueAndValidity();

	
			this.onFile.emit(this.fileForm.value.fileName);


		// this.data.saveFile(this.fileForm.value.fileName).subscribe(res => {
		// 	console.log(res);

		//   }, error => {
		// 	console.log(error);
		//   });
	}
	 
}
