import { HttpClient, HttpHeaders } from "@angular/common/http";
import { Injectable } from "@angular/core";
import { resourceUsage } from "node:process";
import { Observable, Subject } from "rxjs";
import { environment } from "src/environments/environment";
import { LoaderEnabled } from "../shared/loader/loader.service";
import { AppService } from "../shared/service/AppService.class";

@Injectable({
  providedIn: 'root'
})


export class UsermanagementService extends AppService<any>  {
  private subjectName = new Subject<any>();
  sendUpdate(message: string) {
    this.subjectName.next({ text: message });
  }

  getUpdate(): Observable<any> {
    return this.subjectName.asObservable();
  }
  // getallData(arg0: { iduser: any; idaccount: any; }) {
  //   throw new Error('Method not implemented.');
  // }

  httpHeaders: any = new HttpHeaders({
    "Content-Type": "application/json"
  });

  public getpaymentsetting(): Observable<any> {
    return this.http.get('./assets/paymentsetting.json');
  }

  getratesms() {
    throw new Error('Method not implemented.');
  }

  constructor(public http: HttpClient) {
    super(http);
    this.appmod = "usermanagement";
  }

  public gettier(): Observable<any> {
    return this.http.get('./assets/tier.json');
  }

  @LoaderEnabled()
  userLogin(userLogin): Observable<any> {
    this.appmod = 'login';
    let result = super.saveService(userLogin);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  userMorphingLogin(userLogin): Observable<any> {
    this.appmod = 'morphinglogin';
    let result = super.saveService(userLogin);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  companyProfile(): Observable<any> {
    this.appmod = "company";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  updateCompanyProfile(data): Observable<any> {
    this.appmod = "company";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  AdminRecharge(data): Observable<any> {
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    let apiUrl = environment.SERVER + "recharge";
    return this.http.post(apiUrl, data, { headers: httpHeaders });
  }

  public postFile(fileToUpload: File, sessionid, filetype): Observable<any> {
    const endpoint = environment.SERVER + 'uploads/document_upload';
    const formData: FormData = new FormData();
    formData.append('fileKey', fileToUpload, fileToUpload.name);
    formData.append('filetype', filetype);
    formData.append('sessionid', sessionid);
    let httpHeaders = new HttpHeaders()
    return this.http
      .post(endpoint, formData, { headers: httpHeaders });
  }

  @LoaderEnabled()
  public saveFile(profile_pic: File | string): Observable<any> {

    const apiURL = environment.SERVER + 'uploads/profile_pic';

    let formData = new FormData();

    formData.append("profile_pic", profile_pic);
    let httpHeaders = new HttpHeaders({
    });

    return this.http.post(apiURL, formData, { headers: httpHeaders });
  }

  @LoaderEnabled()
  getBalance(): Observable<any> {
    this.appmod = "getbalance";
    let result = this.getService();
    this.appmod = "usermanagement";
    return result;
  }

  getcustBalance(data: any): Observable<any> {
    const apiURL = environment.SERVER + 'getcustbalance';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiURL, { headers: httpHeaders, params: data });
  }


  @LoaderEnabled()
  getFeature(): Observable<any> {
    this.appmod = "tier/get_feature";
    let tmp = this.getService();
    this.appmod = "usermanagement";
    return tmp;
  }

  @LoaderEnabled()
  getRate(data?: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'tier/billing_rate';
    let result = super.getService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  getSuppliers(): Observable<any> {
    this.appmod = "supplier";
    let tmp = this.getService();
    this.appmod = "usermanagement";
    return tmp;
  }

  @LoaderEnabled()
  getUsers(type: string): Observable<any> {
    this.appmod = "user";
    let tmp = this.getService(type);
    this.appmod = "usermanagement";
    return tmp;
  }

  @LoaderEnabled()
  getResellerUsers(): Observable<any> {
    this.appmod = "getResellerUsers";
    let tmp = this.getService();
    this.appmod = "usermanagement";
    return tmp;
  }
  @LoaderEnabled()
  getResellerTariff(type: any): Observable<any> {
    this.appmod = "getResellerTariff";
    let tmp = this.getService(type);
    this.appmod = "usermanagement";
    return tmp;
  }

  // added function for dropdown userlist
  @LoaderEnabled()
  customerList(): Observable<any> {
    this.appmod = "customerList";
    let tmp = this.getService();
    this.appmod = "usermanagement";
    return tmp;
  }
  // closed here

  @LoaderEnabled()
  getSubListUsers(data: any): Observable<any> {
    const apiURL = environment.SERVER + 'users';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiURL, { headers: httpHeaders, params: data });
  }

  @LoaderEnabled()
  getAllUsers(data?: any): Observable<any> {
    const apiURL = environment.SERVER + 'getAllUsers';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiURL, { headers: httpHeaders, params: data });
  }

  @LoaderEnabled()
  getSingleUsers(): Observable<any> {
    this.appmod = "singleuser";
    let tmp = this.getService();
    this.appmod = "usermanagement";
    return tmp;
  }

  // @LoaderEnabled()
  getSingleUsersForAdmin(iduser?: string): Observable<any> {
    this.appmod = "getSingleUsersForAdmin";
    let tmp = this.getService(iduser);
    this.appmod = "usermanagement";
    return tmp;
  }

  getCustSubListUsers(data: any): Observable<any> {
    const apiURL = environment.SERVER + 'users';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiURL, { headers: httpHeaders, params: data });
  }

  @LoaderEnabled()
  getMyTariff(id: number): Observable<any> {
    this.appmod = "getTariff";
    let data = super.getService(id.toString());
    this.appmod = "usermanagement";
    return data;
  }

  @LoaderEnabled()
  getUser(type: any): Observable<any> {
    const apiURL = environment.SERVER + 'user';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiURL, { headers: httpHeaders, params: type });

    // this.appmod="user";
    // let tmp=this.getService(type);
    // this.appmod="usermanagement";
    // return tmp;
  }

  download(url: string): Observable<Blob> {
    return this.http.get(url, {
      responseType: 'blob'
    });
  }

  @LoaderEnabled()
  SaveUserData(data: any): Observable<any> {
    this.appmod = "user";
    let result = super.saveService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  getCountry(): Observable<any> {
    this.appmod = "get-country";
    let tmp = this.getService();
    this.appmod = "usermanagement";
    return tmp;
  }

  // updatepaymentsetting



  // @LoaderEnabled()
  // deleteUserSingleData(key: any){
  //   this.appmod="user";
  //   let result = super.deleteService(key);
  //   this.appmod="usermanagement";
  //   return result;
  // }

  @LoaderEnabled()
  SaveAdminData(data: any): Observable<any> {
    this.appmod = "admin";
    let result = super.saveService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  savePreference(data: any): Observable<any> {
    this.appmod = "preference";
    let result = super.saveService(data);
    // this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  getPreference(data: any): Observable<any> {
    const apiURL = environment.SERVER + 'preference';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiURL, { headers: httpHeaders, params: data });
  }

  @LoaderEnabled()
  updatePreference(data: any): Observable<any> {
    const apiURL = environment.SERVER + 'updatepreference';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.put(apiURL, data, { headers: httpHeaders });
  }

  @LoaderEnabled()
  resetPass(data: any): Observable<any> {
    const apiURL = environment.SERVER + 'resetPass';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.put(apiURL, data, { headers: httpHeaders });
  }

  @LoaderEnabled()
  saveRates(data: any): Observable<any> {
    ;
    this.appmod = "tier/save_rate";
    let result = super.saveService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  updaterates(data: any): Observable<any> {
    this.appmod = "tier/update_rate";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  // @LoaderEnabled()
  onDeleteAccount(data: any): Observable<any> {
    this.appmod = "deleteAccount";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }
  // @LoaderEnabled()
  // onFinalDeleteAccount(data: any): Observable<any> {
  //   this.appmod = "final_delete_account";
  //   let result = super.updateService(data);
  //   this.appmod = "";
  //   return result;
  // }

  // @LoaderEnabled()
  onFinalDeleteAccount(data: any): Observable<any> {
    this.appmod = "adminCloseCustomerAccount";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }
  
  @LoaderEnabled()
  saveUser(type, data: any): Observable<any> {
    this.appmod = type;
    let result = super.saveService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  savewhitelablel(data: any): Observable<any> {
    this.appmod = "white-label";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  public getrates(): Observable<any> {
    return this.http.get('./assets/tierreports.json');
  }

  @LoaderEnabled()
  emailVerify(data: any): Observable<any> {

    const apiURL = environment.SERVER + 'emailverify';
    let httpHeaders = new HttpHeaders({
    });

    return this.http.post(apiURL, data, { headers: httpHeaders });
  }

  @LoaderEnabled()
  saveOtp(otp: any): Observable<any> {
    const apiURL = environment.SERVER + 'saveotp';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });

    return this.http.post(apiURL, otp, { headers: httpHeaders });
  }

  @LoaderEnabled()
  saveOtpbyCall(data: any): Observable<any> {
    const apiURL = environment.SERVER + 'sendotpCall';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });

    return this.http.post(apiURL, data, { headers: httpHeaders });
  }


  @LoaderEnabled()
  verifyOtp(otp: any): Observable<any> {
    const apiURL = environment.SERVER + 'signup_verifyOtp';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });

    return this.http.post(apiURL, otp, { headers: httpHeaders });
  }

  @LoaderEnabled()
  stripeCard(): Observable<any> {
    const apiURL = environment.SERVER + 'stripe-card';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });

    return this.http.get(apiURL, { headers: httpHeaders });
  }

  @LoaderEnabled()
  stripeCards(): Observable<any> {
    const apiURL = environment.SERVER + 'stripe-cards';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });

    return this.http.get(apiURL, { headers: httpHeaders });
  }

  stripeCardsForDelete(): Observable<any> {
    const apiURL = environment.SERVER + 'stripe-cards';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });

    return this.http.get(apiURL, { headers: httpHeaders });
  }

  suspendAllServices(idaccount?: any): Observable<any> {
    const apiURL = environment.SERVER + 'suspendAllServices';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.put(apiURL, {idaccount}, { headers: httpHeaders });
  }

  @LoaderEnabled()
  stripeDefaultCards(): Observable<any> {
    const apiURL = environment.SERVER + 'stripe-cards-default';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiURL, { headers: httpHeaders });
  }

  @LoaderEnabled()
  createCard(token): Observable<any> {
    const apiURL = environment.SERVER + 'create-card';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });

    return this.http.post(apiURL, { token: token }, { headers: httpHeaders });
  }

  @LoaderEnabled()
  onBoardcreateCard(token): Observable<any> {
    const apiURL = environment.SERVER + 'onBoardcreateCard';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });

    return this.http.post(apiURL, { token: token }, { headers: httpHeaders });
  }

  @LoaderEnabled()
  finalSubmitCardForm(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'saveCardForm';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }


  @LoaderEnabled()
  onBoardstripecards(): Observable<any> {
    const apiURL = environment.SERVER + 'onBoardstripecards';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });

    return this.http.get(apiURL, { headers: httpHeaders });
  }

  @LoaderEnabled()
  saveEsignature(data?: any): Observable<any> {
    this.appmod = "saveEsignature";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getEsignature(): Observable<any> {
    this.appmod = 'getEsignature';
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getUserStatus(uid): Observable<any> {
    this.appmod = 'getUserStatus';
    let result = super.getService(uid);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  setDefaultCard(customer_id): Observable<any> {
    const apiURL = environment.SERVER + 'set-default-card';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.put(apiURL, { customer_id }, { headers: httpHeaders });
  }

  @LoaderEnabled()
  deleteCard(customer_id): Observable<any> {
    const apiURL = environment.SERVER + 'delete-card';
    let httpHeaders = new HttpHeaders({

    });
    return this.http.delete(apiURL, { headers: httpHeaders, params: { customer_id: customer_id } });
  }

  @LoaderEnabled()
  deleteOnBoardCard(customer_id): Observable<any> {
    const apiURL = environment.SERVER + 'deleteOnBoardCard';
    let httpHeaders = new HttpHeaders({

    });
    return this.http.delete(apiURL, { headers: httpHeaders, params: { customer_id: customer_id } });
  }

  @LoaderEnabled()
  updateProfile(data: any, profile_pic?: File | any): Observable<any> {
    const formData = new FormData();
    formData.append("profile_pic", profile_pic);
    formData.append("data", JSON.stringify(data));

    const apiURL = environment.SERVER + 'user';
    let httpHeaders = new HttpHeaders({
    });
    return this.http.post(apiURL, formData, { headers: httpHeaders });
  }

  @LoaderEnabled()
  updateProfilePic(profile_pic?: File | any): Observable<any> {
    const formData = new FormData();
    formData.append("profile_pic", profile_pic);

    const apiURL = environment.SERVER + 'profile-pic';
    let httpHeaders = new HttpHeaders({
    });
    return this.http.put(apiURL, formData, { headers: httpHeaders });
  }

  @LoaderEnabled()
  removeProfilePic(profile_pic?: File | any): Observable<any> {
    this.appmod = "removeProfile-pic";
    let result = super.updateService(profile_pic);
    this.appmod = "usermanagement";
    return result;
  }


  @LoaderEnabled()
  deleteUser(key: any) {
    this.appmod = "deleteUser";
    let result = super.deleteService(key);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  updateTariff(key: any) {
    this.appmod = "update-tariff";
    let result = super.updateService(key);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  addBillingAddress(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'add_billing_address';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }

  //@LoaderEnabled()
  sendFinalMail(data?: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'signup_confirmation';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  getGeoCodeAdd(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'get_geo_code';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }


  @LoaderEnabled()
  deleteUserSingleData(key: any) {
    this.appmod = "deleteUserSingleData";
    let result = super.deleteService(key);
    this.appmod = "usermanagement";
    return result;
  }


  saveData(data: any): Observable<any> {
    let result = super.saveService(data);
    return result;
  }

  @LoaderEnabled()
  updatePaymentService(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'updatepaymentsetting';
    let result = super.updateService(data);
    this.appmod = tmp;
    return result;
  }

  updateData(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'custom/saveheadermapping';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }


  // @LoaderEnabled()
  // getCampaign(data:any): Observable<any> {
  //   console.log(data);
  //   this.appmod = 'CampaignData';
  //   let result = super.getService(data);
  //   this.appmod = "";
  //   return result;
  // }


  @LoaderEnabled()
  getCampaign(data: any): Observable<any> {
    const apiURL = environment.SERVER + 'CampaignData';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiURL, { headers: httpHeaders, params: data });
  }

  @LoaderEnabled()
  emailResend(): Observable<any> {

    const apiURL = environment.SERVER + 'resendemail';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });

    return this.http.post(apiURL, { type: "resend" }, { headers: httpHeaders });
  }

  @LoaderEnabled()
  morphingSession(key: any): Observable<any> {
    const apiURL = environment.SERVER + 'morphing-session';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });

    return this.http.get(apiURL, { headers: httpHeaders, params: { key } });
  }


  @LoaderEnabled()
  billingEnable(data: any) {
    this.appmod = "billingEnable";
    let result = super.updateService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  getKycPdfData(): Observable<any> {
    this.appmod = "downloadPdfForAdmin";
    let result = super.getService();
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  getfederalPdfData(): Observable<any> {
    this.appmod = "getFederalPdfForAdmin";
    let result = super.getService();
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  getFederalPDFAccount(): Observable<any> {
    this.appmod = "getFederalPDFAccount";
    let result = super.getService();
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  getCardPdfForAdmin(): Observable<any> {
    this.appmod = "getCardPdfForAdmin";
    let result = super.getService();
    this.appmod = "usermanagement";
    return result;
  }

  /*KYC verification update function*/
  @LoaderEnabled()
  kycVerify(data: any) {
    this.appmod = "kycVerification";
    let result = super.updateService(data);
    this.appmod = "usermanagement";
    return result;
  }

  /*FOR DOMIAN BLOCK*/
  /*Inser domain block service*/
  @LoaderEnabled()
  saveDomainBlock(data: any): Observable<any> {
    this.appmod = "domainBlock";
    let result = super.saveService(data);
    this.appmod = "usermanagement";
    return result;
  }

  /*GET domain block service*/

  @LoaderEnabled()
  getDomainBlock(): Observable<any> {
    this.appmod = "getDomainBlk";
    let tmp = this.getService();
    this.appmod = "usermanagement";
    return tmp;
  }

  /*UPDATE domain block service*/
  @LoaderEnabled()
  updateDomainBlock(data: any) {
    this.appmod = "updateDomainBlock";
    let result = super.updateService(data);
    this.appmod = "usermanagement";
    return result;
  }
  /*DELETE domain block service*/
  @LoaderEnabled()
  onDeleteDomainBlock(domain_block_id: any): Observable<any> {
    const apiURL = environment.SERVER + 'deleteDomainBlock';
    let httpHeaders = new HttpHeaders({

    });
    return this.http.delete(apiURL, { headers: httpHeaders, params: { domain_block_id: domain_block_id } });
  }
  /*end here domian block services..*/

  @LoaderEnabled()
  getKycHeader(): Observable<any> {
    this.appmod = "kycHeader";
    let tmp = this.getService();
    this.appmod = "usermanagement";
    return tmp;
  }

  public getuserheader(): Observable<any> {
    return this.http.get('./assets/usermanagement.json');
  }

  public getsuppiler(): Observable<any> {
    return this.http.get('./assets/supplieruser.json');
  }

  public getsmsrate(): Observable<any> {
    return this.http.get('./assets/ratelist.json');
  }

  public getVoiceForm(): Observable<any> {
    return this.http.get('./assets/voicerate.json');
  }

  @LoaderEnabled()
  public getTollFreeForm(): Observable<any> {
    return this.http.get('./assets/tollfree.json');
  }

  @LoaderEnabled()
  public getshortcode(): Observable<any> {
    return this.http.get('./assets/shortcode.json');
  }

  public getusasms(): Observable<any> {
    return this.http.get('./assets/usasmsmms.json');
  }


  public getdidupload(): Observable<any> {
    return this.http.get('./assets/uploaddid.json');
  }

  public getintegrated(): Observable<any> {
    return this.http.get('./assets/integratedsupplier.json');
  }

  public getintegratedAPI(): Observable<any> {
    return this.http.get('./assets/apicontrol.json');
  }

  public getrecord(): Observable<any> {
    return this.http.get('./assets/didreport.json');
  }

  public getpreference(): Observable<any> {
    return this.http.get('./assets/userpreference.json');
  }

  public numbersearch(): Observable<any> {
    return this.http.get('./assets/numbersearch.json');
  }

  public ordernumber(): Observable<any> {
    return this.http.get('./assets/orddernumber.json');
  }

  public getdiallogform(): Observable<any> {
    return this.http.get('./assets/dialogpopup.json');
  }



  public record(): Observable<any> {
    return this.http.get('./assets/tierreports.json');
  }

  public get_surcharge(): Observable<any> {
    return this.http.get('./assets/surcharge.json');
  }
  US_State(): Observable<any> {
    return this.http.get('./assets/newBrand.json');
  }
  @LoaderEnabled()
  public api(cdata): Observable<any> {
    const endpoint = environment.SERVER + 'api_token';
    let httpHeaders = new HttpHeaders()
    return this.http.post(endpoint, cdata, { headers: httpHeaders });
  }

  @LoaderEnabled()
  public api_integrate(data): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'api_integration';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }

  /**
   * To fetch the list of Timezones
   */
  GetTimeZones(): Observable<any> {
    this.appmod = "get_timezones";
    let result = this.getService();
    this.appmod = "usermanagement";
    return result;
  }


  /**
   * To fetch the user's TimeZone
   */
  GetUserTimeZone(): Observable<any> {
    this.appmod = "get_user_timezone";
    let result = this.getService();
    this.appmod = "usermanagement";
    return result;
  }


  /**
   * To save the user's TimeZone
   */
  UpdateUserTimeZone(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'user_timezone';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }

  currentSession(authkey: any): Observable<any> {
    const endpoint = environment.SERVER + 'session';
    let httpHeaders = new HttpHeaders()
    return this.http.get(endpoint, { headers: httpHeaders, params: { authkey: authkey } });
  }

  @LoaderEnabled()
  onGetBuyDids(filter?: any): Observable<any> {
    let httpHeaders = new HttpHeaders({
      'Content-Type': 'application/json',
    });
    let apiUrl = environment.SERVER + "dids";
    return this.http.get(apiUrl, { headers: httpHeaders, params: filter });
  }

  @LoaderEnabled()
  getAllDID(data?: any): Observable<any> {
    let httpHeaders = new HttpHeaders({
      'Content-Type': 'application/json',
    });
    let apiUrl = environment.SERVER + "exportdid";
    return this.http.post(apiUrl, { data: data }, { headers: httpHeaders });
  }

  @LoaderEnabled()
  custDidsCount(filter?: any): Observable<any> {
    let httpHeaders = new HttpHeaders({
      'Content-Type': 'application/json',
    });
    let apiUrl = environment.SERVER + "custdidscount";
    return this.http.get(apiUrl, { headers: httpHeaders, params: filter });
  }

  @LoaderEnabled()
  GetCampaignsList(payLoad?: any): Observable<any> {
    this.appmod = 'campaignsList';
    let result = super.getService(payLoad);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  getSubscriptionPlan(payLoad?: any): Observable<any> {
    this.appmod = 'getPlan';
    let result = super.getService(payLoad);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getCampaignForReview(payLoad?: any): Observable<any> {
    this.appmod = 'getCampaignForReview';
    let result = super.getService(payLoad);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getfeatureService(): Observable<any> {
    this.appmod = "getfeatureService";
    let result = this.getService();
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  getfeatureServiceStatus(): Observable<any> {
    this.appmod = "getfeatureServiceStatus";
    let result = this.getService();
    this.appmod = "usermanagement";
    return result;
  }

  getSuspendedService(): Observable<any> {
    this.appmod = "getSuspendedService";
    let result = this.getService();
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  getfeatureServiceById(idaccount): Observable<any> {
    this.appmod = "getfeatureServiceById";
    let result = this.getService(idaccount);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  updateSuspendedService(data: any) {
    this.appmod = "updateSuspendedService";
    let result = super.updateService(data);
    this.appmod = "usermanagement";
    return result;
  }

  @LoaderEnabled()
  getInvoiceDetails(): Observable<any> {
    this.appmod = "getInvoiceDetails";
    let result = this.getService();
    this.appmod = "usermanagement";
    return result;
  }
  get_addcard(): Observable<any> {
    return this.http.get('./assets/addcard.json')
  }
  @LoaderEnabled()
  confirmInvoice(id: any) {
    this.appmod = "deleteCusAccount";
    let result = super.deleteService(id);
    this.appmod = "usermanagement";
    return result;
  }
  @LoaderEnabled()
  getInvoicePdfData(): Observable<any> {
    this.appmod = "getInvoicePdfForAdmin";
    let result = super.getService();
    this.appmod = "usermanagement";
    return result;
  }
  // to update payment status
  @LoaderEnabled()
  Sendpayment(data: any) {
    this.appmod = "paymentstatus";
    let result = super.updateService(data);
    this.appmod = "usermanagement";
    return result;
  }
  // to get the payment status
  trustScore(): Observable<any> {
    this.appmod = "trust_Score";
    let tmp = this.getService();
    this.appmod = "usermanagement";
    return tmp;
  }
  @LoaderEnabled()
  getKycPDFLog(): Observable<any> {
    this.appmod = "getKycPdfLog";
    let result = super.getService();
    this.appmod = "usermanagement";
    return result;
  }

  getCustomerCount(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'customercount';
    let result = super.getService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  UserFilter(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'user_filter';
    let result = super.getService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  finalDeleteAccount(data: any): Observable<any> {
    this.appmod = "permanentDeleteAccount";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getkycstatus(data: any): Observable<any> {
    const apiURL = environment.SERVER + 'getkycstatus';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiURL, { headers: httpHeaders, params: data });
  }
  
  @LoaderEnabled()
  getFederalPdf(type: any): Observable<any> {
    const apiURL = environment.SERVER + 'get_FederalPdf';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiURL, { headers: httpHeaders, params: type });
  }
  @LoaderEnabled()
  deletependingaccount(data: any): Observable<any> {
    this.appmod = "deleteAccount";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  getattached(data): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'GetattAchment';
    let result = super.getService(data);
    this.appmod = tmp;
    return result;
  }
  @LoaderEnabled()
  UserFilternonca(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'userFilterFornonus';
    let result = super.getService(data);
    this.appmod = tmp;
    return result;
  }
  deleteusernotesfile(data: any): Observable<any> {
    this.appmod = "deleteUsernotesfile";
    let result = super.deleteService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  updatenotes(data: any): Observable<any> {
    this.appmod = "sendUserNotes";
    let result =super.updateService(data);
    this.appmod = "";
    return result;
  }
  
  GetUploadFile(data: any): Observable<any> {
    this.appmod = "recentattechment";
    let result =super.getService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  verifymobile(data:any): Observable<any> {
    this.appmod = 'phoneVerification';
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getPermissions(): Observable<any> {
    this.appmod = "getPermissions";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getUserType(): Observable<any> {
    this.appmod = "getUserType";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getMultiUser(): Observable<any> {
    this.appmod = "getMultiUser";
    let result = super.getService();
    this.appmod = "";
    return result;
  }
  
  @LoaderEnabled()
  multiuserfilter(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'multiuserfilter';
    let result = super.getService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  billingService(idaccount: any): Observable<any> {
    this.appmod = "failedBilling";
    let tmp = super.getService(idaccount);
    this.appmod = "usermanagement";
    return tmp;
  }
  
  @LoaderEnabled()
  getidAccount(): Observable<any> {
    this.appmod = "getidAccount";
    let result = this.getService();
    this.appmod = "usermanagement";
    return result;
  }
 

}
