import { Component, Inject,Input,OnInit } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { UsermanagementService } from '../../usermanagement.service';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { Router } from '@angular/router';
import { Observable } from 'rxjs';
 
@Component({
  selector: 'app-addparams',
  templateUrl: './addparams.component.html',
  styleUrls: ['./addparams.component.css']
})

export class AddParamsComponent  extends AppComponentClass<any, any> {
  	@Input() usertype:Observable<boolean>;
	@Input() curuserid?:number=-1;
	public show: boolean = false;
	public show1: boolean = false;
	listdata: any;
	public boxtype: any;
	private savetype=0;

	public addparamsForm: FormGroup;
	public submitted : boolean = false;
  
	constructor(public dialogRef: MatDialogRef<AddParamsComponent>, @Inject(MAT_DIALOG_DATA) public ddata: any, public data: UsermanagementService, public router: Router, public fb: FormBuilder) {
		super(data, router, fb);
	}

  	ngOnInit(): void {
		this.boxtype=this.ddata.type;
	}

	onAddUser() {
		this.submitted = true;

		if (this.addparamsForm.invalid) {
			return false;
		} else {
			if(this.savetype==0){
				this.data.SaveUserData(this.addparamsForm.value).subscribe(res => {
					this.dialogRef.close(1);
				});
			}
			if(this.savetype==1){
				this.data.SaveAdminData(this.addparamsForm.value).subscribe(res => {
					this.dialogRef.close(1);
				});
			}
		}
	}


	close() {
		this.dialogRef.close(-1);
	}
}