import { Component, OnInit } from '@angular/core';
import { VoltLoginService } from '../volt-login.service';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';

@Component({
  selector: 'app-volt-login',
  templateUrl: './volt-login.component.html',
  styleUrls: ['./volt-login.component.css']
})
export class VoltLoginComponent implements OnInit {
  testVar: any;
  disabled = false;
  responseMessage: any = "";
  errMessage: any = "";
  sessiduser: any;
  idaccount: any;
  iduser: any;
  username: any;
  email: any;
  userData: any = [];
  volt_status: any='';
  constructor(public data: VoltLoginService, public userService: UsermanagementService) { }


  ngOnInit(): void {
    let isLoggedIn = sessionStorage.getItem("isLoggedIn");
    this.sessiduser = JSON.parse(isLoggedIn);
    this.idaccount = this.sessiduser.idaccount;
    this.iduser = this.sessiduser.iduser;
    this.username = this.sessiduser.username;
    this.email = this.sessiduser.email;
    this.userService.getSingleUsers().subscribe(res => {
      this.userData = res.data1[0];
      this.volt_status = res.data1[0].volt_status;
      if (this.volt_status == 1) {
        this.onSubmit();
      }
    })
    this.testVar = [

      { id: 1, name: "Accept terms & Condition", checked: false, initialState: false },
    ];
    this.checkChanges();
  }

  changeit(testitem) {
    testitem.checked = !testitem.checked;
    this.checkChanges();
  }

  checkChanges() {
    if (this.testVar.some(item => item.checked != item.initialState)) {
      this.disabled = false;
    } else {
      this.disabled = true;
    }
  }

  onSubmit() {
    let payload = {
      idaccount: this.idaccount,
      email: this.email
    }
    if(!this.idaccount ||!this.email){
      this.errMessage = "Something went wrong with account detail!";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
      return false;
    }
    else{
      this.data.logintoVolt(payload).subscribe((res) => {      
        if (res.status == 200) {
          window.open(`https://insights.textvolt.com/login/signalmash?account_id=${this.idaccount}&user_id=${this.email}&signature=${res.result.signature}`);
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      });
    }
  }

}
