import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Observable } from 'rxjs';
import { AppService } from 'src/app/shared/service/AppService.class';
import { LoaderEnabled } from '../shared/loader/loader.service';
import { environment } from 'src/environments/environment';

@Injectable({
  providedIn: 'root'
})
export class WebhookService extends AppService<any>{

  httpHeaders: any = new HttpHeaders({
    "Content-Type": "application/json"
  });
  iduser: any[];

  constructor(public http: HttpClient) {
    super(http)
  }

  @LoaderEnabled()
  getWebhookCategory(): Observable<any> {
    this.appmod = 'webhookCategory';
    let result = super.getService();
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  geteventType(data?:any): Observable<any> {
    this.appmod = 'geteventType';
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getWebhook(data?:any): Observable<any> {
    this.appmod = 'getWebhook';
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  addWebhook(data?:any): Observable<any> {
    this.appmod = 'addWebhook';
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  updateWebhook(id?:any): Observable<any> {
    this.appmod = 'updateWebhook';
    let result = super.updateService(id);
    this.appmod = "";
    return result;
  }
  
  @LoaderEnabled()
  deleteWebhook(data?:any): Observable<any> {
    this.appmod = 'deleteWebhook';
    let result = super.deleteService(data);
    this.appmod = "";
    return result;
  }
}
