import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { LoaderEnabled } from '../shared/loader/loader.service';
import { AppService } from "../shared/service/AppService.class";
@Injectable({
  providedIn: 'root'
})
export class WhitelabelService extends AppService<any> {

  constructor(public http: HttpClient) {
    super(http);
    this.appmod = "usermanagement";
  }
  @LoaderEnabled()
  updateTheme(data: any, logo: File | any): Observable<any> {
    
    const formData = new FormData();
    formData.append("profile_pic", logo);
    formData.append("data", JSON.stringify(data));

    const apiURL = environment.SERVER+ 'updatetheme';
    let httpHeaders = new HttpHeaders({
    });
    
    return this.http.put(apiURL, formData, { headers: httpHeaders });
  }

  @LoaderEnabled()
  saveTheme(data: any): Observable<any> {
    this.appmod = "savetheme";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getThemes(): Observable <any> {
    this.appmod = "themes";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getTheme(idTheme: any): Observable <any> {
    this.appmod = "theme";
    let result = super.getService(idTheme);
    this.appmod = "";
    return result;
  }


}
