import { Component, ElementRef, OnInit,  ViewChild } from '@angular/core';
import { AgentserviceService } from '../agentservice.service';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';


@Component({
  selector: 'app-account-setting',
  templateUrl: './account-setting.component.html',
  styleUrls: ['./account-setting.component.css']
})
export class AccountSettingComponent implements OnInit {
  channel: FormGroup;
  channelLimit: any;
  responseMessage: any = "";
  public accCountForm: FormGroup;
  submitted: boolean = false;
  errMessage: any = "";
  ibbound: any;
  obound: any;
  btnRequest: any = "Send Request";
  federal_status: any;
  federal_color: string;
  showfilterStatus: string;

  constructor(private data: AgentserviceService, public fb: FormBuilder) { }

  ngOnInit(): void {

    this.accCountForm = this.fb.group({
      current_in_channel_limit:[''],
      current_out_channel_limit:[''],
      request_in_channel_limit: ['', [Validators.required]], 
      request_out_channel_limit: ['', [Validators.required]],
    })
    
    // To Get Account Setting Status
    this.getAccountSttingStatus();
  }

  getAccountSttingStatus(){
    this.data.getAccSettingStatus().subscribe(res => {
      this.channelLimit = res.data[0];
      this.federal_status = this.channelLimit.federal_status;
      if(this.federal_status==1)
      {
        this.showfilterStatus='Filtering Disabled';
      }
      else{
        this.showfilterStatus='Filtering Enabled';
      }
      
      switch(this.federal_status){
        case 0 : this.federal_status = "Inactive"; this.federal_color ="rgb(236 41 52)"; break;
        case 1 : this.federal_status = "Active"; this.federal_color ="#2aab5b"; break;
        case 2 : this.federal_status = "Pending to Active"; this.federal_color ="#e6b125"; break;
        case 3 : this.federal_status = "Reject"; this.federal_color ="rgb(236 41 52)"; break;
      }
      this.accCountForm.patchValue({
        current_in_channel_limit: this.channelLimit.ib_channel,
        current_out_channel_limit: this.channelLimit.ob_channel,
      });
     
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }
  onSubmit() {
    this.btnRequest = "Requesting..."
    if (this.accCountForm.invalid) {
      this.submitted = true;
      this.btnRequest = "Send Request"
      return;
    }
    else {
      this.btnRequest = "Requesting..."
      this.data.channelRequest(this.accCountForm.value).subscribe(res => {
        if (res.status == 200) {
          this.btnRequest="Success";
          this.responseMessage = res.message;
          setTimeout(() => {
            document.getElementById("closeRequest").click();
            this.btnRequest = "Send Request"
            this.responseMessage = "";
          }, 3000);
        }
        else {
          this.btnRequest="Send Request";
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 3000);
        }
      })
    }
  }

  onClose() {
    this.submitted =false;
    this.accCountForm.reset();
    this.accCountForm.patchValue({
      current_in_channel_limit: this.channelLimit.ib_channel,
      current_out_channel_limit: this.channelLimit.ob_channel,
    });
  }

  onChannel() {}

}
