import { Component, OnInit } from '@angular/core';
import { AgentserviceService } from '../agentservice.service'
import { ActivatedRoute, NavigationStart, ParamMap, Router } from '@angular/router';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { FormBuilder } from '@angular/forms';
import { Observable } from 'rxjs';
import { filter, map } from 'rxjs/operators';
declare var $:any;
@Component({
	selector: 'app-agent',
	templateUrl: './agent.component.html',
	styleUrls: ['./agent.component.css']
})

export class AgentComponent extends AppComponentClass<any, any> {
	rowdata: any;
	page = 1;
	field: any;
	header: any;
	count = 0;
	tableSize = 25;
	tableSizes = [25, 50, 100];
	searchText = { count: 0 };
	filtre: string;
	responseMessage: any = "";
	public inbound: any;
	dids: any = [];
	agents: any = [];
	password = "password";
	pShow = false;
	errMessage = "";
	state$: Observable<any>;
	groupKey: any;

	constructor(public data: AgentserviceService,
		public router: Router,
		public fb: FormBuilder,
		private route: ActivatedRoute) {
		super(data, router, fb);

		this.state$ = this.router.events.pipe(
			filter(e => e instanceof NavigationStart),
			map(() => this.router.getCurrentNavigation().extras.state)
		)

		// this.route.paramMap.subscribe((params: ParamMap) => {
		// 	this.groupKey = params.get('id');
		// 	this.data.getAgents(this.groupKey).subscribe(res => {
		// 		if (res.status == 200) {
		// 			this.agents = res.data;
		// 			$.getScript('./assets/table.js');
		// 			if (this.agents.length > 0) {
		// 				this.agents.forEach(element => {
		// 					element.pShow = false;
		// 					element.pswd = "password";
		// 					element.pShow1 = false;
		// 					element.pin = "password";
		// 				});
		// 			}
		// 		}
		// 		else {
		// 			this.errMessage = res.message;
		// 			setTimeout(() => {
		// 				this.errMessage = "";
		// 			}, 5000);
		// 		}
		// 	});

		// });

	}

	ngOnInit(): void {

		this.password = "password";

		this.data.get_agent().subscribe((result) => {
			this.header = result[0].headers_details;
			this.rowdata = result[0].list_data;
		});

		this.route.paramMap.subscribe((params: ParamMap) => {
			this.groupKey = params.get('id');
			this.data.getAgents(this.groupKey).subscribe(res => {
				if (res.status == 200) {					
					this.agents = res.data;
					$('#basic-datatables').DataTable().clear();
				    $('#basic-datatables').DataTable().destroy();
					$.getScript('./assets/table.js');
					if (this.agents.length > 0) {
						this.agents.forEach(element => {
							element.pShow = false;
							element.pswd = "password";
							element.pShow1 = false;
							element.pin = "password";
						});
					}
				}
				else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});

		});
	}

	pinToggle(id) {
		this.agents.forEach(element => {
			if (element.idagent == id) {
				if (element.pin == 'password') {
					element.pin = 'text';
					element.pShow1 = true;

				} else {
					element.pin = 'password';
					element.pShow1 = false;
				}
			}
		});
	}

	passwordToggle(id) {
		this.agents.forEach(element => {
			if (element.idagent == id) {
				if (element.pswd == 'password') {
					element.pswd = 'text';
					element.pShow = true;

				} else {
					element.pswd = 'password';
					element.pShow = false;
				}
			}
		});
	}

	deleteAgent(id: any) {
		if (confirm("Are you sure you want delete data!")) {
			this.data.deleteAgent(id).subscribe(res => {
				if (res.status == 201) {
					this.responseMessage = res.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
					this.ngOnInit();
				}
				else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					});
				}
			}, error => {
				this.responseMessage = error.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			});
		}
		else {
			return
		}
	}



}