import { Component, OnInit } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { MatDialog, MatDialogRef } from '@angular/material/dialog';
import { ApiService } from '../api.service';
import { TokensComponent } from '../tokens/tokens.component';


@Component({
  selector: 'app-addtoken',
  templateUrl: './addtoken.component.html',
  styleUrls: ['./addtoken.component.css']
})
export class AddtokenComponent implements OnInit {
  tokenForm: FormGroup;
  public submitted: boolean = false;
	responseMessage = "";
	dangMessage = "";
  errMessage ="";
  users: any;
  userType: number;


  constructor(private data: ApiService, public dialog: MatDialogRef<TokensComponent>) { }

  ngOnInit() {

    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.userType = session.type;
    
    this.data.subCustomers().subscribe((result: any) => {
        this.users = result.data;
    }, err => {
      console.log(err.message);
    });

    this.tokenForm = new FormGroup({
      name: new FormControl('', [Validators.required]),
      account: new FormControl(''),
      user: new FormControl(''),
      idtariff: new FormControl(''),
      status: new FormControl('')
    });

    this.tokenForm.patchValue({
      account: session.idaccount,
      user: session.iduser,
      idtariff: session.idtariff,
      status: session.status
    });
  }

  onTokenSave(){
    this.submitted = true;
    
    if(this.tokenForm.value.user == '' && this.userType== 2){
      this.dangMessage= "Please Select User";
      setTimeout(()=>{
        this.dangMessage= "";
      }, 5000);
      return false;
    }
		if(this.tokenForm.invalid){
			return;
		}
    else{
      this.data.saveToken(this.tokenForm.value).subscribe(res => {
        if(res.data){
          this.responseMessage = res.message;
					setTimeout(()=>{
						this.responseMessage = "";
					}, 5000);
          this.dialog.close(res.message);
        }
        else{
          this.dangMessage = res.message;
          setTimeout(()=>{
						this.dangMessage = "";
					}, 5000);
        }
      }, err => {
        this.responseMessage = err.message;
        setTimeout(()=>{
          this.responseMessage= "";
        }, 5000);
      });
    }
  }

  onSelectUser(e){
    let iduser = e.target.value;
    let selectedUser = this.users.find(x => x.iduser == iduser);
    this.tokenForm.patchValue({
        user: selectedUser.iduser,
        idtariff: selectedUser.idtariff,
        status: selectedUser.status
    });
  }
  onReset() {
    this.submitted = false;
    this.tokenForm.reset(true);
    // Set the select field to the default value.
    this.tokenForm.get('user').setValue('');
  }
}
