import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators, FormControl } from '@angular/forms';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { AuthenticationService } from '../authentication.service';

@Component({
  selector: 'app-forgot',
  templateUrl: './forgot.component.html',
  styleUrls: ['./forgot.component.css']
})
export class ForgotComponent extends AppComponentClass<any, any> {
  submitted: boolean = false;
  ForgotForm: FormGroup
  errMessage: any = "";
  responseMessage = "";
  getForgotUserPass: any = []; 
  isPasswordType: String = "";
  isUpdatePassword: Boolean = false;
  mailSendSuccess: boolean = false;
  showMessage: any;

  constructor(protected data: AuthenticationService, protected router: Router, protected fb: FormBuilder, private activatedroute: ActivatedRoute)
     {
    super(data, router, fb);

  }

  ngOnInit(): void {

    this.ForgotForm = this.fb.group({
      key: new FormControl(''),
      email: new FormControl('', [Validators.required,Validators.pattern("^[a-z0-9._%+-]+@[a-z0-9.-]+\\.[a-z]{2,4}$")]),
      password: new FormControl('', [Validators.required, Validators.minLength(8)]),
      confirm_password: new FormControl('', [Validators.required, Validators.minLength(8)]),
    })
    this.activatedroute.paramMap.subscribe((params: ParamMap) => {
      let id = params.get('id');
      this.ForgotForm.patchValue({
        key: id,
      });
      console.log(id);
      
      if(id === 'forgot-password'){
          this.isUpdatePassword = false;
          return this.isPasswordType = '1';
      } else {
        this.data.verifyToken(id).subscribe(res => {
          if(res.status == 201){
              this.responseMessage = res.message;
              setTimeout(() => {
                this.responseMessage = "";
              }, 5000);
              this.isUpdatePassword = true;
          } else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
              this.router.navigate(['password/forgot-password']);  
            }, 5000);
            this.isUpdatePassword = false;    
          }
        });
        return this.isPasswordType = "2";
      }
    });
  }

  onForgot() {
    console.log(this.isUpdatePassword);
    if(this.isUpdatePassword){
      if(this.ForgotForm.value.password === this.ForgotForm.value.confirm_password){
          this.data.updatePassword(this.ForgotForm.value).subscribe(res => {
            if(res.status == 201){ 
              this.responseMessage = res.message;
              this.router.navigate(['/']);
              setTimeout(() => {
                  this.responseMessage = "";
              }, 5000);
            } else {
              this.errMessage = res.message;
              setTimeout(() => {
                  this.errMessage = "";
              }, 5000);
            }
          });
      }
      else{
        this.errMessage = "Password and Confirm-Password does not Match!";
        setTimeout(() => {
            this.errMessage = "";
        }, 5000);
      }
    } else {
      var fpdata = this.ForgotForm.value;
      this.data.sendMailForgot(fpdata.email).subscribe(res => {
        if(res.status == 201){
          // this.responseMessage = res.message;
          this.showMessage= res.message;
          this.mailSendSuccess=true;
          // setTimeout(() => {
          //     this.responseMessage = "";
          // }, 5000);
        } else{
          this.errMessage = res.message;
          setTimeout(() => {
              this.errMessage = "";  
          }, 5000);
        }
      });  
    }

  }

}
