import { Component, Input, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { ActivatedRoute, Router } from '@angular/router';

@Component({
  selector: 'app-reset-password',
  templateUrl: './reset-password.component.html',
  styleUrls: ['./reset-password.component.css']
})
export class ResetPasswordComponent implements OnInit {
  @Input() currentUser: any;
  resetpasswordForm: FormGroup;
  eyetoggle: boolean = false;
  eyetoggle1: boolean = false;
  eyetoggle2: boolean = false;
  submitted3: boolean;
  showErr: any = "";
  oldPass: any ="";
  key = -1;
  responseMessage: any = "";
  errMessage: any = "";
  disabled:boolean=false;

  constructor( public fb: FormBuilder,public data: UsermanagementService, public router: Router, private route: ActivatedRoute,) { }

  ngOnInit(): void {
    this.resetpasswordForm = this.fb.group({
      old_password: ['', [Validators.required]],
      new_password: ['', [Validators.required,Validators.minLength(8)]],
      confirm_password: ['', [Validators.required,Validators.minLength(8)]]
    });
  }

  reset_password() {    
    this.submitted3 = true;
    this.disabled=true;
    if (this.resetpasswordForm.invalid) {   
      this.disabled=false;   
      return false;
    }
    else {      
      if (this.resetpasswordForm.get('new_password').value == this.resetpasswordForm.get('old_password').value) {     
      alert("New password should be different from old password");
      this.disabled=false;
      }else {      
      if (this.resetpasswordForm.get('new_password').value == this.resetpasswordForm.get('confirm_password').value) {
        this.data.resetPass(JSON.stringify(this.resetpasswordForm.value)).subscribe(rs => {
          if (rs.status == 201) {
            this.responseMessage = rs.message;           
            setTimeout(() => {
              this.router.navigate(['/login']);
              this.responseMessage = "";
            }, 5000);
          }
          else {
            this.disabled=false;
            this.errMessage = rs.message;
            this.showErr = rs.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        }, err => {
          this.disabled=false;
          this.errMessage = err.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        });
      }
      else {
        this.disabled=false;
        alert("Your entered confirm password does not match");
      }
      }
    }
    
  }

  clear(){
    this.submitted3 = false;
    this.resetpasswordForm.reset(true);
    this.showErr = "";
  }

  eyeToggle(check: any) {
    if (check == 1)
      if (this.eyetoggle)
        this.eyetoggle = false
      else
        this.eyetoggle = true
    else if (check == 2)
      if (this.eyetoggle1)
        this.eyetoggle1 = false
      else
        this.eyetoggle1 = true
    else
      if (this.eyetoggle2)
        this.eyetoggle2 = false
      else
        this.eyetoggle2 = true
  }

}
