import { Component } from '@angular/core';
import { BillingService } from '../billing.service'
import { AbstractControl, FormBuilder, FormControl, FormGroup, ValidatorFn, Validators } from '@angular/forms';
import { Router } from '@angular/router';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import * as XLSX from 'xlsx';
import { saveAs } from 'file-saver';

declare var $: any;
@Component({
  selector: 'app-invoices',
  templateUrl: './invoices.component.html',
  styleUrls: ['./invoices.component.css']
})

export class InvoicesComponent extends AppComponentClass<any, any> {
  p: number = 1;
  searchText = { count: 0 };
  filtre: string;
  header: any;
  invoiceheader: any;
  rowdata: any;
  excel = [];
  page = 1;
  count = 0;
  tableSize = 25;
  tableSizes = [25, 50, 100];
  filterTerm: string;
  public show: boolean = false;
  public buttonName: any = "fa fa-plus";
  public heading = [];
  public main_heading = "";
  monthlyInvoice: any = [];
  responseMessage: any = "";
  errMessage: any = "";
  users: any = [];
  monthNameList: any = [];
  invoiceTaxdata: any = [];
  filterForm: FormGroup;
  userType: any;
  isAdmin: boolean = false;
  submitted: boolean = false;
  name = 'Angular 6';
  status: any[];
  formula: string = "Formula 1";

  EXCEL_TYPE = 'application/csv';
  EXCEL_EXTENSION = '.csv';
  account_id: any;
  invoice_id: any;

  constructor(
    private userService: UsermanagementService,
    public data: BillingService,
    public router: Router,
    public fb: FormBuilder
  ) {
    super(data, router, fb);
  }

  ngOnInit(): void {

    let isLoggedIn = JSON.parse(sessionStorage.getItem("isLoggedIn"));
    this.userType = isLoggedIn.type;
    if (this.userType == 1) {
      this.isAdmin = true;
    }
    else {
      this.isAdmin = false;
    }

    this.filterForm = this.fb.group({
      fromDate: new FormControl(this.startDate()),
      toDate: new FormControl(this.current_datetime()),
      selectedUser: new FormControl('')
    }, {
      validator: Validators.compose([
        InvoicesComponent.dateLessThan('fromDate', 'toDate', { 'fromDate': true })
      ])
    }
    );

    this.userService.getUsers("main").subscribe(res => {
      if (res.status == 200) {
        this.users = res.data[0];
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });

    this.data.getinvoice().subscribe((result) => {
      this.header = result[0].headers_details;
      this.rowdata = result[0].invoice;
    });

    this.data.getinvoicetax().subscribe((result) => {
      this.invoiceheader = result[0].headers_tax_details;
    });

    this.monthsList();

    this.monthlyInvoice = [];
    this.data.monthlyInvoice(this.filterForm.value).subscribe(res => {
      if (res.status == 200) {
        this.monthlyInvoice = res.data;
        $('#basic-datatables11a').DataTable().clear();
        $('#basic-datatables11a').DataTable().destroy();
        $.getScript('./assets/table.js');

      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  getInvoiceTaxdata(idaccount, idinvoice) {
    this.invoice_id = idinvoice;
    this.account_id = idaccount;

    this.data.getInvoiceTax({ idaccount: idaccount, idinvoice: idinvoice }).subscribe((result: any) => {
      this.invoiceTaxdata = result.data;
      $('#basic-datatabless').dataTable().fnClearTable();
      $('#basic-datatabless').dataTable().fnDraw();
      $('#basic-datatabless').dataTable().fnDestroy();
      $.getScript('./assets/table.js');
    }, err => {
      console.log(err.message);
    });
  }

  selectedFromDate(e) {
    this.submitted = true;
    if (e.target.value) {
      this.filterForm.get("toDate").setValidators(Validators.required);
      this.filterForm.get("toDate").updateValueAndValidity();
    }
  }

  selectedToDate(e) {
    this.submitted = true;
    if (e.target.value) {
      this.filterForm.get("fromDate").setValidators(Validators.required);
      this.filterForm.get("fromDate").updateValueAndValidity();
    }
  }

  filterByUser(e) {
    this.filterForm.patchValue({
      selectedUser: e.target.value
    });
  }

  downloadCSVFile() {
    this.data.CsvInvoice(this.filterForm.value).subscribe(res => {
      if (res.status == 200) {
        let invoiceData = res.data[0];
        const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(invoiceData);
        const workbook: XLSX.WorkBook = { Sheets: { 'invoice': worksheet }, SheetNames: ['invoice'] };
        const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
        this.saveAsExcelFile(excelBuffer, "invoice");
      }
    })
  }

  private saveAsExcelFile(buffer: any, fileName: string): void {
    const data: Blob = new Blob([buffer], {
      type: this.EXCEL_TYPE
    });
    saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
  }

  filterSubmit() {
    this.submitted = true;
    if (this.filterForm.invalid) {
      return
    }
    else {
      this.monthlyInvoice = [];
      this.data.monthlyInvoice(this.filterForm.value).subscribe(res => {
        if (res.status == 200) {
          this.monthlyInvoice = res.data;        
          $('#basic-datatables11a').DataTable().clear();
          $('#basic-datatables11a').DataTable().destroy();
          $.getScript('./assets/table.js');
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }

      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000)
      });
    }

    this.show = true;
  }

  // toggle() {
  //   this.show = !this.show;

  //   // CHANGE THE NAME OF THE BUTTON.
  //   if (this.show) this.buttonName = "fa fa-times";
  //   else this.buttonName = "fa fa-plus";
  // }

  getMonths(startDate, endDate) {
    var resultList = [];
    var date = new Date(startDate);
    endDate = new Date(endDate);

    while (date <= endDate) {
      let month1 = date.getMonth();
      let month = month1 + 1;
      var stringDate = date.getFullYear() + "-" + month;

      //get first and last day of month
      var firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
      var lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);

      resultList.push({
        str: stringDate,
        first: firstDay,
        last: lastDay,
      });
      date.setMonth(date.getMonth() + 1);
    }

    return resultList;
  };

  clearFilter() {
    this.ngOnInit();
    this.filterForm.reset();
  }

  startDate() {
    let now = new Date();
    let year = "" + now.getFullYear();
    let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
    let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
    let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
    let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
    let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
    return year + '-' + month + "-" + "01";
  }


  current_datetime() {
    let now = new Date();
    let year = "" + now.getFullYear();
    let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
    let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
    let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
    let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
    let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
    return year + '-' + month + "-" + day;
  }

  monthsList() {
    this.monthNameList = [
      { name: "Jan", value: "1" },
      { name: "Feb", value: "2" },
      { name: "Mar", value: "3" },
      { name: "Apr", value: "4" },
      { name: "May", value: "5" },
      { name: "Jun", value: "6" },
      { name: "Jul", value: "7" },
      { name: "Aug", value: "8" },
      { name: "Sep", value: "9" },
      { name: "Oct", value: "10" },
      { name: "Nov", value: "11" },
      { name: "Dec", value: "12" }
    ];
  }

  static dateLessThan(fromDate: string, toDate: string, validatorField: { [key: string]: boolean }): ValidatorFn {
    return (c: AbstractControl): { [key: string]: boolean } | null => {
      const date1 = c.get(fromDate).value;
      const date2 = c.get(toDate).value;
      if ((date1 !== null && date2 !== null) && date1 > date2) {
        return validatorField;
      }
      return null;
    };
  }

}
