import { Component } from '@angular/core';
import { BillingService } from '../billing.service';
import { FormBuilder, FormGroup, FormControl, Validators, AbstractControl, ValidatorFn } from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { Router } from '@angular/router';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import * as XLSX from 'xlsx';
import { saveAs } from 'file-saver';

declare var $: any;

@Component({
  selector: 'app-orderhistory',
  templateUrl: './orderhistory.component.html',
  styleUrls: ['./orderhistory.component.css']
})
export class OrderhistoryComponent extends AppComponentClass<any, any> {
  p: number = 1;
  searchText = { count: 0 };
  filtre: string;
  page = 1;
  count = 0;
  tableSize = 50;
  tableSizes = [50, 100, 150];
  filterTerm: string
  paymentList: any = [];
  paymentListLength: any = [];
  monthlyInvoice: any = [];
  errMessage: any = "";
  userType: any = "";
  isAdmin: boolean = false;
  filterForm: FormGroup;
  monthNameList: any = [];
  submitted: boolean = false;
  public show: boolean = false;
  users: any = [];
  EXCEL_TYPE = 'application/csv';
  EXCEL_EXTENSION = '.csv';
  //static filterForm: any;


  constructor(public data: BillingService, public router: Router, public fb: FormBuilder, private userService: UsermanagementService) {
    super(data, router, fb);

    let session = JSON.parse(sessionStorage.getItem("isLoggedIn"));
    this.userType = session.type;
  }

  ngOnInit(): void {

    let isLoggedIn = JSON.parse(sessionStorage.getItem("isLoggedIn"));
    this.userType = isLoggedIn.type;
    if (this.userType == 1) {
      this.isAdmin = true;
    }
    else {
      this.isAdmin = false;
    }

    this.filterForm = this.fb.group({
      fromDate: new FormControl(this.startDate(), [Validators.required]),
      toDate: new FormControl(this.current_datetime(), [Validators.required]),
      selectedUser: new FormControl('')
    }, {
      validator: Validators.compose([
        OrderhistoryComponent.dateLessThan('fromDate', 'toDate', { 'fromDate': true })
      ])
    });

    this.monthsList();

    this.paymentList = [];
    this.data.paymentHistory(this.filterForm.value).subscribe(res => {
      if (res.status == 200) {
        $('#basic-datatables11a').DataTable().clear();
        $('#basic-datatables11a').DataTable().draw();
        $('#basic-datatables11a').DataTable().destroy();
        $.getScript('./assets/table.js');
        this.paymentList = res.data;
        // this.paymentListLength = this.paymentList.length;
      }
    }, err => {
      console.log(err.message);
    });



    this.userService.getUsers("main").subscribe(res => {
      if (res.status == 200) {
        this.users = res.data[0];
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });

  }

  getMonths(startDate, endDate) {
    var resultList = [];
    var date = new Date(startDate);
    endDate = new Date(endDate);

    while (date <= endDate) {
      let month1 = date.getMonth();
      let month = month1 + 1;
      var stringDate = date.getFullYear() + "-" + month;

      //get first and last day of month
      var firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
      var lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);

      resultList.push({
        str: stringDate,
        first: firstDay,
        last: lastDay,
      });
      date.setMonth(date.getMonth() + 1);
    }

    return resultList;
  };

  selectedFromDate(e) {
    this.submitted = true;
    if (e.target.value) {
      this.filterForm.get("toDate").setValidators(Validators.required);
      this.filterForm.get("toDate").updateValueAndValidity();
    }
  }

  selectedToDate(e) {
    this.submitted = true;
    if (e.target.value) {
      this.filterForm.get("fromDate").setValidators(Validators.required);
      this.filterForm.get("fromDate").updateValueAndValidity();
    }
  }

  filterByUser(e) {
    this.filterForm.patchValue({
      selectedUser: e.target.value
    });
  }

  filterSubmit() {
    this.submitted = true;
    if (this.filterForm.invalid) {
      return
    }
    else {
      this.paymentList = [];
      this.data.paymentHistory(this.filterForm.value).subscribe(res => {
        if (res.status == 200) {
          this.paymentList = res.data;
          $('#basic-datatables11a').DataTable().clear();
          $('#basic-datatables11a').DataTable().destroy();
          $.getScript('./assets/table.js');
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }

      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000)
      });
    }

    this.show = true;
  }


// on click clear filter show start & current date of month.
  clearFilter() {
    this.ngOnInit();
    this.submitted = false;
    this.filterForm.patchValue({
			fromDate: this.startDate(),
			toDate: this.current_datetime(),
		})
  }


  downloadCSVFile() {
    this.data.paymentHistory(this.filterForm.value).subscribe(res => {
      if (res.status == 200) {
        let paymentHistory = res.data;
        const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(paymentHistory);
        const workbook: XLSX.WorkBook = { Sheets: { 'payment': worksheet }, SheetNames: ['payment'] };
        const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
        this.saveAsExcelFile(excelBuffer, "payment");
      }
    })
  }

  private saveAsExcelFile(buffer: any, fileName: string): void {
    const data: Blob = new Blob([buffer], {
      type: this.EXCEL_TYPE
    });
    saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
  }

  startDate() {
    let now = new Date();
    let year = "" + now.getFullYear();
    let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
    let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
    let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
    let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
    let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
    return year + '-' + month + "-" + "01";
  }


  current_datetime() {
    let now = new Date();
    let year = "" + now.getFullYear();
    let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
    let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
    let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
    let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
    let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
    return year + '-' + month + "-" + day;
  }

  monthsList() {
    this.monthNameList = [
      { name: "Jan", value: "1" },
      { name: "Feb", value: "2" },
      { name: "Mar", value: "3" },
      { name: "Apr", value: "4" },
      { name: "May", value: "5" },
      { name: "Jun", value: "6" },
      { name: "Jul", value: "7" },
      { name: "Aug", value: "8" },
      { name: "Sep", value: "9" },
      { name: "Oct", value: "10" },
      { name: "Nov", value: "11" },
      { name: "Dec", value: "12" }
    ];
  }


  static dateLessThan(fromDate: string, toDate: string, validatorField: { [key: string]: boolean }): ValidatorFn {
    return (c: AbstractControl): { [key: string]: boolean } | null => {
      const date1 = c.get(fromDate).value;
      const date2 = c.get(toDate).value;
      if ((date1 !== null && date2 !== null) && date1 > date2) {
        return validatorField;
      }
      return null;
    };
  }


}
