import { Component } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { CapmaignserviceService } from '../capmaignservice.service';

@Component({
  selector: 'app-addbrand',
  templateUrl: './addbrand.component.html',
  styleUrls: ['./addbrand.component.css']
})

export class AddbrandComponent extends AppComponentClass<any, any>  {
  public brandForm: FormGroup;
  public submitted: boolean = false;
  responseMessage: any;
  brand: any;
  brandVertical: any;
  brandType: any;
  isRegister: Boolean = false;
  register: any;
  companyData: any = [];
  brandRelationship: any = [];
  altBusinessIdType: any = [];
  country: any = [];
  strategy: IDropdownSettings = {};
  errMessage: any = "";
  selectedItems: any = [];
  strategy2: IDropdownSettings = {};
  selectedItems2: any = [];

  constructor(public data: CapmaignserviceService,
    private userService: UsermanagementService,
    public router: Router, public fb: FormBuilder,
    private route: ActivatedRoute) {
    super(data, router, fb);
  }


  ngOnInit(): void {

    this.brandForm = this.fb.group({
      brand_key: [''],
      companyName: [''],
      displayName: [''],
      entityType: [''],
      ein: [''],
      phone: [''],
      country: [''],
      email: [''],
      street: [''],
      city: [''],
      state: [''],
      postalCode: [''],
      website: [''],
      vertical: [''],
      brandRelationship: [''],
      firstName: [''],
      lastName: [''],
      mobilePhone: [''],
      referenceId: [''],
      stockSymbol: [''],
      stockExchange: [''],
      einIssuingCountry:['']
    });

    this.strategy = {
      singleSelection: true,
      idField: 'id',
      textField: 'name',
      itemsShowLimit: 2,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

    this.country = [
      { id: 1, name: "US" },
      { id: 2, name: "CA" }
    ]

    this.strategy2 = {
      singleSelection: true,
      idField: 'abbreviation',
      textField: 'name',
      itemsShowLimit: 4,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

    this.userService.companyProfile().subscribe(res => {
      if (res.data.length > 0) {
        this.companyData = res.data[0];
        this.brandForm.patchValue({
          idcompany: res.data[0].idcompany,
          company_name: res.data[0].company_name,
          street: res.data[0].address,
          city: res.data[0].city,
          state: res.data[0].state,
          postalCode: res.data[0].postal_code,
          ein: res.data[0].ein,
          phone: res.data[0].phone,
          email: res.data[0].email,
          website: res.data[0].website,
        });

        // for US country
        if (res.data[0].country == 'US') {
          this.selectedItems = [{
            id: 1,
            name: res.data[0].country
          }]
          this.brandForm.patchValue({
            einIssuingCountry: res.data[0].country
          })
          
          let I: any = this.StatesUS.findIndex((ele: any) => {
            return ele.name == res.data[0].state
          })
          if (I > -1) {
            this.selectedItems2 = [{
              name: this.StatesUS[I].name,
              abbreviation: this.StatesUS[I].abbreviation
            }]
          }
          else {
            this.brandForm.patchValue({
              state: ""
            })
          }
        }

        // for Canada country
        else if (res.data[0].country == 'Canada' || res.data[0].country == 'CA') {
          this.selectedItems = [{
            id: 2,
            name: 'CA'
          }]
          this.brandForm.patchValue({
            einIssuingCountry: this.selectedItems[0].name

          })
    
          let I: any = this.StatesCA.findIndex((ele: any) => {
            return ele.name == res.data[0].state
          })
          if (I > -1) {
            this.selectedItems2 = [{
              name: this.StatesCA[I].name,
              abbreviation: this.StatesCA[I].abbreviation
            }]
            
          }
          else {
            this.brandForm.patchValue({
              state: ""
            })
          }
        }

        // for US country
        else {
          this.selectedItems = [{
            id: 1,
            name: 'US'
          }]
          this.brandForm.patchValue({
            state: ""
          })
          this.brandForm.patchValue({
            einIssuingCountry: this.selectedItems[0].name
          })
          
        }

      }
    });

    this.route.paramMap.subscribe((params: ParamMap) => {
      this.register = params.get('register');
      if (this.register == "register") {
        this.isRegister = true;
        this.brandForm.get("brand_key").setValidators([Validators.required]);
        this.brandForm.get("companyName").setValidators([Validators.required]);
        
      }
      else {
        this.isRegister = false;
        this.brandForm.get("companyName").setValidators([Validators.required]);
        this.brandForm.get("displayName").setValidators([Validators.required]);
        this.brandForm.get("entityType").setValidators([Validators.required]);
        this.brandForm.get("ein").setValidators([Validators.required]);
        this.brandForm.get("phone").setValidators([Validators.required]);
        this.brandForm.get("country").setValidators([Validators.required]);
        this.brandForm.get("email").setValidators([Validators.required]);
        this.brandForm.get("street").setValidators([Validators.required]);
        this.brandForm.get("city").setValidators([Validators.required]);
        this.brandForm.get("state").setValidators([Validators.required]);
        this.brandForm.get("postalCode").setValidators([Validators.required]);
        this.brandForm.get("website").setValidators([Validators.required]);
        this.brandForm.get("vertical").setValidators([Validators.required]);
        this.brandForm.get("brandRelationship").setValidators([Validators.required]);
      }
    });

    this.data.brandRelationship().subscribe(res => {
      if (res.status == 200) {
        this.brandRelationship = res.data;
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        });
      }
    });

    this.data.altBusinessIdType().subscribe(res => {
      this.altBusinessIdType = res.data.slice(1, 4);
    });

    this.data.brandVertical().subscribe(res => {
      let tmp: any = [];
      Object.entries(res.data).forEach((ele: any) => {
        let t = ele[1];
        t["name"] = ele[0];
        tmp.push(t);
      });
      this.brandVertical = tmp;
    });

    this.data.brandEntityType().subscribe(res => {
      this.brandType = res.data;
    });

    this.data.getBrands().subscribe(res => {
      this.brand = res;
      
    });

   


    this.data.brandVertical().subscribe(res => {
      let tmp: any = [];
      Object.entries(res.data).forEach((ele: any) => {
        let t = ele[1];
        t["name"] = ele[0];
        tmp.push(t);
      });
      this.brandVertical = tmp;
    });
    this.data.brandEntityType().subscribe(res => {
      this.brandType = res.data;
    });
  }


  /**
   * To register the brand
   */
  onBrand() {
    this.submitted = true;
    if (this.brandForm.invalid) {
      return false;
    }
    else {

      let country: any = []
      country = this.selectedItems
      if (country.length > 0) {
        this.brandForm.patchValue({
          country: country[0].name
        });
      }

      let state: any = []
      state = this.selectedItems2
      if (state.length > 0) {
        this.brandForm.patchValue({
          state: state[0].abbreviation
        });
      }
      
      if (this.isRegister) {
        
        this.data.onBrandRegister(this.brandForm.value).subscribe(response => {
          if (response.status == 201) {
            this.responseMessage = response.message;
            this.router.navigateByUrl('/campaign/brand-details');
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
          }
          else {
            this.errMessage = response.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        });
      }
      else {
        
        this.data.onAddBrand(this.brandForm.value).subscribe(response => {
          if (response.status == 201) {
            this.responseMessage = response.message;
            this.router.navigateByUrl('/campaign/brand-details');
            setTimeout(() => {
              this.responseMessage = "";
              window.location.reload();
            }, 5000);
          }
          else {
            this.errMessage = response.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        });
      }
    }
  }


  /**
   * On Country selection
   */
  onCountry(e: any): any {
    this.selectedItems = [e]
    this.selectedItems2 = []
    this.brandForm.patchValue({
      einIssuingCountry: e.name
    })
  }


  /**
   * On State selection
   */
  onState(e: any): any {
    console.log(e)
    this.selectedItems2 = [e]
  }

  selectedOrgnization(e:any){
    
    if(e.target.value == 'SOLE_PROPRIETOR'){
      let SOLE1: any = this.brandForm.get("firstName");
      SOLE1.setValidators([Validators.required]);
      let SOLE2:any= this.brandForm.get("lastName");
      SOLE2.setValidators([Validators.required]);
      let SOLE3:any= this.brandForm.get("mobilePhone");
      SOLE3.setValidators([Validators.required]);
      let SOLE4:any=this.brandForm.get("referenceId");
      SOLE4.setValidators([Validators.required]);

      let PUBLIC: any =this.brandForm.get("stockSymbol");
      PUBLIC.setValidators([]);

      let PUBLICSE: any =this.brandForm.get("stockExchange");
      PUBLICSE.setValidators([]);

      SOLE1.updateValueAndValidity();
      SOLE2.updateValueAndValidity();
      SOLE3.updateValueAndValidity();
      SOLE4.updateValueAndValidity();
      PUBLIC.updateValueAndValidity();
      PUBLICSE.updateValueAndValidity();
     }
     else if(e.target.value == 'PUBLIC_PROFIT'){ 
      let PUBLIC: any =this.brandForm.get("stockSymbol");
      PUBLIC.setValidators([Validators.required]);
      PUBLIC.updateValueAndValidity();
      
      let PUBLICSE: any =this.brandForm.get("stockExchange");
      PUBLICSE.setValidators([Validators.required]);
      PUBLICSE.updateValueAndValidity();

      let SOLE1: any = this.brandForm.get("firstName");
      SOLE1.setValidators([]);
      let SOLE2:any= this.brandForm.get("lastName");
      SOLE2.setValidators([]);
      let SOLE3:any= this.brandForm.get("mobilePhone");
      SOLE3.setValidators([]);
      let SOLE4:any=this.brandForm.get("referenceId");
      SOLE4.setValidators([]);

      SOLE1.updateValueAndValidity();
      SOLE2.updateValueAndValidity();
      SOLE3.updateValueAndValidity();
      SOLE4.updateValueAndValidity();
    }
    else{
      let SOLE1: any = this.brandForm.get("firstName");
      SOLE1.setValidators([]);
      let SOLE2:any= this.brandForm.get("lastName");
      SOLE2.setValidators([]);
      let SOLE3:any= this.brandForm.get("mobilePhone");
      SOLE3.setValidators([]);
      let SOLE4:any=this.brandForm.get("referenceId");
      SOLE4.setValidators([]);

      let PUBLIC: any =this.brandForm.get("stockSymbol");
      PUBLIC.setValidators([]);
      let PUBLICSE: any =this.brandForm.get("stockExchange");
      PUBLICSE.setValidators([]);

      SOLE1.updateValueAndValidity();
      SOLE2.updateValueAndValidity();
      SOLE3.updateValueAndValidity();
      SOLE4.updateValueAndValidity();
      PUBLIC.updateValueAndValidity();
      PUBLICSE.updateValueAndValidity();
    }
  }


  /**
   * US States List
   */
  StatesUS: any = [
    {
      "name": "Alabama",
      "abbreviation": "AL"
    },
    {
      "name": "Alaska",
      "abbreviation": "AK"
    },
    {
      "name": "American Samoa",
      "abbreviation": "AS"
    },
    {
      "name": "Arizona",
      "abbreviation": "AZ"
    },
    {
      "name": "Arkansas",
      "abbreviation": "AR"
    },
    {
      "name": "California",
      "abbreviation": "CA"
    },
    {
      "name": "Colorado",
      "abbreviation": "CO"
    },
    {
      "name": "Connecticut",
      "abbreviation": "CT"
    },
    {
      "name": "Delaware",
      "abbreviation": "DE"
    },
    {
      "name": "District Of Columbia",
      "abbreviation": "DC"
    },
    {
      "name": "Federated States Of Micronesia",
      "abbreviation": "FM"
    },
    {
      "name": "Florida",
      "abbreviation": "FL"
    },
    {
      "name": "Georgia",
      "abbreviation": "GA"
    },
    {
      "name": "Guam",
      "abbreviation": "GU"
    },
    {
      "name": "Hawaii",
      "abbreviation": "HI"
    },
    {
      "name": "Idaho",
      "abbreviation": "ID"
    },
    {
      "name": "Illinois",
      "abbreviation": "IL"
    },
    {
      "name": "Indiana",
      "abbreviation": "IN"
    },
    {
      "name": "Iowa",
      "abbreviation": "IA"
    },
    {
      "name": "Kansas",
      "abbreviation": "KS"
    },
    {
      "name": "Kentucky",
      "abbreviation": "KY"
    },
    {
      "name": "Louisiana",
      "abbreviation": "LA"
    },
    {
      "name": "Maine",
      "abbreviation": "ME"
    },
    {
      "name": "Marshall Islands",
      "abbreviation": "MH"
    },
    {
      "name": "Maryland",
      "abbreviation": "MD"
    },
    {
      "name": "Massachusetts",
      "abbreviation": "MA"
    },
    {
      "name": "Michigan",
      "abbreviation": "MI"
    },
    {
      "name": "Minnesota",
      "abbreviation": "MN"
    },
    {
      "name": "Mississippi",
      "abbreviation": "MS"
    },
    {
      "name": "Missouri",
      "abbreviation": "MO"
    },
    {
      "name": "Montana",
      "abbreviation": "MT"
    },
    {
      "name": "Nebraska",
      "abbreviation": "NE"
    },
    {
      "name": "Nevada",
      "abbreviation": "NV"
    },
    {
      "name": "New Hampshire",
      "abbreviation": "NH"
    },
    {
      "name": "New Jersey",
      "abbreviation": "NJ"
    },
    {
      "name": "New Mexico",
      "abbreviation": "NM"
    },
    {
      "name": "New York",
      "abbreviation": "NY"
    },
    {
      "name": "North Carolina",
      "abbreviation": "NC"
    },
    {
      "name": "North Dakota",
      "abbreviation": "ND"
    },
    {
      "name": "Northern Mariana Islands",
      "abbreviation": "MP"
    },
    {
      "name": "Ohio",
      "abbreviation": "OH"
    },
    {
      "name": "Oklahoma",
      "abbreviation": "OK"
    },
    {
      "name": "Oregon",
      "abbreviation": "OR"
    },
    {
      "name": "Palau",
      "abbreviation": "PW"
    },
    {
      "name": "Pennsylvania",
      "abbreviation": "PA"
    },
    {
      "name": "Puerto Rico",
      "abbreviation": "PR"
    },
    {
      "name": "Rhode Island",
      "abbreviation": "RI"
    },
    {
      "name": "South Carolina",
      "abbreviation": "SC"
    },
    {
      "name": "South Dakota",
      "abbreviation": "SD"
    },
    {
      "name": "Tennessee",
      "abbreviation": "TN"
    },
    {
      "name": "Texas",
      "abbreviation": "TX"
    },
    {
      "name": "Utah",
      "abbreviation": "UT"
    },
    {
      "name": "Vermont",
      "abbreviation": "VT"
    },
    {
      "name": "Virgin Islands",
      "abbreviation": "VI"
    },
    {
      "name": "Virginia",
      "abbreviation": "VA"
    },
    {
      "name": "Washington",
      "abbreviation": "WA"
    },
    {
      "name": "West Virginia",
      "abbreviation": "WV"
    },
    {
      "name": "Wisconsin",
      "abbreviation": "WI"
    },
    {
      "name": "Wyoming",
      "abbreviation": "WY"
    }
  ]


  /**
   * CA States List
   */
  StatesCA: any = [
    {
      "name": "Alberta",
      "abbreviation": "Alberta"
    },
    {
      "name": "British Columbia",
      "abbreviation": "British Columbia"
    },
    {
      "name": "Manitoba",
      "abbreviation": "Manitoba"
    },
    {
      "name": "New Brunswick",
      "abbreviation": "New Brunswick"
    },
    {
      "name": "Newfoundland and Labrador",
      "abbreviation": "Newfoundland"
    },
    {
      "name": "Northwest Territories",
      "abbreviation": "Northwest Territory"
    },
    {
      "name": "Nova Scotia",
      "abbreviation": "Nova Scotia"
    },
    {
      "name": "Nunavut",
      "abbreviation": "Nunavut"
    },
    {
      "name": "Ontario",
      "abbreviation": "Ontario"
    },
    {
      "name": "Prince Edward Island",
      "abbreviation": "Prince Edward Island"
    },
    {
      "name": "Quebec",
      "abbreviation": "Quebec"
    },
    {
      "name": "Saskatchewan",
      "abbreviation": "Saskatchewan"
    },
    {
      "name": "Yukon Territory",
      "abbreviation": "Yukon Territory"
    }
  ]


}
