import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { Subscription } from 'rxjs';
import { Theme } from 'src/app/shared/service/AutoTheme';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { AuthenticationService } from '../../authentication/authentication.service';

@Component({
  templateUrl: './dashboard.component.html',
  styleUrls: ['./dashboard.component.css'],
})
export class DashboardComponent implements OnInit {

  public spiner: boolean;
  public spiner1: boolean = true;
  public spiner2: boolean;
  toDate: Date | any;
  fromDate: Date | any;
  isAdmin: Boolean = false;
  isCustomer: boolean = false;
  userlist: any = [];
  userlist1: any;
  username: any;

  subscription: Subscription;

  public leftsetting: boolean;
  user: any = "";
  errMessage: any = "";
  idaccount: any;
  iduser: any;
  account: any;
  idaccountuser: any;
  kyc_status: any;


  constructor(private authservice: AuthenticationService,
    private userService: UsermanagementService, public them: Theme,
    private router: Router, private activatedRoute: ActivatedRoute) {

    //this.SetSystemTZ()
  }

  ngOnInit() {
    //  dropdown value
    let isLoggedIn = sessionStorage.getItem("isLoggedIn");
    let user = JSON.parse(isLoggedIn);
    this.username = user.username;
    if (user.type == '1') {
      this.isAdmin = true;
      this.isCustomer = false;
      this.idaccountuser = '0';
    }
    else if (user.type == '2') {
      this.isAdmin = false;
      this.isCustomer = true
      this.idaccountuser = '0';
    }
    else {
      this.isAdmin = false;
      this.isCustomer = false
      this.idaccountuser = user.iduser;
    }


    this.userService.customerList().subscribe(res => {
      this.userlist = res.data;
    }, err => {
    });


    this.userService.getUsers("main").subscribe(res => {
      this.userlist1 = res.data[0];
    }, err => {
    });
    // closed here

    this.activatedRoute.paramMap.subscribe((param: ParamMap) => {
      this.user = param.get("id");
      if (this.user) {
        this.userService.morphingSession(this.user).subscribe(res => {
          if (res.status == 200) {
              let userData = res.data[0];
              this.userService.getSingleUsersForAdmin(userData.iduser).subscribe(res => {
              // To KYC Status
              this.kyc_status = res.data1[0].kyc_verify_status;   
              sessionStorage.clear();
              sessionStorage.setItem('isLoggedIn', JSON.stringify(userData));
              sessionStorage.setItem('authkey', userData.authkey);
              sessionStorage.setItem('type', userData.type);
              sessionStorage.setItem('iduser', userData.iduser);
              sessionStorage.setItem('username', userData.username);
              sessionStorage.setItem('idaccount', userData.idaccount);
              sessionStorage.setItem('client_time', userData.client_time);
              if (userData.isPlan != "true" || userData.isAddress != "true" || userData.isEmailVerify != "true" || userData.isMobileVerify != "true") {
                this.router.navigate(['/user/verify-profile']).then(res => {
                      window.location.reload();
                    });
              }else if(userData.newUser_status==1 && userData.isCard!="true")
              {
                  this.router.navigate(['/user/credit-card-authorization']).then(res => {
                      window.location.reload();
                    });
              }
              else if(userData.newUser_status==1 && userData.type==2 && (this.kyc_status == 0 || this.kyc_status == 2 || this.kyc_status == 3 ))
              {
                this.router.navigate(['/user/account-action']).then(res => {
                  window.location.reload();
                });
              }else if(userData.newUser_status==1 && userData.type==2 && this.kyc_status == 1 )
              {
                this.router.navigate(['/dashboards']).then(res => {
                  window.location.reload();
                });
              }
              else{
                this.router.navigate(['/dashboards']).then(res => {
                      window.location.reload();
                    });
              }
            // if (userData.isPlan == "true" && userData.isAddress == "true" && userData.isEmailVerify == "true" && userData.isMobileVerify == "true") {
            //   this.router.navigate(['/dashboards']).then(res => {
            //     window.location.reload();
            //   });
            // }
            // else {
            //   this.router.navigate(['/user/verify-profile']).then(res => {
            //     window.location.reload();
            //   });
            // }
          })
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        });
      }
      else {
        return
      }
    });

    this.toDate = this.current_datetime();
    this.fromDate = this.startDate();

    this.subscription = this.them.showmenu.subscribe(res => {
      this.leftsetting = res;
    });


    "use strict";

    function layoutsColors() {
      $(".sidebar").is("[data-background-color]") ? $("html").addClass("sidebar-color") : $("html").removeClass("sidebar-color"), $("body").is("[data-image]") ? $("body").css("background-image", 'url("' + $("body").attr("data-image") + '")') : $("body").css("background-image", "")
    }

    "use strict";

    // Setting Color

    $(window).resize(function () {
      $(window).width();
    });

    $('.changeBodyBackgroundFullColor').on('click', function () {
      if ($(this).attr('data-color') == 'default') {
        $('body').removeAttr('data-background-full');
      } else {
        $('body').attr('data-background-full', $(this).attr('data-color'));
      }

      $(this).parent().find('.changeBodyBackgroundFullColor').removeClass("selected");
      $(this).addClass("selected");
      layoutsColors();
    });

    $('.changeLogoHeaderColor').on('click', function () {
      if ($(this).attr('data-color') == 'default') {
        $('.logo-header').removeAttr('data-background-color');
      } else {
        $('.logo-header').attr('data-background-color', $(this).attr('data-color'));
      }

      $(this).parent().find('.changeLogoHeaderColor').removeClass("selected");
      $(this).addClass("selected");
      customCheckColor();
      layoutsColors();
    });

    $('.changeTopBarColor').on('click', function () {
      if ($(this).attr('data-color') == 'default') {
        $('.main-header .navbar-header').removeAttr('data-background-color');
      } else {
        $('.main-header .navbar-header').attr('data-background-color', $(this).attr('data-color'));
      }

      $(this).parent().find('.changeTopBarColor').removeClass("selected");
      $(this).addClass("selected");
      layoutsColors();
    });

    $('.changeSideBarColor').on('click', function () {
      if ($(this).attr('data-color') == 'default') {
        $('.sidebar').removeAttr('data-background-color');
      } else {
        $('.sidebar').attr('data-background-color', $(this).attr('data-color'));
      }

      $(this).parent().find('.changeSideBarColor').removeClass("selected");
      $(this).addClass("selected");
      layoutsColors();
    });

    $('.changeBackgroundColor').on('click', function () {
      $('body').removeAttr('data-background-color');
      $('body').attr('data-background-color', $(this).attr('data-color'));
      $(this).parent().find('.changeBackgroundColor').removeClass("selected");
      $(this).addClass("selected");
    });

    function customCheckColor() {
      var logoHeader = $('.logo-header').attr('data-background-color');
      if (logoHeader !== "white") {
        $('.logo-header .navbar-brand').attr('src', './assets/img/logo.png');
      } else {
        $('.logo-header .navbar-brand').attr('src', './assets/img/logo.png');
      }
    }


    var toggle_customSidebar = false,
      custom_open = 0;

    if (!toggle_customSidebar) {
      var toggle = $('.custom-template .custom-toggle');

      toggle.on('click', (function () {
        if (custom_open == 1) {
          $('.custom-template').removeClass('open');
          toggle.removeClass('toggled');
          custom_open = 0;
        } else {
          $('.custom-template').addClass('open');
          toggle.addClass('toggled');
          custom_open = 1;
        }
      })
      );
      toggle_customSidebar = true;
    }
  }

  onLoaCall(e: number) {
    // for calls report
    if (e == 1) {
      this.spiner1 = true;
      this.spiner2 = false;
    }

    // for messages report
    if (e == 2) {
      this.spiner2 = true;
      this.spiner1 = false;
    }
  }


  /**
   * To setup the system Timezone
   */
  private SetSystemTZ(): void {
    let ctz: any = sessionStorage.getItem("client_time")
    if (ctz == null || ctz == "null" || ctz == "" || !ctz) {
      let systz: any = this.SystemTZ()
      this.authservice.SetSystemTZ({
        utc: systz.utc,
        tzCode: systz.tzCode
      }).subscribe(res => {
      }, err => {
      })
    }
  }


  /**
   * To get the system Timezone
   */
  private SystemTZ(): any {
    var offset: any = new Date().getTimezoneOffset().toString()
    let utc: any = null
    let tzCode: any = Intl.DateTimeFormat().resolvedOptions().timeZone
    offset = offset.indexOf("-") > -1 ? offset.substr(1, offset.length) : "-" + offset

    if (parseInt(offset) % 60 !== 0) {
      if (offset.indexOf("-") > -1) {
        offset = offset.substr(1, offset.length)
        offset = (parseInt(offset) - 30) / 60
        utc = offset.strlen > 1 ? "-" + offset + ":30" : "-0" + offset + ":30"
      }
      else {
        offset = (parseInt(offset) - 30) / 60
        utc = offset.strlen > 1 ? "+" + offset + ":30" : "+0" + offset + ":30"
      }
    }
    else {
      if (offset.indexOf("-") > -1) {
        offset = offset.substr(1, offset.length)
        utc = offset.strlen > 1 ? "-" + offset + ":00" : "-0" + offset + ":00"
      }
      else {
        utc = offset.strlen > 1 ? "+" + offset + ":00" : "+0" + offset + ":00"
      }
    }
    return {
      utc: utc,
      tzCode: tzCode
    }
  }

  ngOnDestroy() {
    this.subscription.unsubscribe();
    this.leftsetting = false;
  }

  startDate() {
    let now = new Date();
    let year = "" + now.getFullYear();
    let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
    let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
    let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
    let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
    let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
    return year + '-' + month + "-" + "01";
  }


  current_datetime() {
    let now = new Date();
    let year = "" + now.getFullYear();
    let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
    let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
    let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
    let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
    let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
    return year + '-' + month + "-" + day;
  }

  
  /**
   * To change the report's data sub-customer wise
   */
  onSelectedUser(value: string) {
    if (value) {
      this.idaccountuser = value
    }
  }

}
