import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { GetnumbersComponent } from './getnumbers/getnumbers.component';
import { DidComponent } from './did/did.component';
import { UncompletecallComponent } from './uncompletecall/uncompletecall.component';
import { CompletecallComponent } from './completecall/completecall.component';
import { ManagesitesComponent } from './managesites/managesites.component';
import { IpaddressComponent } from './ipaddress/ipaddress.component';
import { AddcartComponent } from './addcart/addcart.component';
import { CalldetailsrecordComponent } from './calldetailsrecord/calldetailsrecord.component';
import { LoadnumberComponent } from './loadnumber/loadnumber.component';
import { OrdersHistoryComponent } from './orders-history/orders-history.component';
import { ViewOrderComponent } from './view-order/view-order.component';
import { DisDidRestoreComponent } from './dis-did-restore/dis-did-restore.component';
import { DidHistoryComponent } from './did-history/did-history.component';
import { DidHistoryDetailsComponent } from './did-history-details/did-history-details.component';
const routes: Routes = [
    {
        path: '',
        children: [
            {
                path: '',
                component: GetnumbersComponent,
                data: {
                    title: 'Dashboard',
                    urls: [
                        {
                            title: 'Dashboard',
                            url: '/dashboards/dashboard'
                        },
                        {
                            title: 'Dashboard'
                        }
                    ]
                }
            },
            {
                path: 'get-numbers',
                component: GetnumbersComponent,
                data: {
                    title: 'Get Numbers',
                    urls: [
                        {
                            title: 'Inbound'
                        },
                        {
                            title: 'Get Numbers'
                        }
                    ]
                }
            },

            {
                path: 'load-numbers',
                component: LoadnumberComponent,
                data: {
                    title: 'load-numbers',
                    urls: [
                        {
                            title: 'Inbound',

                        },
                        {
                            title: 'load numbers'
                        }
                    ]
                }
            },
            {
                path: 'uncompleted-call',
                component: UncompletecallComponent,
                data: {
                    title: 'Uncompleted Call',
                    urls: [
                        {
                            title: 'Inbound',
                            //   url: '/inbound/uncompleted-call'
                        },
                        {
                            title: 'Uncompleted Call'
                        }
                    ]
                }
            },
            {
                path: 'completed-call',
                component: CompletecallComponent,
                data: {
                    title: 'Completed Call',
                    urls: [
                        {
                            title: 'Inbound',
                            //   url: '/inbound/completed-call'
                        },
                        {
                            title: 'Completed Call'
                        }
                    ]
                }
            },
            {
                path: 'cart',
                component: AddcartComponent,
                data: {
                    title: 'Inbound',
                    urls: [
                        {
                            title: 'Inbound',

                        },
                        {
                            title: 'Cart'
                        }
                    ]
                }
            },
            {
                path: 'manage-sites',
                component: ManagesitesComponent,
                data: {
                    title: 'Manage Site',
                    urls: [
                        {
                            title: 'Inbound',
                            //   url: '/inbound/manage-sites'
                        },
                        {
                            title: 'Manage Site'
                        }
                    ]
                }
            },
            {
                path: 'ip-address',
                component: IpaddressComponent,
                data: {
                    title: 'IP Address',
                    urls: [
                        {
                            title: 'Inbound',
                            //   url: '/inbound/ip-address'
                        },
                        {
                            title: 'IP Address'
                        }
                    ]
                }
            },
            {
                path: 'call-detail-records',
                component: CalldetailsrecordComponent,
                data: {
                    title: 'Call Detail Records',
                    urls: [
                        {
                            title: 'Inbound',

                        },
                        {
                            title: 'Call Detail Records'
                        }
                    ]
                }
            },
            {
                path: 'manage-numbers',
                component: DidComponent,
                data: {
                    title: 'Manage Numbers',
                    urls: [
                        {
                            title: 'Inbound',

                        },
                        {
                            title: 'Manage Numbers'
                        }
                    ]
                }
            },
            {
                path: 'orders-history',
                component: OrdersHistoryComponent,
                data: {
                    title: 'Orders History',
                    urls: [
                        {
                            title: 'Inbound',

                        },
                        {
                            title: 'Orders History'
                        }
                    ]
                }
            },
            {
                path: 'view-order/:id',
                component: ViewOrderComponent,
                data: {
                    title: 'View Order',
                    urls: [
                        {
                            title: 'Inbound',

                        },
                        {
                            title: 'View Order'
                        }
                    ]
                }
            },
            {
                path: 'restore',
                component: DisDidRestoreComponent,
                data: {
                    title: 'Disconnect Bulk',
                    urls: [
                        {
                            title: 'Inbound',

                        },
                        {

                        }
                    ]
                }
            },
            {
                path: 'restore-did',
                component: DisDidRestoreComponent,
                data: {
                    title: 'Restore DID',
                    urls: [
                        {
                            title: 'Restore DID',
                        }
                    ]
                }
            },
            {
                path: 'history-did',
                component: DidHistoryComponent,
                data: {
                    title: 'DID History',
                    urls: [
                        {
                            title: 'Inbound',

                        },
                        {
                            title: 'DID History'
                        }
                    ]
                }
            },
            {
                path: 'did-history-detail/:did',
                component: DidHistoryDetailsComponent,
                data: {
                    title: 'Did History Detail',
                    urls: [
                        {
                            title: 'Inbound',

                        },
                        {
                            title: 'DID History'
                        }
                    ]
                }
            },
        ]
    }

];

@NgModule({
    imports: [RouterModule.forChild(routes)],
    exports: [RouterModule]
})
export class InboundRoutingModule { }
