import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { ReactiveFormsModule } from '@angular/forms';
import { InboundRoutingModule } from './inbound-routing.module';
import { GetnumbersComponent } from './getnumbers/getnumbers.component';
import { ChartsModule } from 'ng2-charts';
import { UncompletecallComponent } from './uncompletecall/uncompletecall.component';
import { CompletecallComponent } from './completecall/completecall.component';
import { ManagesitesComponent } from './managesites/managesites.component';
import { IpaddressComponent } from './ipaddress/ipaddress.component';
import { InboundService } from './inbound.service'
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { Ng2SearchPipeModule } from 'ng2-search-filter';
import { FormsModule } from '@angular/forms';
import { NgxPaginationModule } from 'ngx-pagination';
import { SharedModule } from '../shared/shared.module';
import { TollfreenumbersComponent } from './tollfreenumbers/tollfreenumbers.component';
import { AddcartComponent } from './addcart/addcart.component';
import { CalldetailsrecordComponent } from './calldetailsrecord/calldetailsrecord.component';
import { DidComponent } from './did/did.component';
import { LoadnumberComponent } from './loadnumber/loadnumber.component';
import { MatTooltipModule } from '@angular/material/tooltip';
import { DateFilter } from './datefilter.pipe';
import { StoreModule } from '@ngrx/store';
import { inboundReducer } from './inbound.reducer';
import { MatExpansionModule } from '@angular/material/expansion';
import {MatAutocompleteModule} from '@angular/material/autocomplete';
import {MatFormFieldModule} from '@angular/material/form-field';
import { MatInputModule } from '@angular/material/input';
import { NgMultiSelectDropDownModule } from 'ng-multiselect-dropdown';
import { OrderPipe } from './orderPipe.pipe';
import { OrdersHistoryComponent } from './orders-history/orders-history.component';
import { ViewOrderComponent } from './view-order/view-order.component';
import { DisDidRestoreComponent } from './dis-did-restore/dis-did-restore.component';
import { DidHistoryComponent } from './did-history/did-history.component';
import { DidHistoryDetailsComponent } from './did-history-details/did-history-details.component';

@NgModule({
  declarations: [
    GetnumbersComponent, 
    UncompletecallComponent, 
    CompletecallComponent, 
    ManagesitesComponent, 
    IpaddressComponent, 
    TollfreenumbersComponent, 
    AddcartComponent, 
    CalldetailsrecordComponent, 
    DidComponent, 
    LoadnumberComponent, 
    DateFilter,
    OrderPipe,
    OrdersHistoryComponent,
    ViewOrderComponent,
    DisDidRestoreComponent,
    DidHistoryComponent,
    DidHistoryDetailsComponent,
    
  ],
  imports: [
    CommonModule,
    InboundRoutingModule,
    ReactiveFormsModule,
    ChartsModule,
    NgbModule,
    SharedModule,
    Ng2SearchPipeModule,
    FormsModule,
    MatTooltipModule,
    NgxPaginationModule,
    SharedModule,        
    MatAutocompleteModule,
    MatExpansionModule,
    MatFormFieldModule,
    MatInputModule,
    NgMultiSelectDropDownModule,
    
    
  ],
  providers: [
    OrderPipe,
  ],
  entryComponents: [
    //TollfreenumbersComponent
  ]
})
export class InboundModule { }
