import { Component, ViewChild } from '@angular/core';
import { InboundService } from '../inbound.service'
import { Router } from '@angular/router';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { BehaviorSubject } from 'rxjs';
import { CapmaignserviceService } from 'src/app/campaign/capmaignservice.service';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import * as XLSX from 'xlsx';
import { saveAs } from 'file-saver';
import { timestamp } from 'rxjs/operators';
import { clear } from 'console';
import { threadId } from 'worker_threads';
declare var $: any;

@Component({
  selector: 'app-orders-history',
  templateUrl: './orders-history.component.html',
  styleUrls: ['./orders-history.component.css']
})
export class OrdersHistoryComponent extends AppComponentClass<any, any> {
  filtre: string;
  searchText = { count: 0 };
  page = 1;
  field: any;
  header: any;
  count = 0;
  tableSize = 50;
  tableSizes = [50, 100, 150];
  filterTerm: string
  responseMessage: any = "";
  errMessage: any = "";
  dids: any = [];
  tab1$ = new BehaviorSubject<any>("");
  tab1 = this.tab1$.asObservable();
  tab1Value = "";
  tab2$ = new BehaviorSubject<any>("");
  tab2 = this.tab1$.asObservable();
  tab2Value = "";
  tab3$ = new BehaviorSubject<any>("");
  tab3 = this.tab1$.asObservable();
  tab3Value = "";
  connectionLists: any;
  iddid: any;
  connectionKey$ = new BehaviorSubject<any>("");
  connection = this.connectionKey$.asObservable();
  connectionValue = "";
  inboundKey$ = new BehaviorSubject<any>("");
  inbound = this.inboundKey$.asObservable();
  inboundValue = "";
  outboundKey$ = new BehaviorSubject("");
  outbound = this.outboundKey$.asObservable();
  outboundValue = "";
  campaigns: any = [];
  campaign = "";
  did: string = "";
  selectedDid: any = [];
  isChecked: Boolean = false;
  isSelected: Boolean = false;
  users: any = [];
  brandId: any = null;
  isCampaign: boolean = false;
  camp: any;
  uploadDid: FormGroup;
  file: File | any;
  fileView: any;
  upload: any;
  public submitted: boolean = false;
  isAdmin: boolean = false;
  username: any;
  filterForm: FormGroup;
  monthNameList: any = [];
  /* didList: any = []; */
  public show: boolean = false;
  EXCEL_TYPE = 'application/csv';
  EXCEL_EXTENSION = '.csv';

  DidProviders: any = [
    { name: "thinQ", value: "ThinQ" },
    { name: "inteliQ", value: "InteliQ" },
    { name: "teleapi", value: "Teleapi" },
    { name: "Peerless", value: "Peerless" },
    { name: "coreTel", value: "CoreTel" }
  ]
  NumberType: any = [
    { type: "Local Number", value: "NN" },
    { type: "Toll-Free Number", value: "TF" }
  ]
  CurrentUConn: any = []

  dIFlag: boolean = false
  dIFBtn: string = "Import DID"
  stateList: any;

  OrdersList: any = []
  userType: number;

  constructor(
    public data: InboundService,
    public router: Router,
    public fb: FormBuilder,
    private userService: UsermanagementService,
    private campService: CapmaignserviceService) {
    super(data, router, fb);
  }

  ngOnInit(): void {
    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.userType = session.type;

    this.OrdersList = [];
    this.data.GetOrdersHistory("").subscribe(res => {
      if (res.error == 0) {
        this.OrdersList = res.data
        $('#basic-datatables15').DataTable().clear();
        $('#basic-datatables15').DataTable().destroy();
        $.getScript('./assets/table.js')
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
    this.filterForm = this.fb.group({
      group_id: new FormControl("", [Validators.required]),
      selectedUser: new FormControl("", [Validators.required]),
    });
  }
  //Export CSV
  downloadCSVFile(id: number) {
    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);

    let uidandacnt = session.iduser + '-' + session.idaccount;
    this.filterForm.patchValue({
      group_id: id,
      selectedUser: uidandacnt
    });
    if (this.filterForm.invalid) {
      return false;
    }
    else {
      this.data.exportorderDID(this.filterForm.value).subscribe(res => {
        if (res.status == 200) {
          let manageDID = res.data;
          const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(manageDID);
          const workbook: XLSX.WorkBook = { Sheets: { 'did': worksheet }, SheetNames: ['did'] };
          const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
          this.saveAsExcelFile(excelBuffer, "orderdid_" + res.username + "_");
        }
      })
    }
  }

  private saveAsExcelFile(buffer: any, fileName: string): void {
    const data: Blob = new Blob([buffer], {
      type: this.EXCEL_TYPE
    });
    //let dateObj = new Date();
    let date = new Date().toLocaleDateString('en-US').replace('_', '/');
    saveAs(data, fileName + date + this.EXCEL_EXTENSION);


  }
  /**
   * To view the order
   */
  ViewOrder(id_grouporder: number): void {
    if (id_grouporder > 0) {
      this.router.navigate(["/inbound/view-order/" + id_grouporder])
    }
  }

}