
import { Attribute, Component, ViewEncapsulation } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { NewCamapignService } from '../new-camapign.service';


@Component({
  selector: 'app-addnew-brand',
  templateUrl: './addnew-brand.component.html',
  styleUrls: ['./addnew-brand.component.css'],
  // encapsulation: ViewEncapsulation.None
})
export class AddnewBrandComponent extends AppComponentClass<any, any> {
  public newbrandForm: FormGroup;
  public contactdetailsForm: FormGroup;
  public submitted: boolean = false;
  brand: any;
  Organization: any;
  stockExchange: any;
  brandRelationship: any;
  US_State: any;
  CA_State: any;
  States: any = [];
  chosenOPT: string = "";
  chosenOrg: string = "";
  chosenDun: any;
  country: any = [];
  brandVertical: any;
  public Private: any;
  centerAlertMessage: any = "";
  errMessage: any = "";
  responseMessage: any = "";
  getOldID: any = "";
  isDisable1: boolean = false;
  isDisable2: boolean = false;
  formJoin: any;
  USA: boolean = false;
  Canada: boolean = false;
  company: any;
  altBusinessIdType: any = [];
  Address: any;
  // hidden1: boolean = false;
  // hidden2: boolean = false;
  chosenDunLimit: any;
  zipLength: any = '';
  selectedItems: any[];
  dropdownSettings: IDropdownSettings = {};
  closeDropdownSelection = true;
  chosenvert:any;
  mobilelabel:any="Mobile Phone";
  public solesubmit: boolean = false;
  EINlength: any;
  selectRelation: boolean = false;
  EINMsag: string;
  featureServiceData: any;
  isDisabledServiceStatus: boolean;
	serviceMessage:any='Brand service has been suspended. More information please contact support';
  allowButtonClick : boolean = false;

  constructor(public data: NewCamapignService,
    private userService: UsermanagementService,
    public router: Router, public fb: FormBuilder,
    private route: ActivatedRoute) {
    super(data, router, fb);
  }

  firstFormGroup: FormGroup;
  secondFormGroup: FormGroup;


  ngOnInit(): void {
    this.userService.getfeatureServiceStatus().subscribe(res => {
      this.featureServiceData = res.data.find(x => x.fs_id == '6');
			 if(this.featureServiceData!==undefined && this.featureServiceData.as_status==1)
			 {
				this.isDisabledServiceStatus=false;
			    
			 }else{
				this.isDisabledServiceStatus=true;
				this.showMsg();

			 }
       
     });
    this.newbrandForm = this.fb.group({
      companyName: [''],
      displayName: [''],
      entityType: [''],
      mock: [false],
      ein: [''],
      einIssuingCountry: [''],
      // cspId: [''],
      altBusinessIdType: [''],
      altBusinessId: [''],
      street: [''],
      city: [''],
      state: [''],
      postalCode: [''],
      country: [''],
      website: [''],
      stockSymbol: [''],
      stockExchange: [''],
      vertical: [''],
      referenceId: [''],
      firstName: [''],
      lastName: [''],
      brandRelationship: [''],
      mobilePhone: ['']
    });

    this.data.getAddress().subscribe(res => {
      if (res.status == 200) {
        this.Address = res.data[0];
        // this.newbrandForm.patchValue({
          // street:this.Address.address,
          // city:this.Address.city,
          // state:this.Address.state,
          // postalCode:this.Address.postal_code,
          // country:this.Address.country,
          // website:this.Address.website
        // })
      }
    }); 


    this.contactdetailsForm = this.fb.group({
      email: ['', [Validators.required, Validators.pattern("^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[a-z]{2,4}$")]],
      phone: [''],
    });

    this.firstFormGroup = this.fb.group({
      firstCtrl: ['', Validators.required]
    });
    this.secondFormGroup = this.fb.group({
      secondCtrl: ['', Validators.required]
    });

    this.getCountry();
    this.data.getBrands().subscribe(res => {
      this.brand = res[0].form_details;
      this.AddmendetoryBegin();
    });

    this.data.getlegalOrg().subscribe(res => {
      this.Organization = res[0].legal_org;
    });

    this.data.altBusinessIdType().subscribe(res => {
      //this.altBusinessIdType = res.data;
      this.altBusinessIdType = res.data.slice(1, 4);
    });

    this.data.stock_Exchange().subscribe(res => {
      this.stockExchange = res.data;
    });

    this.data.brandRelationship().subscribe(res => {
      if (res.status == 200) {
        this.brandRelationship = res.data;
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        });
      }
    });

    this.data.brandVertical().subscribe(res => {
      let tmp: any = [];
      Object.entries(res.data).forEach((ele: any) => {
        let t = ele[1];
        t["name"] = ele[0];
        tmp.push(t);
      });
      tmp.push({ industryId: 8956, name: "NON PROFITABLE ORGANIZATION" });
      this.brandVertical = tmp;
    });

    this.dropdownSettings = {
      singleSelection: true,
      idField: 'industryId',
      textField: 'name',
      itemsShowLimit: 3,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };
    this.disableTextField();
  }

  disableTextField(){
  this.newbrandForm.get("ein").disable();
  this.newbrandForm.get("altBusinessId").disable();
  this.newbrandForm.get("street").disable();
  this.newbrandForm.get("city").disable();
  this.newbrandForm.get("postalCode").disable();
  this.newbrandForm.get("website").disable();
  this.newbrandForm.get("stockSymbol").disable();
  this.newbrandForm.get("referenceId").disable();
  this.newbrandForm.get("firstName").disable();
  this.newbrandForm.get("lastName").disable();
  }

  AddmendetoryBegin(){
    this.brand.forEach(element => {
      if(element.ID == "companyName" || element.ID == "displayName" || element.ID == "entityType" || element.ID == "countryreg" ||
       element.ID == "taxId" || element.ID == "address" || element.ID == "city" || element.ID == "selectedState" ||
       element.ID == "post" || element.ID == "vertical"){
        if(element.label.indexOf("*") == -1){
          element.label = element.label +' *';
        }
       }
    });
  }

  getverical(value:any){
    this.newbrandForm.patchValue({
      vertical:value
    })
  }

  getCountry() {
    this.country = [
      { value: "US", name: "US" },
      { value: "CA", name: "CA" }
    ]
  }

  changeCountry() {
    if(this.chosenOrg == 'SOLE_PROPRIETOR'){
      this.newbrandForm.get('einIssuingCountry').setValidators([]);
    }
    else{
      this.newbrandForm.get('einIssuingCountry').setValue(this.chosenOPT);
    }
    this.States = [''];
    this.newbrandForm.patchValue({
      state:'',
      postalCode:'',
      city:'',
      street:'',
      ein:''
    });

    if (this.chosenOPT == 'US') {
      this.data.US_State().subscribe(res => {
        this.States = res[0].US_State;
      });

      this.brand.forEach(element => {
        if(this.chosenOrg !== 'SOLE_PROPRIETOR'){
          if (element.ID == "taxId") {
            if(element.label.indexOf("*") == -1){
              element.label = "EIN" +' *';
            }
            else{
              element.label = "EIN" +' *';
            }
          }
          if (element.ID == "tax") {
            if(element.label.indexOf("*") == -1){
              element.label = "EIN Issuing Country" +' *';
            }
            else{
              element.label = "EIN Issuing Country" +' *';
            }
          }
        }
        else{
          if (element.ID == "taxId") {
            element.label = "Tax Number/ID/EIN";
          }
          if(element.ID == "tax"){
            element.label = "Tax Number/ID/EIN Issuing Country";
          }
        }
        if (element.ID == "selectedState") {
          if(element.label.indexOf("*") == -1){
            element.label = "State" +' *';
          }
          else{
            element.label = "State" +' *';
          }
        }
        if (element.ID == "post") {
          if(element.label.indexOf("*") == -1){
            element.label = "Zip Code" +' *';
          }
          else{
            element.label = "Zip Code" +' *';
          }
        }
      });
      // for pincode
      this.USA = true;
      this.Canada = false;
      this.orgCountryPincode();
    }
    else if (this.chosenOPT == 'CA') {
      this.data.CA_State().subscribe(res => {
        this.States = res[0].CA_State;
      });
      this.brand.forEach(element => {
        if (element.ID == "taxId") {
          if(element.label.indexOf("*") == -1){
            element.label = "Tax Number/ID" +' *';
          }
          else{
            element.label = "Tax Number/ID" +' *';
          }
        }
        if (element.ID == "tax") {
          if(element.label.indexOf("*") == -1){
            element.label = "Tax Number/ID Issuing Country" +' *';
          }
          else{
            element.label = "Tax Number/ID Issuing Country" +' *';
          }
        }

        if (element.ID == "selectedState") {
          if(element.label.indexOf("*") == -1){
            element.label = "State/Region" +' *';
          }
          else{
            element.label = "State/Region" +' *';
          }
        }
        if (element.ID == "post") {
          if(element.label.indexOf("*") == -1){
            element.label = "Postal Code" +' *';
          }
          else{
            element.label = "Postal Code" +' *';
          }
        }
      });
      // for pincode
      this.USA = false;
      this.Canada = true;
      this.orgCountryPincode();
    }
    else {
      this.States = [''];
      this.Canada = false;
      this.USA = false;
    }
    //enable field
    if (this.chosenOrg == 'PRIVATE_PROFIT') {
      this.privateCompany();
    }
    if (this.chosenOrg == 'SOLE_PROPRIETOR') {
      this.SoleProprietor();
    }
    if (this.chosenOrg == 'NON_PROFIT') {
      this.NonProfit();
    }
    if (this.chosenOrg == 'PUBLIC_PROFIT') {
      this.PubliclyTradedCompany();
    }
    if (this.chosenOrg == 'GOVERNMENT') {
      this.Government();
    }

  }

  changeNumber() {
    this.brand.forEach(element => {
      if (element.ID == "dunsnumber") {
        let Duns1: any = this.newbrandForm.get(element.formControl);
        Duns1.setValidators([Validators.maxLength(50)]);
        Duns1.updateValueAndValidity();
      }
      if (this.chosenDun == 'DUNS') {
        if (element.ID == "dunsnumber") {
          element.label = 'DUNS Number';
          // element.readonly = 'false';
          this.newbrandForm.get(element.formControl).enable();
          // this.chosenDunLimit = 9;
          // let Duns1: any = this.newbrandForm.get(element.formControl);
          // Duns1.setValidators([Validators.required, Validators.maxLength(9), Validators.minLength(9)]);
          // Duns1.updateValueAndValidity();
        }
      }
      else if (this.chosenDun == 'GIIN') {
        if (element.ID == "dunsnumber") {
          element.label = 'GIIN Number';
          // element.readonly = 'false';
          this.newbrandForm.get(element.formControl).enable();
          // this.chosenDunLimit = 19;
          // let Giin1: any = this.newbrandForm.get(element.formControl);
          // Giin1.setValidators([Validators.required, Validators.maxLength(19), Validators.minLength(19)]);
          // Giin1.updateValueAndValidity();
        }
      }
      else if (this.chosenDun == 'LEI') {
        if (element.ID == "dunsnumber") {
          element.label = 'LEI Number';
          // element.readonly = 'false';
          this.newbrandForm.get(element.formControl).enable();
          // this.chosenDunLimit = 20;
          // let Lei1: any = this.newbrandForm.get(element.formControl);
          // Lei1.setValidators([Validators.required, Validators.maxLength(20), Validators.minLength(20)]);
          // Lei1.updateValueAndValidity();
        }
      }
      else if (this.chosenDun == 'NONE') {
        if (element.ID == "dunsnumber") {
          element.label = 'NONE';
          // element.readonly = 'true';
          this.newbrandForm.get(element.formControl).disable();
        }
      }
      else {
        if (element.ID == "dunsnumber") {
          element.label = 'DUNS or GIIN or LEI Number';
        }
      }
    });
  }
  privateCompany() {
    this.brand.forEach(element => {
      if (element.ID == "companyName" || element.ID == "taxId" || element.ID == "address" || element.ID == "vertical" || element.ID == "countryreg" || element.ID == "displayName" || element.ID == "entityType"
        || element.ID == "tax" || element.ID == "duns" || element.ID == "city" || element.ID == "selectedState" || element.ID == "post" || element.ID == "website" || element.ID == "stock" || element.ID == "stockex" || element.ID == "refer" || element.ID == "firstname" || element.ID == "lastname") {

        if (element.ID == "companyName" || element.ID == "taxId" || element.ID == "address" || element.ID == "vertical" || element.ID == "countryreg" || element.ID == "displayName" || element.ID == "city" || element.ID == "post" || element.ID == "selectedState" || element.ID == "website") {
          if (element.ID == "taxId" || element.ID == "website") {
            if(element.ID == "taxId"){
              if(this.chosenOPT=="US"){
                this.EINlength="Invalid EIN is a nine-digit number";
                this.EINMsag="Text field Accept Only Number";
                let Private1: any = this.newbrandForm.get(element.formControl);
                Private1.setValidators([Validators.required, Validators.maxLength(9), Validators.minLength(9)]);
                Private1.updateValueAndValidity();
              }
              if(this.chosenOPT=="CA"){
                this.EINlength="Maximum 9 chars allowed for Tax Number/ID";
                this.EINMsag="Text field Accept Only Number,Capital Alphabet";
                let Private3: any = this.newbrandForm.get(element.formControl);
                Private3.setValidators([Validators.required, Validators.maxLength(9), Validators.minLength(9)]);
                Private3.updateValueAndValidity();
              }
            }
            if(element.ID == "website"){
              const urlRegex = /^(?:http(s)?:\/\/)?[\w.-]+(?:\.[\w\.-]+)+[\w\-\._~:/?#[\]@!\$&'\(\)\*\+,;=.]+$/;
              let Private4: any = this.newbrandForm.get(element.formControl);
              Private4.setValidators([Validators.pattern(urlRegex)]);
              Private4.updateValueAndValidity();
            }
          }
          else {
            this.Private = this.newbrandForm.get(element.formControl);
            this.Private.setValidators([Validators.required]);
            this.Private.updateValueAndValidity();
          }
          if (element.ID == "vertical") {
            element.disable = false;
          }
        }
        else {
          let Private2: any = this.newbrandForm.get(element.formControl);
          Private2.setValidators([]);
          Private2.updateValueAndValidity();
        }
      }
    });

    this.isDisable1 = true;
    // enable select dropdown
    this.newbrandForm.get("einIssuingCountry").enable();
    this.newbrandForm.get("altBusinessIdType").enable();
    this.newbrandForm.get("state").enable();

    // disable select dropdown
    this.newbrandForm.get("stockExchange").disable();
    this.newbrandForm.get("stockExchange").setValue('');

    this.brand.forEach(element => {
      // enable disable text field code
      if (element.ID == "taxId" || element.ID == "address" || element.ID == "city" || element.ID == "post" || element.ID == "website" || element.ID == "refer" || element.ID == "firstname" || element.ID == "lastname" || element.ID == "stock" || element.ID == "dunsnumber" || element.ID == "companyName") {

        if (element.ID == "taxId" || element.ID == "address" || element.ID == "city" || element.ID == "post" || element.ID == "website" || element.ID == "refer" || element.ID == "companyName") {
          this.newbrandForm.get(element.formControl).enable();
        }
        else {
          this.newbrandForm.get(element.formControl).disable();
          this.newbrandForm.get(element.formControl).setValue('');
        }
      }
    })
  }

  Government() {
    this.brand.forEach(element => {
      if (element.ID == "companyName" || element.ID == "taxId" || element.ID == "address" || element.ID == "vertical" || element.ID == "countryreg" || element.ID == "displayName" || element.ID == "entityType"
        || element.ID == "tax" || element.ID == "duns" || element.ID == "city" || element.ID == "selectedState" || element.ID == "post" || element.ID == "website" || element.ID == "stock" || element.ID == "stockex" || element.ID == "refer" || element.ID == "firstname" || element.ID == "lastname") {

        if (element.ID == "companyName" || element.ID == "displayName" || element.ID == "taxId" || element.ID == "address" || element.ID == "vertical" || element.ID == "countryreg" || element.ID == "city" || element.ID == "post" || element.ID == "selectedState" || element.ID == "website") {
          if (element.ID == "taxId" || element.ID == "website") {
            if(element.ID == "taxId"){
              if(this.chosenOPT=="US"){
                this.EINlength="Invalid EIN is a nine-digit number";
                this.EINMsag="Text field Accept Only Number";
                let Government: any = this.newbrandForm.get(element.formControl);
                Government.setValidators([Validators.required, Validators.maxLength(9), Validators.minLength(9)]);
                Government.updateValueAndValidity();
              }
              if(this.chosenOPT=="CA"){
                this.EINlength="Maximum 9 chars allowed for Tax Number/ID";
                this.EINMsag="Text field Accept Only Number,Capital Alphabet";
                let Government1: any = this.newbrandForm.get(element.formControl);
                Government1.setValidators([Validators.required, Validators.maxLength(9), Validators.minLength(9)]);
                Government1.updateValueAndValidity();
              }
            }
            if(element.ID == "website"){
              const urlRegex = /^(?:http(s)?:\/\/)?[\w.-]+(?:\.[\w\.-]+)+[\w\-\._~:/?#[\]@!\$&'\(\)\*\+,;=.]+$/;
              let Government4: any = this.newbrandForm.get(element.formControl);
              Government4.setValidators([Validators.pattern(urlRegex)]);
              Government4.updateValueAndValidity();
            }
          }
          else {
            let Government2: any = this.newbrandForm.get(element.formControl);
            Government2.setValidators([Validators.required]);
            Government2.updateValueAndValidity();
          }
          if (element.ID == "vertical") {
            element.disable = false;
          }
        }
        else {
          let Government3: any = this.newbrandForm.get(element.formControl);
          Government3.setValidators([]);
          Government3.updateValueAndValidity();
        }
      }
    });

    this.isDisable1 = true;
    // enable select dropdown
    this.newbrandForm.get("einIssuingCountry").enable();
    this.newbrandForm.get("altBusinessIdType").enable();
    this.newbrandForm.get("state").enable();

    // disable select dropdown
    this.newbrandForm.get("stockExchange").disable();
    this.newbrandForm.get("stockExchange").setValue('');

    this.brand.forEach(element => {
      if (element.ID == "taxId" || element.ID == "address" || element.ID == "city" || element.ID == "post" || element.ID == "website" || element.ID == "refer" || element.ID == "firstname" || element.ID == "lastname" || element.ID == "stock" || element.ID == "dunsnumber" || element.ID == "companyName") {
        if (element.ID == "taxId" || element.ID == "address" || element.ID == "city" || element.ID == "post" || element.ID == "website" || element.ID == "refer" || element.ID == "companyName") {
          this.newbrandForm.get(element.formControl).enable();
        }
        else {
          this.newbrandForm.get(element.formControl).disable();
          this.newbrandForm.get(element.formControl).setValue('');
        }
      }
    })
  }

  NonProfit() {
    this.brand.forEach(element => {
      if (element.ID == "companyName" || element.ID == "taxId" || element.ID == "address" || element.ID == "vertical" || element.ID == "countryreg" || element.ID == "displayName" || element.ID == "entityType"
        || element.ID == "tax" || element.ID == "duns" || element.ID == "city" || element.ID == "selectedState" || element.ID == "post" || element.ID == "website" || element.ID == "stock" || element.ID == "stockex" || element.ID == "refer" || element.ID == "firstname" || element.ID == "lastname") {

        if (element.ID == "companyName" || element.ID == "displayName" || element.ID == "taxId" || element.ID == "address" || element.ID == "vertical" || element.ID == "countryreg" || element.ID == "city" || element.ID == "post" || element.ID == "selectedState" || element.ID == "website") {
          if (element.ID == "taxId" || element.ID == "website") {
            if(element.ID == "taxId"){
              if(this.chosenOPT=="US"){
                this.EINlength="Invalid EIN is a nine-digit number";
                this.EINMsag="Text field Accept Only Number";
                let nonProfit: any = this.newbrandForm.get(element.formControl);
                nonProfit.setValidators([Validators.required, Validators.maxLength(9), Validators.minLength(9)]);
                nonProfit.updateValueAndValidity();
              }
              if(this.chosenOPT=="CA"){
                this.EINlength="Maximum 9 chars allowed for Tax Number/ID";
                this.EINMsag="Text field Accept Only Number,Capital Alphabet";
                let nonProfit4: any = this.newbrandForm.get(element.formControl);
                nonProfit4.setValidators([Validators.required, Validators.maxLength(9), Validators.minLength(9)]);
                nonProfit4.updateValueAndValidity();
              }
            }
            if(element.ID == "website"){
              const urlRegex = /^(?:http(s)?:\/\/)?[\w.-]+(?:\.[\w\.-]+)+[\w\-\._~:/?#[\]@!\$&'\(\)\*\+,;=.]+$/;
              let nonProfit1: any = this.newbrandForm.get(element.formControl);
              nonProfit1.setValidators([Validators.pattern(urlRegex)]);
              nonProfit1.updateValueAndValidity();
            }
          }
          else {
            let nonProfit2: any = this.newbrandForm.get(element.formControl);
            nonProfit2.setValidators([Validators.required]);
            nonProfit2.updateValueAndValidity();
          }
          if (element.ID == "vertical") {
            element.disable = false;
          }
        }
        else {
          let nonProfit3: any = this.newbrandForm.get(element.formControl);
          nonProfit3.setValidators([]);
          nonProfit3.updateValueAndValidity();
        }
      }
    });

    this.isDisable1 = true;
    // enable select dropdown
    this.newbrandForm.get("einIssuingCountry").enable();
    this.newbrandForm.get("altBusinessIdType").enable();
    this.newbrandForm.get("state").enable();

    // disable select dropdown
    this.newbrandForm.get("stockExchange").disable();
    this.newbrandForm.get("stockExchange").setValue('');

    this.brand.forEach(element => {
      if (element.ID == "taxId" || element.ID == "address" || element.ID == "city" || element.ID == "post" || element.ID == "website" || element.ID == "refer" || element.ID == "firstname" || element.ID == "lastname" || element.ID == "stock" || element.ID == "dunsnumber" || element.ID == "companyName") {
        if (element.ID == "taxId" || element.ID == "address" || element.ID == "city" || element.ID == "post" || element.ID == "website" || element.ID == "refer" || element.ID == "companyName") {
          // enable text field code
          this.newbrandForm.get(element.formControl).enable();
        }
        else {
          // disable text field code9
          this.newbrandForm.get(element.formControl).disable();
          this.newbrandForm.get(element.formControl).setValue('');
        }
      }
    })
  }

  SoleProprietor() {
    this.brand.forEach(element => {
      if (element.ID == "companyName" || element.ID == "taxId" || element.ID == "address" || element.ID == "vertical" || element.ID == "countryreg" || element.ID == "displayName" || element.ID == "entityType"
        || element.ID == "tax" || element.ID == "duns" || element.ID == "city" || element.ID == "selectedState" || element.ID == "post" || element.ID == "website" || element.ID == "stock" || element.ID == "stockex" || element.ID == "refer" || element.ID == "firstname" || element.ID == "lastname") {
        if (element.ID == "displayName" || element.ID == "address" || element.ID == "selectedState" || element.ID == "countryreg" || element.ID == "refer" || element.ID == "firstname" || element.ID == "lastname" || element.ID == "city" || element.ID == "post") {
          let sole1: any = this.newbrandForm.get(element.formControl);
          sole1.setValidators([Validators.required]);
          sole1.updateValueAndValidity();
        }
        else {
          let sole2: any = this.newbrandForm.get(element.formControl);
          sole2.setValidators([]);
          sole2.updateValueAndValidity();
        }
        if (element.ID == "vertical") {
          element.disable = false;
        }
      }
    });
    let mobile: any = this.newbrandForm.get('mobilePhone');
    mobile.setValidators([Validators.required, Validators.minLength(10), Validators.maxLength(11)]);
    mobile.updateValueAndValidity();
    this.isDisable1 = true;
    // enable select dropdown
    this.newbrandForm.get("mobilePhone").enable();
    this.newbrandForm.get("state").enable();
    // disable select dropdown
    this.newbrandForm.get("stockExchange").disable();
    this.newbrandForm.get("stockExchange").setValue('');
    this.newbrandForm.get("einIssuingCountry").disable();
    this.newbrandForm.get("einIssuingCountry").setValue('');
    this.newbrandForm.get("altBusinessIdType").disable();

    this.brand.forEach(element => {
      if (element.ID == "taxId" || element.ID == "address" || element.ID == "city" || element.ID == "post" || element.ID == "website" || element.ID == "refer" || element.ID == "firstname" || element.ID == "lastname" || element.ID == "stock" || element.ID == "dunsnumber" || element.ID == "companyName") {
        if (element.ID == "address" || element.ID == "city" || element.ID == "post" || element.ID == "website" || element.ID == "refer" || element.ID == "firstname" || element.ID == "lastname") {
          // enable text field code
          this.newbrandForm.get(element.formControl).enable();
        }
        else {
          // disable text field code
          this.newbrandForm.get(element.formControl).disable();
          this.newbrandForm.get(element.formControl).setValue('');
        }
      }
    })
  }

  PubliclyTradedCompany() {
    this.brand.forEach(element => {
      if (element.ID == "companyName" || element.ID == "taxId" || element.ID == "address" || element.ID == "vertical" || element.ID == "countryreg" || element.ID == "displayName" || element.ID == "entityType"
        || element.ID == "tax" || element.ID == "duns" || element.ID == "city" || element.ID == "selectedState" || element.ID == "post" || element.ID == "website" || element.ID == "stock" || element.ID == "stockex" || element.ID == "refer" || element.ID == "firstname" || element.ID == "lastname") {

        if (element.ID == "companyName" || element.ID == "displayName" || element.ID == "taxId" || element.ID == "address" || element.ID == "vertical" || element.ID == "countryreg" || element.ID == "stock" || element.ID == "stockex" || element.ID == "selectedState" || element.ID == "city" || element.ID == "post" || element.ID == "website") {
          if (element.ID == "taxId" || element.ID == "website" || element.ID == "stock") {
            if(element.ID == "taxId"){
              if(this.chosenOPT=="US"){
                this.EINlength="Invalid EIN is a nine-digit number";
                this.EINMsag="Text field Accept Only Number";
                let Public1: any = this.newbrandForm.get(element.formControl);
                Public1.setValidators([Validators.required, Validators.maxLength(9), Validators.minLength(9)]);
                Public1.updateValueAndValidity();
              }
              if(this.chosenOPT=="CA"){
                this.EINlength="Maximum 9 chars allowed for Tax Number/ID";
                this.EINMsag="Text field Accept Only Number,Capital Alphabet";
                let Public4: any = this.newbrandForm.get(element.formControl);
                Public4.setValidators([Validators.required, Validators.maxLength(9), Validators.minLength(9)]);
                Public4.updateValueAndValidity();
              }
            }
            if(element.ID == "website"){
              const urlRegex = /^(?:http(s)?:\/\/)?[\w.-]+(?:\.[\w\.-]+)+[\w\-\._~:/?#[\]@!\$&'\(\)\*\+,;=.]+$/;
              let Public: any = this.newbrandForm.get(element.formControl);
              Public.setValidators([Validators.pattern(urlRegex)]);
              Public.updateValueAndValidity();
            }
            if(element.ID == "stock"){
              let Public5: any = this.newbrandForm.get(element.formControl);
              Public5.setValidators([Validators.required, Validators.maxLength(10)]);
              Public5.updateValueAndValidity();
            }
          }
          else {
            let Public3: any = this.newbrandForm.get(element.formControl);
            Public3.setValidators([Validators.required]);
            Public3.updateValueAndValidity();
          }
          if (element.ID == "vertical") {
            element.disable = false;
          }
        }
        else {
          let Public2: any = this.newbrandForm.get(element.formControl);
          Public2.setValidators([]);
          Public2.updateValueAndValidity();
        }
      }
    });
    this.isDisable1 = true;
    // enable select dropdown
    this.newbrandForm.get("einIssuingCountry").enable();
    this.newbrandForm.get("altBusinessIdType").enable();
    this.newbrandForm.get("state").enable();
    this.newbrandForm.get("stockExchange").enable();

    this.brand.forEach(element => {
      if (element.ID == "taxId" || element.ID == "address" || element.ID == "city" || element.ID == "post" || element.ID == "website" || element.ID == "refer" || element.ID == "firstname" || element.ID == "lastname" || element.ID == "stock" || element.ID == "dunsnumber" || element.ID == "companyName") {
        if (element.ID == "taxId" || element.ID == "address" || element.ID == "city" || element.ID == "post" || element.ID == "website" || element.ID == "refer" || element.ID == "stock" || element.ID == "companyName") {
          // enable text field code
          this.newbrandForm.get(element.formControl).enable();
        }
        else {
          // disable text field code
          this.newbrandForm.get(element.formControl).disable();
          this.newbrandForm.get(element.formControl).setValue('');
        }
      }
    })
  }
  checkvalidation(){
    if(this.isDisable1 == true && this.chosenOPT !== ''){
      this.submitted=true;
    }
    else{
      this.submitted=false;
    }
    return false;
  }
  OnSelectOrg() {
    if(this.chosenOrg!==''){
      // this.isDisable1 = true;
      this.orgCountryPincode();
    }

    if (this.chosenOrg == 'SOLE_PROPRIETOR') {
      // this.hidden2 = false;
      // this.hidden1 = true;
      this.newbrandForm.get("companyName").disable();
      this.newbrandForm.patchValue({
        companyName:''
      });
      let phone: any = this.contactdetailsForm.get('phone');
      phone.setValidators([]);
      phone.updateValueAndValidity();

      let Duns: any = this.newbrandForm.get('altBusinessId');
      Duns.setValidators([]);
      Duns.updateValueAndValidity();
    }
    else {
      // this.hidden2 = true;
      // this.hidden1 = false;
      this.mobilelabel="Mobile Phone"
      this.newbrandForm.get("companyName").enable();
      this.newbrandForm.patchValue({
        mobilePhone:''
      });
      this.newbrandForm.get("mobilePhone").disable();
      let phone2: any = this.contactdetailsForm.get('phone');
      phone2.setValidators([Validators.required, Validators.minLength(10), Validators.maxLength(11)]);
      phone2.updateValueAndValidity();

      let mobile2: any = this.newbrandForm.get('mobilePhone');
      mobile2.setValidators([]);
      mobile2.updateValueAndValidity();
    }

    this.brand.forEach(element => {
      if (this.chosenOrg == 'PRIVATE_PROFIT') {
        this.getCountry();
        // enable field code
        if (this.chosenOPT != '') {
          this.privateCompany();
        }
        if(element.ID === "companyName" || element.ID == "displayName" || element.ID == "entityType" || element.ID == "countryreg" || element.ID == "taxId" || element.ID == "address" || element.ID == "city" || element.ID == "selectedState" ||element.ID == "post" ||element.ID == "vertical"){
          if(element.label.indexOf("*") == -1){
            element.label = element.label +' *';
          }
        }
        else{
          if(element.label.indexOf("*") != -1){
            element.label = element.label.slice(0, -1)
          }
        }
      }
     else if (this.chosenOrg == 'NON_PROFIT') {
        this.getCountry();
        // enable field code
        if (this.chosenOPT != '') {
          this.NonProfit();
        }
        if(element.ID === "companyName" || element.ID == "displayName" || element.ID == "entityType" || element.ID == "countryreg" || element.ID == "taxId" || element.ID == "address" || element.ID == "city" || element.ID == "selectedState" ||element.ID == "post" ||element.ID == "vertical"){
          if(element.label.indexOf("*") == -1){
            element.label = element.label +' *';
          }
        }
        else{
          if(element.label.indexOf("*") != -1){
            element.label = element.label.slice(0, -1)
          }
        }
      }
      else if (this.chosenOrg == 'PUBLIC_PROFIT') {
        if(element.ID === "companyName" || element.ID == "displayName" || element.ID == "entityType" || element.ID == "countryreg" || element.ID == "taxId" || element.ID == "address" || element.ID == "city" || element.ID == "selectedState" || element.ID == "post" || element.ID == "vertical" || element.ID == "stock" || element.ID == "stockex"){
          if(element.label.indexOf("*") == -1){
            element.label = element.label +' *';
          }
        }
        else{
          if(element.label.indexOf("*") != -1){
            element.label = element.label.slice(0, -1)
          }
        }
        this.getCountry();
        // enable field
        if (this.chosenOPT != '') {
          this.PubliclyTradedCompany();
        }
      }
      else if (this.chosenOrg == 'SOLE_PROPRIETOR') {

        if (element.ID == "taxId") {
          element.label = "Tax Number/ID/EIN";
        }
        if(element.ID == "tax"){
          element.label = "Tax Number/ID/EIN Issuing Country";
        }

        this.mobilelabel="Mobile Phone *"
        this.getCountry();
        // enable field code
        if (this.chosenOPT != '') {
          this.SoleProprietor();
        }
        if(element.ID === "refer" || element.ID == "firstname" || element.ID == "lastname" || element.ID == "displayName" || element.ID == "entityType" || element.ID == "countryreg" || element.ID == "city" || element.ID == "selectedState" || element.ID == "post" || element.ID == "address"){
          if(element.label.indexOf("*") == -1){
            element.label = element.label +' *';
          }
        }
        else{
          if(element.label.indexOf("*") != -1){
            element.label = element.label.slice(0, -1)
          }
        }
      }

      else if (this.chosenOrg == 'GOVERNMENT') {
        this.newbrandForm.patchValue({
          country: 'US'
        })

        this.data.US_State().subscribe(res => {
          this.States = res[0].US_State;
        });
        if(element.ID == "companyName" || element.ID == "displayName" ||element.ID == "displayName" || element.ID == "countryreg" || element.ID == "taxId" || element.ID == "address" || element.ID == "city" || element.ID == "selectedState" || element.ID == "post" || element.ID == "vertical"){
          if(element.label.indexOf("*") == -1){
            element.label = element.label +' *';
          }
        }
        else{
          if(element.label.indexOf("*") != -1){
            element.label = element.label.slice(0, -1)
          }
        }
        if (this.chosenOPT != '') {
          this.Government();
        }
      }
    });
  }

  onSubmit() {
    if (this.newbrandForm.invalid || this.contactdetailsForm.invalid) {
      this.submitted = true;
    }
    else {
      // if (this.newbrandForm.value.phone! == '' || undefined) {
      //   this.newbrandForm.patchValue({
      //     phone: this.newbrandForm.value.mobilePhone
      //   })
      // }
      // let Vertical = this.newbrandForm.value.vertical;
      let payLoad = {
        companyName: this.newbrandForm.value.companyName,
        displayName: this.newbrandForm.value.displayName,
        mock: this.newbrandForm.value.mock,
        ein: this.newbrandForm.value.ein,
        einIssuingCountry: this.newbrandForm.value.einIssuingCountry,
        altBusinessIdType: this.newbrandForm.value.altBusinessIdType,
        altBusinessId: this.newbrandForm.value.altBusinessId,
        street: this.newbrandForm.value.street,
        city: this.newbrandForm.value.city,
        state: this.newbrandForm.value.state,
        postalCode: this.newbrandForm.value.postalCode,
        country: this.newbrandForm.value.country,
        website: this.newbrandForm.value.website,
        stockSymbol: this.newbrandForm.value.stockSymbol,
        stockExchange: this.newbrandForm.value.stockExchange,
        vertical: this.newbrandForm.value.vertical,
        referenceId: this.newbrandForm.value.referenceId,
        entityType: this.newbrandForm.value.entityType,
        firstName: this.newbrandForm.value.firstName,
        lastName: this.newbrandForm.value.lastName,
        brandRelationship: this.newbrandForm.value.brandRelationship,
        email: this.contactdetailsForm.value.email,
        phone: this.contactdetailsForm.value.phone,
        mobilePhone: this.newbrandForm.value.mobilePhone
      }
    
      this.data.onBrandRegister(payLoad).subscribe((res) => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
            this.router.navigate(['/new-campaign/brand']);
            setTimeout(() => {
              window.location.reload();
            }, 1000);
          }, 4000);
          
          this.submitted = false;
          this.contactdetailsForm.reset();
          // this.newbrandForm.reset();
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
    }
  }

  addClick(ID: any) {
    this.isDisable2 = true;
    this.selectRelation=false;
    if (ID) {
      this.newbrandForm.get('brandRelationship').setValue(ID);
      if (this.getOldID != "") {
        $('#' + this.getOldID).css('border', '');
      }
      $('#' + ID).css('border', '2px solid #1269db');
      this.getOldID = ID;
    }
  }

  errorMessage(){
    this.selectRelation=true;
  }

  website(e: any) {
    if (e.which === 32) {
      e.preventDefault();
    }
  }

  taxeinID(evt: any){
    if(this.USA == true){
      var charCode = (evt.which) ? evt.which : evt.keyCode;
      if (charCode = 45  && charCode > 31 && (charCode < 48 || charCode > 57))
      return false;
  
      return true;
    }
    if(this.Canada == true){
      var charCode = (evt.which) ? evt.which : evt.keyCode;
      if (charCode = 45  && charCode > 31 && (charCode < 48 || charCode > 57) && (charCode < 65 || charCode > 90))
      return false;
  
      return true;
    }
  }

  PostalCode(event: any): boolean {
    this.zipLength='';
    if (this.Canada == true) {
      this.zipLength = 10;
      let Post: any = this.newbrandForm.get("postalCode");
      Post.setValidators([Validators.required, Validators.minLength(1), Validators.maxLength(this.zipLength)]);
      Post.updateValueAndValidity();
    }

    //   var regex = new RegExp("^[0-9a-zA-Z \b]+$");
    //   var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
    //   if (!regex.test(key)) {
    //     event.preventDefault();
    //     return false;
    //   }
    // }
    // else {
      if(this.USA == true){
        this.zipLength = 5;
        let Post: any = this.newbrandForm.get("postalCode");
        Post.setValidators([Validators.required, Validators.minLength(this.zipLength), Validators.maxLength(this.zipLength)]);
        Post.updateValueAndValidity();
  
        const charCode = (event.which) ? event.which : event.keyCode;
        if (charCode > 31 && (charCode < 48 || charCode > 57)) {
          return false;
        }
        return true;
      }
    // }
  }

  orgCountryPincode(){
    let postalv=this.newbrandForm.value.postalCode;
    if(postalv){
      if(this.Canada == true){
        if(postalv.length !== 10){
          this.zipLength = 10;
          setTimeout(() => {
            let Post: any = this.newbrandForm.get("postalCode");
            Post.setValidators([Validators.minLength(0), Validators.maxLength(this.zipLength)]);
            Post.updateValueAndValidity();
          }, 1000);
        }
      }
      else if(this.USA == true){
        if(postalv.length !== 5){
          this.zipLength = 5;
          setTimeout(() => {
            let Post: any = this.newbrandForm.get("postalCode");
            Post.setValidators([Validators.minLength(this.zipLength), Validators.maxLength(this.zipLength)]);
            Post.updateValueAndValidity();
          }, 1000);
        }
      }
    }
  }

  Company() {
    let company = this.newbrandForm.get('companyName').value;
    this.newbrandForm.patchValue({
      displayName: company
    })
  }
  showMsg()
	{
		this.errMessage = this.serviceMessage;
		setTimeout(() => {
			this.errMessage = "";
		}, 5000);
	}

}
