import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, FormControl, Validators } from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { NewCamapignService } from '../new-camapign.service';
import * as XLSX from 'xlsx';
import { saveAs } from 'file-saver';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
declare var $: any;

@Component({
	selector: 'app-campaign-new',
	templateUrl: './campaign-new.component.html',
	styleUrls: ['./campaign-new.component.css']
})
export class CampaignNewComponent extends AppComponentClass<any, any> {
	public show: boolean = false;
	brandId: any = null;
	/* searchText = { count: 0 };
	filtre: string; */
	campaigns: any = [];
	campaignsfilter: any = [];
	responseMessage = "";
	collection: any;
	heading: any;
	main_heading: any;
	isCampaign: boolean = false;
	errMessage: any = "";
	campaign_key: any;
	// referenceId: any;
	exportButton: any;
	iduser: any;
	idaccount: any;
	campDid: any = [];
	useCase: any = [];
	public filterCampaign: FormGroup;
	EXCEL_TYPE = 'application/csv';
	EXCEL_EXTENSION = '.csv';
	userType: any;
	messs: string = '';
	pending_review: any = [];
	shared_campaign: any = [];
	failed_campaign: any = [];
	completed_campaign: any = [];
	headingComplete: any;
	tabNm: any = "All";
	heading1: any;
	san: any;
	users: any = [];
	all_campaign: any = [];
	userlist: any = [];
	campaignsfilterCSV: any = [];
	customer_action_req: any = [];
	rejectForm: FormGroup
	failedForm: FormGroup
	campData: any = {};
	submitted: boolean =false;

	constructor(public data: NewCamapignService, public userService: UsermanagementService,
		public router: Router, public fb: FormBuilder,
		private route: ActivatedRoute) {
		super(data, router, fb);
	}

	ngOnInit(): void {
		let session$ = sessionStorage.getItem("isLoggedIn");
		let session = JSON.parse(session$);
		this.userType = session.type;
		this.iduser = session.iduser;
		this.idaccount = session.idaccount;

		this.exportButton = 'Download Campaign';
		this.data.getcampaign().subscribe((result) => {
			this.collection = result[1]
			$.getScript('./assets/table.js');
			this.heading = result[0].headers
			this.heading1 = result[0].headers1
			this.headingComplete = result[0].headersComplete
			this.main_heading = result[0].users
		});

		this.filterCampaign = this.fb.group({
			brandId: [],
			brand_name: [],
			referenceId: [],
			usecase: [],
			campaign_key: [],
			tcrStatus: [],
			filter_type: [],
			provisioning_status: [],
			idaccount: [],
		});
		this.filterCampaign.patchValue({
			filter_type: this.userType == 1 ? "All" : ''
		})
		this.route.paramMap.subscribe((params: ParamMap) => {
			this.brandId = params.get('id');
			if (this.brandId) {
				$('#basic-datatables14').DataTable().clear();
				$('#basic-datatables14').DataTable().destroy();
				this.data.onGetNewCampaigns(this.brandId).subscribe(result => {
					if (result.status == 200) {
						if (result.data.length > 0) {
							this.campaigns = result.data;
							$.getScript('./assets/table.js');
							this.isCampaign = true;
						}
					}
					else {
						this.errMessage = result.message;
						setTimeout(() => {
							this.errMessage = "";
						}, 5000);
					}
				});
			}
		});

		/**See Usecases Records */
		this.data.getuseCases().subscribe(res => {
			this.useCase = res.data;
		});

		this.userService.getUsers("main").subscribe(res => {
			this.userlist = res.data[0];
			this.userlist.sort((a, b) => {
				return a.san - b.san;
			  });	
		});

		this.campaignsList();

		this.rejectForm = this.fb.group({
			desc_details:  ['', Validators.required],
		})
		this.failedForm = this.fb.group({
			desc_details: ['', Validators.required],
			mailCheck:[]
		})
		
	}

	getCampRegDID(camp: any, userid: any) {
		this.campaign_key = camp
		this.campDid = [];
		this.data.getCampaignDID(camp, userid).subscribe((res) => {
			if (res.status == 200) {
				this.campDid = res.data;
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			} else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}

	campaignID(event: Event) {
		this.campaign_key = (event.target as HTMLInputElement).value.toUpperCase();
	}

	brandID(event: Event) {
		this.brandId = (event.target as HTMLInputElement).value.toUpperCase();
	}

	showfilter() {
		if (this.show == false) {
			this.show = true;
		}
		else {
			this.show = false;
		}

	}

	resetFilter() {
		this.messs = '';
		this.tabNm = this.tabNm;
		this.campaignsList();
		// this.ngOnInit();
	}
	tabName(e) {
		this.tabNm = e;
		this.filterCampaign.reset();
		this.filterCampaign.patchValue({
			filter_type: this.userType == 1 ? e : ''
		})
	}


	campaignsList() {
		let payLoad = JSON.stringify({
			idaccount: this.idaccount,
			iduser: this.iduser
		})
		$('#basic-datatables14').DataTable().clear();
		$('#basic-datatables14').DataTable().destroy();
		$('#basic-datatables14a').DataTable().clear();
		$('#basic-datatables14a').DataTable().destroy();
		$('#basic-datatables14aa').DataTable().clear();
		$('#basic-datatables14aa').DataTable().destroy();
		$('#basic-datatables01').DataTable().clear();
		$('#basic-datatables01').DataTable().destroy();
		$('#basic-datatables02').DataTable().clear();
		$('#basic-datatables02').DataTable().destroy();
		$('#basic-datatables03').DataTable().clear();
		$('#basic-datatables03').DataTable().destroy();
		$('#basic-datatables14b').DataTable().clear();
		$('#basic-datatables14b').DataTable().destroy();

		this.data.GetCampaignsList(payLoad).subscribe(result => {
			if (result.status == 200) {
				var userID = this.data.iduser;
				this.campaigns = [];
				this.all_campaign = [];
				this.pending_review = [];
				this.shared_campaign = [];
				this.completed_campaign = [];
				this.failed_campaign = [];
				this.customer_action_req = [];
			
				if (result.data.length > 0) {
					this.campaigns = result.data;
					 if (this.userType == 1) {
						this.campaigns.forEach(element => {
							if (element.provisioning_status == 0) {
								element.provisioning_status = 'Pending Review'
								this.pending_review.push(element);
							}
							if (element.provisioning_status == 5) {
								element.provisioning_status = 'Customer Action Required'
								this.customer_action_req.push(element);
							}
							if (element.provisioning_status == 1 || element.provisioning_status == 2) {
								if(element.provisioning_status == 2){
								  element.provisioning_status = 'Provisioning pending'
								}
								else{
								  element.provisioning_status = 'Campaign Shared'
								}
								this.shared_campaign.push(element);
							  }
							if (element.provisioning_status == 3) {
								element.provisioning_status = 'Campaign Provisioned'
								this.completed_campaign.push(element);
							}
							if (element.provisioning_status == 4) {
								element.provisioning_status = 'Provisioning Failed'
								this.failed_campaign.push(element);
							}
						})
						this.all_campaign = result.data;
						this.setStatus(this.all_campaign);
					}
					else {
						this.campaigns = result.data;
						this.setStatus(this.campaigns);
					}
					this.messs = '';
					$.getScript('./assets/table.js');
					this.isCampaign = true;
				}
			}
			else {
				this.errMessage = result.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}
	setStatus(list) {
		list.forEach(element => {
			if (element.provisioning_status == 0) {
				element.provisioning_status = 'Pending Review'
			}
			if (element.provisioning_status == 1) {
				element.provisioning_status = 'Campaign Shared'
			}
			if (element.provisioning_status == 2) {
				element.provisioning_status = 'Provisioning Pending'
			}
			if (element.provisioning_status == 3) {
				element.provisioning_status = 'Campaign Provisioned'
			}
			if (element.provisioning_status == 4) {
				element.provisioning_status = 'Provisioning Failed'
			}
			if (element.provisioning_status == 5) {
				element.provisioning_status = 'Customer Action Required'
			}
		})
	}
	applyCamFilter() {
		/* if(this.filterCampaign.value.campaign_key || this.filterCampaign.value.usecase || 
			this.filterCampaign.value.brandId || this.filterCampaign.value.brand_name || this.filterCampaign.value.tcrStatus )
			  { */
		// this.campaigns = [];
		// this.pending_review = [];
		// this.shared_campaign = [];
		// this.completed_campaign = [];
		// this.failed_campaign = [];
		// this.all_campaign =[];
		this.data.applyCampaignFilter(this.filterCampaign.value).subscribe(res => {
			if (res.status == 200) {
				this.messs = '';
				this.campaignsfilter = res.data;
				this.campaignsfilterCSV = res.data;


				if (this.userType == 1) {
					if (this.tabNm == "Pending Review") {
						$('#basic-datatables14a').DataTable().clear();
						$('#basic-datatables14a').DataTable().destroy();
						this.pending_review = this.campaignsfilter;
						this.setStatus(this.pending_review);
					}
					if (this.tabNm == "Customer Action Required") {
						$('#basic-datatables14aa').DataTable().clear();
						$('#basic-datatables14aa').DataTable().destroy();
						this.customer_action_req = this.campaignsfilter;
						this.setStatus(this.customer_action_req);
					}
					if (this.tabNm == "Shared") {
						$('#basic-datatables01').DataTable().clear();
						$('#basic-datatables01').DataTable().destroy();
						this.shared_campaign = this.campaignsfilter;
						this.setStatus(this.shared_campaign);
					}
					if (this.tabNm == "Failed") {
						$('#basic-datatables02').DataTable().clear();
						$('#basic-datatables02').DataTable().destroy();
						this.failed_campaign = this.campaignsfilter;
						this.setStatus(this.failed_campaign);
					}
					if (this.tabNm == "Completed") {
						$('#basic-datatables03').DataTable().clear();
						$('#basic-datatables03').DataTable().destroy();
						this.completed_campaign = this.campaignsfilter;
						this.setStatus(this.completed_campaign);
					}
					if (this.tabNm == "All") {
						$('#basic-datatables14b').DataTable().clear();
						$('#basic-datatables14b').DataTable().destroy();
						this.all_campaign = this.campaignsfilter;
						this.setStatus(this.all_campaign);
					}
				}
				else {
					$('#basic-datatables14').DataTable().clear();
					$('#basic-datatables14').DataTable().destroy();
					this.campaigns = this.campaignsfilter;
					this.setStatus(this.campaigns);
				}

				$.getScript('./assets/table.js');
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		})
		/* }
	else
	{
		this.messs="Please Enter atleast 1 field!";
	} */
	}
	dcaSubmit(campaign_key, iduser, idaccount) {
		let payload = JSON.stringify({
			campId: campaign_key,
			iduser: iduser,
			idaccount: idaccount,
		});
		this.data.dcaSubmit(payload).subscribe((res) => {
			if (res.status == 200) {

				this.responseMessage = res.message;
				setTimeout(() => {
					this.campaignsList();
					this.responseMessage = "";
				}, 5000);
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		})
	}

	downloadCSVFile() {
		this.applyCamFilter();
		setTimeout(() => {
			if (this.campaignsfilterCSV.length > 0) {
				let NewFilteredRes = this.campaignsfilterCSV.map(item => {
					const { iduser, idaccount, deleted, ...rest } = item; // Remove iduser and idaccount properties
					return rest;
				});
				const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(NewFilteredRes);
				const workbook: XLSX.WorkBook = { Sheets: { 'Campaign': worksheet }, SheetNames: ['Campaign'] };
				const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
				this.saveAsExcelFile(excelBuffer, "Campaign");
				// this.ngOnInit();
			}
			else {
				this.errMessage = "No Record Available!";
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, 5000);
	}

	getCampaignDetails(campaign_key, iduser, idaccount) {
		this.rejectForm.reset();
		this.campData = {
			campId: campaign_key,
			iduser: iduser,
			idaccount: idaccount,
		};
	}

	campaignFailed(campaign_key, iduser, idaccount)
	{
		this.failedForm.reset();
		this.campData = {
			campId: campaign_key,
			iduser: iduser,
			idaccount: idaccount,
		};
	}
	formSubmit() {
		if (this.rejectForm.invalid) {
			this.submitted = true;
		}
		else {
			this.campData.desc_details=this.rejectForm.value.desc_details;
			this.data.rejectFormByAdmin(this.campData).subscribe(res => {
				  if (res.status == 201) {
				this.responseMessage = res.message;
				setTimeout(() => {
				  this.responseMessage = "";
				  document.getElementById("requestToEdit").click();
                  window.location.reload();
				}, 5000);
			  }
			  else {
				this.errMessage = res.message;
				setTimeout(() => {
				  this.errMessage = "";
				}, 5000);
			  }
			});
		}
	}
	saveForm(){
		if (this.failedForm.invalid) {
			this.submitted = true;
		}
		else {
			this.campData.desc_details=this.failedForm.value.desc_details;
			this.campData.mailCheck=this.failedForm.value.mailCheck;
			this.data.failedFormByAdmin(this.campData).subscribe(res => {
				  if (res.status == 201) {
				this.responseMessage = res.message;
				setTimeout(() => {
				  this.responseMessage = "";
				  document.getElementById("requestToEditForFailed").click();
                  window.location.reload();
				}, 5000);
			  }
			  else {
				this.errMessage = res.message;
				setTimeout(() => {
				  this.errMessage = "";
				}, 5000);
			  }
			});
		}
	}
	resetRequest(){
		this.rejectForm.reset();
		this.submitted = false;
	  }
	  resetFailed(){
		this.failedForm.reset();
		this.submitted = false;
	  }
	private saveAsExcelFile(buffer: any, fileName: string): void {
		const data: Blob = new Blob([buffer], {
			type: this.EXCEL_TYPE
		});
		saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
	}

}
