import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, FormControl, Validators } from '@angular/forms';
// import {CapmaignserviceService } from '../capmaignservice.service';
import { Router } from '@angular/router';
import { MatDialog } from '@angular/material/dialog';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { CapmaignserviceService } from 'src/app/campaign/capmaignservice.service';
import { Alert } from 'selenium-webdriver';
import { NewCamapignService } from '../new-camapign.service';

declare var $: any;
@Component({
  selector: 'app-cnp-brand',
  templateUrl: './cnp-brand.component.html',
  styleUrls: ['./cnp-brand.component.css']
})
export class CnpBrandComponent extends AppComponentClass<any, any> {
  inputvalue = "";
	campaign_id: 0;
	public show: boolean = false;
	public buttonName: any = "Add Brand";
	public filterBrand: FormGroup;
	public submitted: boolean = false;
	public collection: any;
	public heading = [];
	public main_heading = "";
	responseMessage = "";
	brands: any = [];
	brand: any = [];
	campaigns: any = [];
	brandType: any = [];
	errMessage: any = "";
	userType: any;  
	cnpLIST: any =[];
	messs: string ='';

  

  constructor(public data: CapmaignserviceService,
		public service: NewCamapignService,
		public dialog: MatDialog,
		public router: Router,
		public fb: FormBuilder) {
		super(data, router, fb);
	}

  ngOnInit(): void {
		let session$ = sessionStorage.getItem("isLoggedIn");
		let session = JSON.parse(session$);
		this.userType = session.type;

		this.filterBrand = this.fb.group({
			brandId: [],
			displayName: [''],
			company_name: [''],
			website: [],
		});
        this.getBrandCnpList()
	}


  getBrandCnpList()
  {
    this.service.getBrandCnpList().subscribe(res => {
     if (res.status == 200) {
				this.cnpLIST = res.data;        
				$('#basic-datatables').DataTable().clear();
				$('#basic-datatables').DataTable().destroy();
				$.getScript('./assets/table.js');
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}

    },err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
  }

  resetFilter() {
	this.messs='';
	this.getBrandCnpList();
}

	/**
	 * It will delete a brand
	 */
	showfilter() {
		if (this.show == false) {
			this.show = true;
		}
		else {
			this.show = false;
		}

	}


	applyCnpFilter() {
		if(this.filterBrand.value.brandId || this.filterBrand.value.displayName || 
			this.filterBrand.value.company_name || this.filterBrand.value.website )
			  {
					this.service.applyCnpFilter(this.filterBrand.value).subscribe(res => {
					if (res.status == 200) {
							this.cnpLIST = res.data;
							this.messs='';
							$('#basic-datatables').DataTable().clear();
							$('#basic-datatables').DataTable().destroy();
							$.getScript('./assets/table.js');
						}
						else {
							this.errMessage = res.message;
							setTimeout(() => {
								this.errMessage = "";
							}, 5000);
						}
					})
		       } 
		  else
		 {
		this.messs="Please Enter atleast 1 field!";
		 }
	}


}
