import { Component, OnInit } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { NewCamapignService } from '../new-camapign.service';
import * as XLSX from 'xlsx';
import { saveAs } from 'file-saver';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
declare var $: any;

@Component({
  selector: 'app-cnp-campaign-new',
  templateUrl: './cnp-campaign-new.component.html',
  styleUrls: ['./cnp-campaign-new.component.css']
})
export class CnpCampaignNewComponent extends AppComponentClass<any, any> {
  /* brandId: any=null; */
  /* searchText = { count: 0 };
  filtre: string; */
  campaigns: any;
  all_campaign: any =[];
  /* p: number = 1;
  page = 1;
  count = 0;
  tableSize = 25;
  tableSizes = [ 25, 50, 100]; */
  /* filterTerm: string;
  filterTerm1: string; */
  responseMessage = "";
  collection: any;
  heading: any;
  main_heading: any;
  isCampaign: boolean = false;
  errMessage: any = "";
  campaign_key: any;
  iduser: any;
  campDid: any = [];
  EXCEL_TYPE = 'application/csv';
  EXCEL_EXTENSION = '.csv';
  public show: boolean = false;
  CNPcampaignsfilter: any = [];
  public filterCampaign: FormGroup;
  exportButton: any;
  useCase: any = [];
  messs: string = '';
  submitted: boolean = false;
  pending_review: any = [];
  shared_campaign: any = [];
  failed_campaign: any = [];
  completed_campaign: any = [];
  userType: any;
  idaccount: any;
  headingComplete: any;
  tabNm: any = "All";
  heading1: any;
  userlist: any = [];
  CNPcampaignsfilterCSV: any =[];
  customer_action_campaign: any[];
  requestEdit:FormGroup;
	failedForm: FormGroup
	campData: any = {};
  headingCNP: any;
  headingCNP2a: any;

  constructor(public data: NewCamapignService, public userService: UsermanagementService,
    public router: Router, public fb: FormBuilder, private route: ActivatedRoute) {
    super(data, router, fb);
  }

  ngOnInit(): void {
    let session$ = sessionStorage.getItem("isLoggedIn");
		let session = JSON.parse(session$);
		this.userType = session.type; 
		this.iduser = session.iduser; 
		this.idaccount = session.idaccount;  

    this.exportButton = 'Download Filter Campaign';
    this.data.getcampaign().subscribe((result) => {
      this.collection = result[1]
      $.getScript('./assets/table.js');
      this.heading = result[0].headerCNP
      this.heading1 = result[0].headerCNP1
      this.headingComplete = result[0].headerCNPComplete
      this.headingCNP = result[0].headerCNP2
      this.headingCNP2a = result[0].headerCNP2a
      this.main_heading = result[0].users
    });


    this.filterCampaign = this.fb.group({
      brandId: [''],
      brand_name: [''],
      referenceId: [''],
      usecase: [''],
      campaign_key: [''],
      filter_type: [''],
      provisioning_status: [''],
      idaccount: [''],
    });

    this.requestEdit = this.fb.group({
      campaign_key: [''],
      iduser: [''],
      idaccount: [''],
      description: ['', Validators.required]
    });

    this.failedForm = this.fb.group({
			desc_details: ['', Validators.required],
			mailCheck:[]
		})

    this.filterCampaign.patchValue({
      filter_type: this.userType==1 ? "All" : ''
    })
    this.data.getuseCases().subscribe(res => {
      this.useCase = res.data;
    });
    this.userService.getUsers("main").subscribe(res => {
			this.userlist=res.data[0];
		  this.userlist.sort((a, b) => {
			  return a.san - b.san;
			});	
		});

    this.CNPcampaignlist();

  }

  setStatus(list){
		list.forEach(element => { 
			if (element.provisioning_status == 0) {
				element.provisioning_status ='Pending Review'
			}
			if (element.provisioning_status == 1) {
				element.provisioning_status ='Campaign Shared'
			}							
			if (element.provisioning_status == 2) {
				element.provisioning_status ='Provisioning Pending'
			}							
			if (element.provisioning_status == 3) {
				element.provisioning_status ='Campaign Provisioned'
			}
			if (element.provisioning_status == 4) {
				element.provisioning_status ='Provisioning Failed'
			}
      if (element.provisioning_status == 5) {
				element.provisioning_status ='Customer Action Required'
			}
		})
	}

  CNPcampaignlist() {
    let payLoad:any = JSON.stringify({
			idaccount: this.idaccount,
			iduser: this.iduser
		})
    $('#basic-datatablesRs').DataTable().clear();
    $('#basic-datatablesRs').DataTable().destroy();

    $('#basic-datatables13a').DataTable().clear();
    $('#basic-datatables13a').DataTable().destroy();

    $('#basic-datatables13b').DataTable().clear();
    $('#basic-datatables13b').DataTable().destroy();

    $('#basic-datatables13c').DataTable().clear();
    $('#basic-datatables13c').DataTable().destroy();

    $('#basic-datatables13d').DataTable().clear();
    $('#basic-datatables13d').DataTable().destroy();

    $('#basic-datatables13e').DataTable().clear();
    $('#basic-datatables13e').DataTable().destroy();

    $('#basic-datatables14').DataTable().clear();
    $('#basic-datatables14').DataTable().destroy();
    // $.getScript('./assets/table.js');
    this.data.GetCNPCampaignsList(payLoad).subscribe(result => {
      if (result.status == 200) {
        var userID = this.data.iduser;
        this.campaigns = [];
        this.all_campaign = [];
        this.pending_review = [];
        this.shared_campaign = [];
        this.completed_campaign = [];
        this.failed_campaign = [];
        this.customer_action_campaign = [];
        if (result.data.length > 0) {
          this.campaigns = result.data;
          if (this.userType == 1) {
            this.campaigns.forEach(element => {
              if (element.provisioning_status == 0) {
                element.provisioning_status = 'Pending Review'
                this.pending_review.push(element);
              }
              if (element.provisioning_status == 1 || element.provisioning_status == 2) {
                if(element.provisioning_status == 2){
                  element.provisioning_status = 'Provisioning pending'
                }
                else{
                  element.provisioning_status = 'Campaign Shared'
                }
                this.shared_campaign.push(element);
              }
              if (element.provisioning_status == 3) {
                element.provisioning_status = 'Campaign Provisioned'
                this.completed_campaign.push(element);
              }
              if (element.provisioning_status == 4) {
                element.provisioning_status = 'Provisioning Failed'
                this.failed_campaign.push(element);
              }
              if (element.provisioning_status == 5) {
                element.provisioning_status = 'Customer Action Required'
                this.customer_action_campaign.push(element);
              }
            })
            this.all_campaign = result.data;
            this.setStatus(this.all_campaign);
            
          }
          else {
            this.campaigns = result.data;
            this.setStatus(this.campaigns);
          }
          this.messs = '';
          $.getScript('./assets/table.js');
          this.isCampaign = true;
        }
      }
      else {
        this.errMessage = result.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  dcaSubmit(campaign_key,iduser,idaccount){
		let payload = JSON.stringify({
			campId: campaign_key,
			iduser: iduser,
			idaccount: idaccount,
		});
		this.data.dcaSubmit(payload).subscribe((res) => {
			if (res.status == 200) {
				this.responseMessage = res.message;
				setTimeout(() => {
          this.CNPcampaignlist();
					this.responseMessage = "";
				}, 5000);
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
          this.errMessage = ""
				}, 5000);
			}			
		})
	}

  customerAction(campaign_key,iduser,idaccount){
    this.requestEdit.reset();
    this.requestEdit.patchValue({
      iduser:iduser,
      idaccount:idaccount,
      campaign_key:campaign_key
    });
  }

  resetRequest(){
    this.requestEdit.reset();
    this.submitted = false;
  }

  submitRequestEdit(){
    if(this.requestEdit.invalid){
      this.submitted = true;
    }
    else{
      this.data.RequestEdit(this.requestEdit.value).subscribe((res) => {
        if (res.status == 200) {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
            document.getElementById("customerActionModal").click();
            window.location.reload();
           // this.CNPcampaignlist();
          }, 5000);
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = ""
          }, 5000);
        }			
      })
    }
  }

  campaignFailed(campaign_key, iduser, idaccount)
	{
		this.failedForm.reset();
		this.campData = {
			campId: campaign_key,
			iduser: iduser,
			idaccount: idaccount,
		};
	}

  saveForm(){
		if (this.failedForm.invalid) {
			this.submitted = true;
		}
		else {
			this.campData.desc_details=this.failedForm.value.desc_details;
			this.campData.mailCheck=this.failedForm.value.mailCheck;
			this.data.failedCnpFormByAdmin(this.campData).subscribe(res => {
				  if (res.status == 201) {
				this.responseMessage = res.message;
				setTimeout(() => {
				  this.responseMessage = "";
				  document.getElementById("requestToEditForFailed").click();
          window.location.reload();
				}, 5000);
			  }
			  else {
				this.errMessage = res.message;
				setTimeout(() => {
				  this.errMessage = "";
				}, 5000);
			  }
			});
		}
	}

  resetFailed(){
		this.failedForm.reset();
		this.submitted = false;
	  }

  getUser(camp: any, userid: any) {
    this.campaign_key = camp
    const campaign_key = camp;
    const userID = userid;
    this.campDid = [];
    this.data.getCampaignDID(this.campaign_key, userID).subscribe((res) => {
      if (res.status == 200) {
        this.campDid = res.data;
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  /*  onDeleteCampaign(campaign_key){
     if(confirm("Are You Sure ?")){
     this.data.onDeleteCampaign(campaign_key).subscribe(res => {
       if(res.status == 201){
         this.ngOnInit();
         this.responseMessage = res.message;
         setTimeout(()=>{
           this.responseMessage= "";
         }, 5000);
       }
       else{
         this.errMessage = res.message;
         setTimeout(() => {
           this.errMessage = "";
         }, 5000);
       }
       }, err  => {
         this.errMessage = err.message;
         setTimeout(()=>{
         this.errMessage= "";
         }, 5000);
       });
     }
     else{
     return
     }
   } */

  showfilter() {
    if (this.show == false) {
      this.show = true;
    }
    else {
      this.show = false;
    }
  }

  resetFilter() {
    this.CNPcampaignlist();
    //this.ngOnInit();
    this.messs = '';
    this.tabNm = this.tabNm;
  }
  tabName(e){
    this.tabNm = e;    
    this.filterCampaign.reset();
    this.filterCampaign.patchValue({
      filter_type: this.userType==1 ? e : ''
    })
  }
  onKeyPress(event: any) {
    this.messs = '';
  }

  changeUsecase(event: any) {
    this.messs = '';
  }

  applyCamFilter() {
    /* if (this.filterCampaign.value.campaign_key || this.filterCampaign.value.usecase ||
      this.filterCampaign.value.brandId || this.filterCampaign.value.brand_name) { */
      this.messs = '';
      // this.pending_review = [];
      // this.shared_campaign = [];
      // this.completed_campaign = [];
      // this.failed_campaign = [];      
      this.data.applyCNPCampaignFilter(this.filterCampaign.value).subscribe(res => {
        if (res.status == 200) {
          this.CNPcampaignsfilter = res.data;
          this.CNPcampaignsfilterCSV = res.data;
          if(this.userType==1){
            if (this.tabNm == "Pending Review") {
              $('#basic-datatables13a').DataTable().clear();
              $('#basic-datatables13a').DataTable().destroy();
              this.pending_review = this.CNPcampaignsfilter;
              this.setStatus(this.pending_review);
            }
            if (this.tabNm == "Customer Action Request") {
              $('#basic-datatables14').DataTable().clear();
              $('#basic-datatables14').DataTable().destroy();
              this.customer_action_campaign = this.CNPcampaignsfilter;
              this.setStatus(this.customer_action_campaign);
            }
            if (this.tabNm == "Shared") {
              $('#basic-datatables13b').DataTable().clear();
              $('#basic-datatables13b').DataTable().destroy();
              this.shared_campaign =  this.CNPcampaignsfilter;
              this.setStatus(this.shared_campaign);
            }
            if (this.tabNm == "Failed") {
              $('#basic-datatables13c').DataTable().clear();
              $('#basic-datatables13c').DataTable().destroy();
              this.failed_campaign = this.CNPcampaignsfilter;
              this.setStatus(this.failed_campaign);
            }
            if (this.tabNm == "Completed") {
              $('#basic-datatables13d').DataTable().clear();
              $('#basic-datatables13d').DataTable().destroy();
              this.completed_campaign = this.CNPcampaignsfilter;
              this.setStatus(this.completed_campaign);
            }
            if (this.tabNm == "All") {
              $('#basic-datatables13e').DataTable().clear();
              $('#basic-datatables13e').DataTable().destroy();
              this.all_campaign = this.CNPcampaignsfilter;
              this.setStatus(this.all_campaign);
            }          
          }
          else{
            $('#basic-datatablesRs').DataTable().clear();
            $('#basic-datatablesRs').DataTable().destroy();
            this.campaigns = this.CNPcampaignsfilter;
            this.setStatus(this.campaigns);
          }          
          $.getScript('./assets/table.js');
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      })
    /* }
    else {
      this.messs = "Please Enter atleast 1 field!";
    } */
  }

  downloadCSVFile() {
    this.applyCamFilter();
    setTimeout(() => {
      if(this.CNPcampaignsfilterCSV.length > 0){
        let NewFilteredRes = this.CNPcampaignsfilterCSV.map(item => {
				  const { iduser, idaccount, ...rest } = item; // Remove iduser and idaccount properties
				  return rest;
        });
        const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(NewFilteredRes);
        const workbook: XLSX.WorkBook = { Sheets: { 'Campaign': worksheet }, SheetNames: ['Campaign'] };
        const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
        this.saveAsExcelFile(excelBuffer, "Campaign");
        // this.ngOnInit();
      }
      else{
        this.errMessage = "No Record Available!";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, 5000);
    
  }

  private saveAsExcelFile(buffer: any, fileName: string): void {
    const data: Blob = new Blob([buffer], {
      type: this.EXCEL_TYPE
    });
    saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
  }
}
