import { Component, OnInit, ViewEncapsulation } from '@angular/core';
import { FormBuilder, FormGroup, FormArray, Validators } from '@angular/forms';
import { ActivatedRoute, ParamMap } from '@angular/router';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { element } from 'protractor';
import { BehaviorSubject, Observable } from 'rxjs';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { NewCamapignService } from '../new-camapign.service';
declare var $: any;
@Component({
  selector: 'app-registernew-campaign',
  templateUrl: './registernew-campaign.component.html',
  styleUrls: ['./registernew-campaign.component.css'],
  encapsulation: ViewEncapsulation.None
})
export class RegisternewCampaignComponent implements OnInit {
  public brandData: any;
  public yes: boolean = false;
  openeye: boolean = false;
  outoption: boolean = false;
  opthelp: boolean = false;
  open_optout: boolean = false;
  open_opthelp: boolean = false;
  isVisible: any;
  isSelected: boolean = true;
  campaignCases: any = [];
  campaignMno: any = [];
  conntPartner: any = [];
  resellerDetls: any = [];
  brandList: any = [];
  brandRef: any;
  mnoRegcas: any = [];
  standardCampaign: any = [];
  specialCampaign: any = [];
  status: boolean = false;
  subUseCases: any = [];
  campaignForm: FormGroup;
  usecase: any = [];
  brand_key: any;
  selectedSubCases: any = [];
  selectedVertical: any;
  isDisable: boolean = false;
  responseMessage = "";
  campaign_name: string;
  brand: any;
  brandId: any;
  brandVertical: any = [];
  brandName: any;
  brandNameId: any;
  campData: any = [];
  isDisabled: boolean = false;
  minSubUsecases: any;
  errMessage: any = "";
  submitted: boolean = false;
  searchText: any;
  autoRenewal: boolean = false;
  camp: any;
  opt_out: any;
  opt_outhelp: any;
  iduser: any;
  mnoIds: any = [];
  dropdownSettings: IDropdownSettings = {};
  closeDropdownSelection = true;
  checked: boolean = false;
  disabled = false;
  selectedItems: any[];
  carrierListOrMnos: Boolean;
  dataMno: any;
  dataBid: string;
  useCase: any;
  entityType: any;
  displaySole: boolean = false;
  displayNpvt: boolean = false;
  displayG: boolean = false;
  displayPvt: boolean = false;
  displayPub: boolean = false;
  displayNon: boolean = false;
  brandListById: any;
  mnoButton: any = true;
  selectedBrand: boolean = true;
  mnoQualify: any = [];
  mnoQualifyChecked: boolean;
  M2MSubmitted: boolean = false;
  //public mediaForm: FormGroup;
  img: File;
  payLoad: { fileName: any; mimeType: any; };
  showImgName: any;
  getAllMultiMediaFile: any =[];
  multimediaErr: string;
  m2mEnableCase: boolean =false;
  InputBtn: boolean =true;
  removeData: any =[];
  uploadImage: any =[];
  identityStatus: any;
  NextDisable: boolean = false;
  ErrDisplay: boolean = false;
  featureServiceData: any;
  userType: any;
  idaccount: any;
  isDisabledServiceStatus: boolean;
  optInEye:boolean =true;
  optOutEye:boolean =true;
  optHelpEye:boolean =true;
  enabled:boolean = true;

  serviceMessage:any ='Campaign service has been suspended. More information please contact support';
  enableCase2fa: boolean = false;


  constructor(private campaignService: NewCamapignService, public newCapaignservice: NewCamapignService,public userService: UsermanagementService,
    public fb: FormBuilder, private route: ActivatedRoute) { }

  ngOnInit() {
    this.userService.getfeatureServiceStatus().subscribe(res => { 
      this.featureServiceData = res.data.find(x => x.fs_id == '7');
      if(this.featureServiceData!==undefined && this.featureServiceData.as_status==1)
      {
       this.isDisabledServiceStatus=false;
         
      }else{
       this.isDisabledServiceStatus=true;
       this.showMsg();

      }
      
		});
    this.carrierListOrMnos = false
    this.displaySole = true;
    this.campaignForm = this.fb.group({
      brandId: [],
      usecase: [],
      subUsecases: [],
      embeddedLink: ['', [Validators.required]],
      embeddedPhone: ['', [Validators.required]],
      affiliateMarketing: [false],
      termsAndConditions: ['', [Validators.required]],
      numberPool: ['', [Validators.required]],
      ageGated: ['', [Validators.required]],
      directLending: ['', [Validators.required]],
      subscriberOptin: ['', [Validators.required]],
      subscriberOptout: ['', [Validators.required]],
      subscriberHelp: ['', [Validators.required]],
      sample1: ['', [Validators.required, Validators.minLength(20), Validators.maxLength(1024)]],
      sample2: ['', [Validators.required, Validators.minLength(20), Validators.maxLength(1024)]],
      sample3: ['', [Validators.minLength(20), Validators.maxLength(1024)]],
      sample4: ['', [Validators.minLength(20), Validators.maxLength(1024)]],
      sample5: ['', [Validators.minLength(20), Validators.maxLength(1024)]],
      messageFlow: ['', [Validators.required, Validators.minLength(40), Validators.maxLength(2048)]],
      description: ['', [Validators.required, Validators.minLength(40), Validators.maxLength(4096)]],
      helpMessage: [''],
      mnoIds: [''],
      autoRenewal: [true],
      optinKeywords: [],
      optoutKeywords: [],
      helpKeywords: [],
      optinMessage: [''],
      optoutMessage: [''],
      rate: [],
      //fileName: ['']
    });
    // this.mediaForm = this.fb.group({
    //   fileName: ['', Validators.required]
    // })
    var navListItems = $('div.setup-panel div button'),
      allWells = $('.setup-content'),
      allNextBtn = $('.nextBtn');

    allWells.hide();

    navListItems.click(function (e) {
      e.preventDefault();
      var $target = $($(this).attr('href')),
        $item = $(this).closest('li');
      $item = $(this);

      if (!$item.hasClass('disabled')) {
        navListItems.removeClass('btn-success').addClass('btn-default');
        $item.addClass('btn-success');
        allWells.hide();
        $target.show();
        $target.find('input:eq(0)').focus();
      }
    });

    allNextBtn.click(function () {
      var curStep = $(this).closest(".setup-content"),
        curStepBtn = curStep.attr("id"),
        nextStepWizard = $('div.setup-panel div button[href="#' + curStepBtn + '"]').parent().next().children("button"),
        curInputs = curStep.find("input[type='text'],input[type='url']"),
        isValid = true;

      $(".form-group").removeClass("has-error");
      for (var i = 0; i < curInputs.length; i++) {
        if (!curInputs[i].validity.valid) {
          isValid = false;
          $(curInputs[i]).closest(".form-group").addClass("has-error");
        }
      }

      if (isValid) nextStepWizard.removeAttr('disabled').trigger('click');
    });

    $('div.setup-panel div button.btn-success').trigger('click');



    this.campaignService.brandVertical().subscribe(res => {
      let tmp: any = [];
      Object.entries(res.data).forEach((ele: any) => {
        let t = ele[1];
        t["name"] = ele[0];
        tmp.push(t);
      });
      this.brandVertical = tmp;
    });

    this.campaignService.getCampaignCases().subscribe(res => {
      this.campaignCases = res.data;
      this.campaignCases.forEach(element => {
        element.isDisable = false;
        element.isDisabled;
      });
      this.campaignCases.forEach(element => {
        if (element.classification == "STANDARD") {
          this.standardCampaign.push(element);
        }
        if (element.classification == "SPECIAL") {
          this.specialCampaign.push(element);
        }
        if (element.validSubUsecase == "true") {
          element.isDisable = false;
          this.subUseCases.push(element);
        }
      });

      let temp: { [k: string]: any } = [];
      this.campaignCases.forEach(element => {
        if (element.validSubUsecase == "false") {
          let t = element;
          t["subUseCases"] = this.subUseCases;
          temp.push(t);
        }
        else {
          temp.push(element);
        }
      });
    })

    /*Show here only brand list ...for registercampaign directly*/
    this.campaignService.getBrand().subscribe(res => {
      res.data.forEach((ele: any, idx: number) => {
        ele.id = idx;
      });
      this.brandList = res.data;
      this.dataBid = JSON.stringify({
        brandId: this.brandId,
      });
      let bids = JSON.parse(this.dataBid);
      // this.changeBrandId(this.brandList);
      //  this.changeBrandId(bids);
      if (this.brandId) this.changeBrandId(bids);
    })



    this.route.paramMap.subscribe((params: ParamMap) => {
      if (params.get("id")) {
        let data = params.get("id").split("-");
        this.brandId = data[0];
        this.iduser = data[1];
        this.brandName = data[2].split("_").join(" ");
        this.brandNameId = data[2].split("_").join(" ") + ' - ' + data[0];
        this.searchText = data[2].split("_").join(" ");
        this.campaignForm.patchValue({
          brandId: this.brandId
        })
        this.selectedItems = [this.brandNameId];
        this.useCaseSelection(this.brandId);
      }

    });

    this.dropdownSettings = {
      singleSelection: true,
      idField: 'brandId',
      textField: 'brand_name_with_key',
      itemsShowLimit: 3,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };



    // this.getbrandQualifyByAllUseCases(this.brandId);
  }


  // registerCampaignFile()
  // {
  //   if (this.mediaForm.invalid) { 
  //     return false;
  //   }
  //   else {     
  //     this.campaignService.createCampaignFile(this.payLoad).subscribe(res => {
  //      if (res.status == 200) {
  //       this.responseMessage = res.message;
  //       this.showImgName=res.data[0].fileName;
  //       setTimeout(() => {
  //         this.responseMessage = "";
  //       }, 5000);
  //     }
  //     else {
  //       this.responseMessage = res.message;
  //       setTimeout(() => {
  //         this.responseMessage = "";
  //       }, 5000);
  //     }
       
  //     })
  //   }

  // }

  onFileSelect(event) {
    // this.img = event.target.files[0];
    // this.payLoad={
    //   fileName:this.img.name,
    //   mimeType:this.img.type.split('/')[1],
    // }
    // this.getAllMultiMediaFile.push(this.payLoad);
    // if(this.getAllMultiMediaFile.length > 4)
    // {
    //     this.multimediaErr="Max 5 uploads per campaign is allowed";
    //     this.InputBtn=false;
    // }
    // this.campaignForm.patchValue({
    //   fileName: this.getAllMultiMediaFile
    // });
    
  }
  delImg(val){
    //  this.removeData =  this.getAllMultiMediaFile.filter(arr => arr.fileName != val); 
    //   for (var i = this.getAllMultiMediaFile.length - 1; i >= 0; --i) {
    //     if (i == val) {
    //         this.getAllMultiMediaFile.splice(i,1); 
    //     }
    // }
  }
  displayImg()
  {
    // const reader=new FileReader()
    // reader.readAsDataURL(this.img)
    // reader.onload=()=>{
    //   this.getAllMultiMediaFile.push(reader.result);
    // }
    
  }

  deselectBrand(e){    
    this.displaySole = true;
    this.displayG = true;
    this.displayPvt = true;
    this.displayPub = true;
    this.displayNpvt = true;
    if (e.brandId) {
      this.selectedBrand = true;
    }
    this.campaignForm.patchValue({
      brandId: '',
      entityType: ''
    });
    this.brandId = [];
    this.entityType = [];   
    $(".hidebtn").prop( "checked", false ); 
  }



  hidebttn(){
    this.selectedBrand = false;
  } 

  changeBrandId(e) {
    $(".hidebtn").prop( "checked", false );
    // $(".hidebtn").prop( "disabled", false );
    this.specialCampaign.forEach(element=>{
      element.status = false;
    })
    this.displaySole = false;
    this.displayG = false;
    this.displayPvt = false;
    this.displayPub = false;
    this.displayNpvt = false;
    if (e.brandId) {
      this.selectedBrand = true;   
    }
    
    this.campaignForm.patchValue({
      brandId: e.brandId
    });
    this.useCaseSelection(e.brandId);


  }

  useCaseSelection(id?: any) {
    this.brandList.find(el => {
      if (el.brandId == id) {
        this.NextDisable = false;
        this.brandId = el.brandId;
        this.brandName = el.brand_name;
        this.entityType = el.entityType;
        this.identityStatus = el.identityStatus 
        if(this.identityStatus == "" || this.identityStatus == null || this.identityStatus == undefined || this.identityStatus == 'PENDING'){
          this.NextDisable = true;
          // this.ErrDisplay = true;
          this.errMessage = "Brand registration status pending";
          setTimeout(() => {
            // this.ErrDisplay = false;
            this.errMessage="";
          }, 7000);
        }
        if(this.identityStatus == 'UNVERIFIED'){
          this.NextDisable = true;
          this.errMessage = "Brand registration status unverified";
          setTimeout(() => {
            this.errMessage="";
          }, 7000);
        }
      }
    });


    //  for private cases.... 
    if (this.entityType == 'PRIVATE_PROFIT') {
      this.displayPvt = true;
    }
    else {
      this.displayPvt = false;
    }
    // public cases 
    if (this.entityType == 'PUBLIC_PROFIT') {
      this.displayPub = true;
    }
    else {
      this.displayPub = false;
    }
    // for sole proprietor...
    if (this.entityType == 'SOLE_PROPRIETOR') {
      this.displaySole = true;
    }
    else {
      this.displaySole = false;
    }
    //for non-profit case...
    if (this.entityType == 'NON_PROFIT') {
      this.displayNpvt = true;
    }
    else {
      this.displayNpvt = false;
    }
    //for government case
    if (this.entityType == 'GOVERNMENT') {
      this.displayG = true;
    }
    else {
      this.displayG = false;
    }

  }

  onCampaign() {    
    this.campData = {
      usecase: this.usecase,
      subUsecases: this.selectedSubCases,
      brandId: this.brandId,
      
    }
    this.dataMno = JSON.stringify({
      usecase: this.usecase,
      brandId: this.brandId
    });
    this.getMNOs();

    let price: number;
    this.campaignCases.find(el => {
      if (el.name == this.usecase) {
        price = el.rate
      }
    });

    this.campaignForm.patchValue({
      usecase: this.usecase,
      subUsecases: this.selectedSubCases,
      brandId: this.brandId,
      rate: price,
      mnoIds: this.mnoIds
    });
  }

  getbrandQualifyByAllUseCases(bid) {
    this.dataBid = JSON.stringify({
      brandId: bid,
    });
    this.campaignService.brandQualifyByAllUseCases(this.dataBid).subscribe(res => {
      if (res.status == 200) {
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }
      else {
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }

    })
  }

  getMNOs() {
    this.campaignService.mnoMetaDataForRegister(this.dataMno).subscribe(res => {
      this.campaignMno = [];
      if (res.status = 200) {
        let mnoDetail = res.data;
        if (mnoDetail != undefined) {
          //this.mnoIds = Object.keys(mnoDetail)
          let length = Object.keys(mnoDetail).length;
          for (let i = 0; i < length; i++) {
            this.campaignMno.push({ "mnoDetail": Object.values(mnoDetail)[i], "key": Object.keys(mnoDetail)[i] })
          }
          this.campaignMno.forEach(element => {
            if (element.mnoDetail.qualify == true) {
              this.mnoIds.push(element.key);
            }
          });

          if (this.mnoIds.length <= 0) {
            this.mnoButton = false
          }
          else {
            this.mnoButton = true
          }
          
          if (this.campaignMno.length > 0) {
            this.carrierListOrMnos = true
          }
          else {
            this.carrierListOrMnos = false
          }
         if(this.usecase =='M2M' || this.usecase=='SWEEPSTAKE' || this.usecase=='SOCIAL' || this.usecase=='PROXY' || this.usecase=='CARRIER_EXEMPT' || this.usecase=='AGENTS_FRANCHISES'){
                this.m2mEnableCase=true;
           }
           else{
            this.m2mEnableCase=false;
           }
          if(this.usecase =='2FA'){  
          this.enableCase2fa=true;
          }
          else{  
          this.enableCase2fa=false;
          }
          this.campaignForm.patchValue({
            mnoIds: this.mnoIds
          })
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        }
        if (this.campaignMno.length > 0) {
          this.carrierListOrMnos = true
        }
        else {
          this.carrierListOrMnos = false
        }
        this.campaignForm.patchValue({
          mnoIds: this.mnoIds
        })
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }
      else {
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }
    })
  }
  getMnoVal(e: any, mnoid: any) {
    if (e.target.checked) {
      this.mnoIds.push(mnoid);
      this.campaignForm.patchValue({
        mnoIds: this.mnoIds
      })
    }
    else {
      this.mnoIds.forEach((value, index) => {
        if (value == mnoid)
          this.mnoIds.splice(index, 1);
        this.campaignForm.patchValue({
          mnoIds: this.mnoIds
        })
      });
    }
    if (this.mnoIds.length <= 0) {
      this.mnoButton = false
    }
    else {
      this.mnoButton = true
    }

  }
  registerCampaign() { 
    if (this.campaignForm.invalid) {
      this.M2MSubmitted = true;
      return false;
    }
    else {   
     this.campaignService.onNewRegisterCampaign(this.campaignForm.value).subscribe(res => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          this.M2MSubmitted = false;
          setTimeout(() => {
            this.responseMessage = "";
            window.location.reload();
          }, 5000);
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
    }
  }

  onVertical(e) {
    this.selectedVertical = e.target.value;
  }

  changeStatus(e) {
    this.selectedSubCases = [];
    this.isDisabled = false;
    this.isDisable = false;
    this.usecase = [];
    this.usecase = e.target.value;
    this.campaignCases.forEach(element => {
      element.status = false;
      element.isDisabled = false;
      if (this.usecase == element.name) {
        if (element.minSubUsecases == 0) {
          this.isDisabled = true;
        }
      }
      if (e.target.value == element.name) {
        if (element.maxSubUsecases > 0) {
          element.status = true;
          element.isDisabled = true;
          this.minSubUsecases = element.minSubUsecases;
        }
        else {
          this.isDisabled = true;
        }
      }
    });

  }

  onSubCases(e) {
    let mode = false;
    if (e.target.checked) {
      this.selectedSubCases.push(e.target.value);
      let index = this.selectedSubCases.length - 1;
      this.campaignCases.forEach(element => {
        if (element.maxSubUsecases == this.selectedSubCases.length && this.usecase == element.name) {
          this.isDisable = true;
          mode = true;
        }
      });
      if (mode) {
        this.subUseCases.forEach(element => {
          element.isDisabled = true;
        });
        for (let i = 0; i < this.selectedSubCases.length; i++) {
          this.subUseCases.find(el => {
            if (el.name == this.selectedSubCases[i]) {
              el.isDisabled = false;
            }
          });
        }

        // for (let i = 0; i < this.selectedSubCases.length; i++) {
        //   this.subUseCases.forEach(element => {
        //     element.isDisabled = true;
        //     this.subUseCases.find(el => {
        //       if (el.name == this.selectedSubCases[i]) {
        //         el.isDisabled = false;
        //       }
        //     });

        //   });
        // console.log(idx);
        //   if(idx){
        //     this.subUseCases["isDisabled"]=false;
        //   }
        //   else{
        //     this.subUseCases["isDisabled"]=true;
        //   }
        // }
      }
      // this.subUseCases.forEach(element => {
      //     let i = 0;
      //     // element.isDisabled = false;
      //     if(mode && this.selectedSubCases[0] == element.name){
      //       element.isDisabled = false;
      //     }
      //     else if(mode && this.selectedSubCases[i] != element.name){
      //       element.isDisabled = true;
      //     }
      //     i++;
      // });

      if (this.minSubUsecases <= this.selectedSubCases.length) {
        this.isDisabled = true;
      }
    }

    if (!e.target.checked) {
      if (this.minSubUsecases >= this.selectedSubCases.length) {
        this.isDisabled = false;
      }
      // this.subUseCases.forEach(element => {
      //   element.isDisabled = false;
      //   this.subUseCases.find(el => {
      //       if(el.name == this.selectedSubCases[i]){
      //         el.isDisabled = false;
      //       }
      //   });
      // });
      this.subUseCases.forEach(element => {
        element.isDisabled = false;
        // this.subUseCases.find(el => {
        //     if(el.name == this.selectedSubCases[i]){
        //       el.isDisabled = false;
        //     }
        // });
      });
      let i = this.selectedSubCases.findIndex(el => el == e.target.value);
      this.selectedSubCases.splice(i, 1);
    }
  }

  showyes(e: any) {
    if (e == 1) {
      let optmessage: any = this.campaignForm.get('optinMessage');
      optmessage.setValidators([Validators.minLength(20)]);
      optmessage.updateValueAndValidity();
      this.optInEye=true;
      // this.optOutEye=true;
      // this.optHelpEye=true;

      if (this.yes == false) {
        this.yes = true;
      }

      else {
        this.yes = ! false;
      }
    }
    else if (e == 2) {
      let optoutMessage: any = this.campaignForm.get('optoutMessage');
      optoutMessage.setValidators([Validators.required, Validators.minLength(20)]);
      optoutMessage.updateValueAndValidity();
      this.optOutEye=true;
      if (this.outoption == false) {
        this.outoption = true;
      }
      else {
        this.outoption = ! false;
      }
    }
    else if (e == 3) {
      let helpMessage: any = this.campaignForm.get('helpMessage');
      helpMessage.setValidators([Validators.required, Validators.minLength(20)]);
      helpMessage.updateValueAndValidity();
      this.optHelpEye=true;
      if (this.opthelp == false) {
        this.opthelp = true;
      }
      else {
        this.opthelp = ! false;
      }
    }

  }



  opentext(e: any) {
    if (e == 1) {
      this.opt_done();
      if (this.openeye == false) {
        this.openeye = true;
      }
      else {
        this.openeye = ! false;
      }
    }
    if (e == 2) {
      this.out_done();
      if (this.open_optout == false) {
        this.open_optout = true;
      }
      else {
        this.open_optout = ! false;
      }
    }
    if (e == 3) {
      this.help_done();
      if (this.open_opthelp == false) {
        this.open_opthelp = true;
      }
      else {
        this.open_opthelp = ! false;
      }
    }
  }

  editclose() {
    this.submitted = false;
    if (this.openeye == true || this.yes == true) {
      this.openeye = false;
      this.yes = false;
    }
    else {
      this.openeye = ! true;
      this.yes = ! true;
    }

  }
  optout_close() {
    if (this.open_optout == true || this.outoption == true) {
      this.open_optout = false;
      this.outoption = false;
    }
    else {
      this.open_optout = ! true;
      this.outoption = ! true;
    }

  }
  helpclose() {
    if (this.open_opthelp == true || this.opthelp == true) {
      this.open_opthelp = false;
      this.opthelp = false;
    }
    else {
      this.open_opthelp = ! true;
      this.opthelp = ! true;
    }

  }
  opt_done() {
    this.camp = {
      first: this.campaignForm.value.optinKeywords,
      second: this.campaignForm.value.optinMessage
    }
  }
  out_done() {
    this.opt_out = {
      first: this.campaignForm.value.optoutKeywords,
      second: this.campaignForm.value.optoutMessage
    }
  }

  help_done() {
    this.opt_outhelp = {
      first: this.campaignForm.value.helpKeywords,
      second: this.campaignForm.value.helpMessage
    }
  }

  hideEyes(event:any){
    if(event==1){
      this.optInEye=false;
      this.campaignForm.patchValue({
        optinMessage:'',
        optinKeywords:null
      });
    }
    if(event==2)
    {
      this.optOutEye =false;
      this.campaignForm.patchValue({
        optoutMessage:'',
        optoutKeywords:null
      });
    }

    if(event==3)
    {
      this.optHelpEye=false;
      this.campaignForm.patchValue({
        helpMessage:'',
        helpKeywords:null
       
      });
    }

   
  }
  hideYes1() {
    let optmessage: any = this.campaignForm.get('optinMessage');
    optmessage.setValidators([]);
    optmessage.updateValueAndValidity();
   

    // this.campaignForm.patchValue({
    //   optinKeywords: undefined,
    //   optinMessage: '',
    // });
    this.opt_done();
    this.yes = false;
  }


  hideYes2() {
    let optmessage: any = this.campaignForm.get('optoutMessage');
    optmessage.setValidators([]);
    optmessage.updateValueAndValidity();


    // this.campaignForm.patchValue({
    //   optoutKeywords: undefined,
    //   optoutMessage: '',
    // });
    this.out_done();
    this.outoption = false;
  }

  hideYes3() {
    let optmessage: any = this.campaignForm.get('helpMessage');
    optmessage.setValidators([]);
    optmessage.updateValueAndValidity();

    // this.campaignForm.patchValue({
    //   helpKeywords: undefined,
    //   helpMessage: '',
    // });
    this.help_done()
    this.opthelp = false;
  }


  toggleCloseDropdownSelection() {
    this.closeDropdownSelection = !this.closeDropdownSelection;
    this.dropdownSettings = Object.assign({}, this.dropdownSettings, { closeDropDownOnSelection: this.closeDropdownSelection });
  }

  displayErr(){
    if(this.identityStatus == 'UNVERIFIED'){
      this.errMessage="Brand registration status unverified";
    }
    else{
      this.errMessage="Brand registration status pending";
    }
		setTimeout(() => {
			this.errMessage="";
		}, 7000);
	}

  showMsg()
	{
		this.errMessage = this.serviceMessage;
		setTimeout(() => {
			this.errMessage = "";
		}, 5000);
	}

}
