import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { BehaviorSubject, Observable } from 'rxjs';
import { AppService } from 'src/app/shared/service/AppService.class';
import { environment } from 'src/environments/environment';
import { APIURL } from '../app-routing.module';
import { LoaderEnabled } from '../shared/loader/loader.service';

@Injectable({
  providedIn: 'root'
})
export class OutboundService extends AppService<any> {

  constructor(public http: HttpClient) {
    super(http)
    this.appmod = "usermanagement";
  }
  @LoaderEnabled()
  taxCalculation(data: any): Observable<any> {
    this.appmod = "tax_calculation";
    let result = super.saveService(data);
    this.appmod = "usermanagement";
    return result;
  }
  @LoaderEnabled()
  saveData(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'custom/saveheadermapping';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  callDetailRecord(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'details_cdr';
    let result = super.getService(data);
    this.appmod = tmp;
    return result;
  }


  @LoaderEnabled()
  updateData(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'custom/saveheadermapping';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  testCall(data: any): Observable<any> {

    const apiURL = environment.SERVER + 'originate';

    // let httpHeaders = new HttpHeaders({
    //   "Content-Type": "application/json"
    // });

    return this.http.post(apiURL, data);
    // let tmp = this.appmod;
    // this.appmod = 'outboundcalltonumber';
    // let result = super.saveService(data);
    // this.appmod = tmp;
    // return result;
  }

  @LoaderEnabled()
  testCallviaMedia(data: any): Observable<any> {
    const apiURL = environment.SERVER + 'makeCallViaMedia';
    return this.http.post(apiURL, data);
  }

  @LoaderEnabled()
  uploadMediaFile(media: any, file: File | any): Observable<any> {
    const formData = new FormData();
    formData.append("UPLOAD", file);
    formData.append("data", JSON.stringify(media));
    const apiURL = environment.SERVER + 'uploadMedia';
    let httpHeaders = new HttpHeaders({
    });
    return this.http.post(apiURL, formData, { headers: httpHeaders });
  }

  @LoaderEnabled()
  getMediaFiles(): Observable<any> {
    let apiUrl = environment.SERVER + 'listMedia';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiUrl, { headers: httpHeaders });
  }

  @LoaderEnabled()
  deleteMediaFile(mediaID): Observable<any> {
    let apiUrl = environment.SERVER + 'deleteMedia';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.delete(apiUrl, { headers: httpHeaders, params: { mediaID: mediaID } });
  }

  get_trunks(): Observable<any> {
    return this.http.get('./assets/trunks.json');
  }

  get_routing(): Observable<any> {
    return this.http.get('./assets/routing_profile.json');
  }

  get_cdr(): Observable<any> {
    return this.http.get('./assets/cdr.json');
  }
  gettestcall(): Observable<any> {
    return this.http.get('./assets/calltesting.json');
  }
  getmedia(): Observable<any> {
    return this.http.get('./assets/testcallmedia.json');
  }
  getMediaUpload(): Observable<any> {
    return this.http.get('./assets/mediaupload.json');
  }

  getCdr(): Observable<any> {
    return this.http.get('./assets/cdr.json');
  }

}
