import { Component, OnInit } from '@angular/core';
import { OutboundService } from '../outbound.service';
import { Router } from '@angular/router';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { log } from 'console';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
declare var $: any;
@Component({
  selector: 'app-test-call-by-media',
  templateUrl: './test-call-by-media.component.html',
  styleUrls: ['./test-call-by-media.component.css']
})
export class TestCallByMediaComponent extends AppComponentClass<any, any> {
  fieldform: any;
  testMediaForm: any;
  public testCallForm: FormGroup;
  public submitted: boolean = false;
  responseMessage = "";
  errMessage: any = "";
  mediaFiles: any;

  constructor(public data: OutboundService, public router: Router, public fb: FormBuilder) {
    super(data, router, fb);
    this.testMediaForm = this.fb.group({
      FROM: ['', [Validators.required,Validators.minLength(10)]],
      TO: ['', [Validators.required,Validators.minLength(10)]],
      mediaID: ['', [Validators.required]]

    });
  }

  ngOnInit(): void {
    this.data.getmedia().subscribe((result) => {
      this.fieldform = result;
    })

    this.data.getMediaFiles().subscribe(res => {
      if (res.status == 200) {
        $('#basic-datatables').DataTable().clear();
        $('#basic-datatables').DataTable().destroy();
        this.mediaFiles = res.data
        $.getScript('./assets/table.js');
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });

  }

  // filterByUser(e) {
  //   console.log("dataaaaaa",e);
    
  //   this.testMediaForm.patchValue({
  //     mediaID: e.target.value
  //   });
  // }

  allowNumbersOnly(e) {
    var code = (e.which) ? e.which : e.keyCode;
    if (code > 31 && (code < 48 || code > 57)) {
        e.preventDefault();
    }
}

  onTestCall() {    
    this.submitted = true;
    if (this.testMediaForm.invalid) {
      return false;
    } else {
      this.data.testCallviaMedia(this.testMediaForm.value).subscribe(response => {
        if (response.status == 200) {
          this.responseMessage = response.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        }
        else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.responseMessage = err.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      });
    }
  }
  resetCall(){
    this.submitted = false;
  }
  onReset() {
    this.submitted = false;
    this.testMediaForm.reset();
  }

}
