import { Component, OnInit } from '@angular/core';
import { AbstractControl, FormBuilder, FormControl, FormGroup, ValidatorFn, Validators } from '@angular/forms';
import { trigger, transition, style, animate, state } from '@angular/animations';
import { ResellerService } from '../reseller.service';
import { ActivatedRoute, Router } from '@angular/router';
// import { Observable } from 'rxjs';
declare var $:any;

@Component({
  selector: 'app-commission-details',
  templateUrl: './commission-details.component.html',
  styleUrls: ['./commission-details.component.css'],
  animations: [
		trigger('widthGrow', [
			state(
				'closed',
				style({
					border: "0px",
					height: "0px",
					margin: "0px 0px 20px 0px",
				})
			),
			state(
				'open',
				style({

					margin: "0px 0px 20px 0px",
				})
			),
			transition('* => *', animate(500)),
		]),
	],
})
export class CommissionDetailsComponent implements OnInit {
  responseMessage: any = "";
  errMessage: any = "";
  searchText = { count: 0 };
  count = 0;
  tableSize = 25;
  tableSizes = [25, 50, 100];
  show: boolean = false;

  cdetailfilter: any = [];
  public filterCDetails: FormGroup;
  submitted: boolean = false;
  filterIconVal: any;
  state: any;
  messs: string ='';

  

  constructor(private data: ResellerService, public fb: FormBuilder,private route: ActivatedRoute, public router: Router) {}
  ngOnInit(): void {
    this.state = 'closed';
    this.filterIconVal = "1";

    this.filterCDetails = this.fb.group({
			username: [],
			transaction_id: [],
      fromDate: new FormControl(''),
      toDate: new FormControl(''),		
		}, {
      validator: Validators.compose([
        CommissionDetailsComponent.dateLessThan('fromDate', 'toDate', { 'fromDate': true })
      ])
    });

    // this.getcdetaillist(); 

    /*add filter for commission details */   
    this.getCommDetails();

  }

  getCommDetails(){
  this.data.applyCommDetailsFilter(JSON.stringify(this.filterCDetails.value)).subscribe(response => {
    if (response.data) {
      this.cdetailfilter = response.data; 
      $('#basic-datatables').DataTable().clear();
      $('#basic-datatables').DataTable().destroy();       
      $.getScript('./assets/table.js');
    }
  });
}

  /**Function for filter hide open**/
    showField() {
      if (this.show == false) {
        this.show = true;
      }
      else {
        this.show = false;
      }
    }


  /*change value of filter button*/
  changeState(val): void {
		this.state == 'closed' ? (this.state = 'open') : (this.state = 'closed');
		val == '1' ? (this.filterIconVal = '2') : (this.filterIconVal = '1');
	}

  resetFilter() {
    this.messs ="";
    this.submitted = false;
    this.filterCDetails.reset();
    this.getCommDetails();
  }

  applycDetailsFilter() {
    
    let ddata = JSON.stringify(this.filterCDetails.value);
    if(this.filterCDetails.value.fromDate ||this.filterCDetails.value.toDate ||
      this.filterCDetails.value.username || this.filterCDetails.value.transaction_id )
        {
          this.data.applyCommDetailsFilter(ddata).subscribe(res => {
            if (res.status == 200) {
              this.messs =""
              this.cdetailfilter = res.data;                  
              $('#basic-datatables').DataTable().clear();
              $('#basic-datatables').DataTable().destroy();
              $.getScript('./assets/table.js');
            }
            else {
              this.errMessage = res.message;
              setTimeout(() => {
                this.errMessage = "";
              }, 5000);
            }
          })
       } 
        else
        {
          this.messs="Please Enter atleast 1 field!";
        }
  }

  selectedFromDate(e) {
		this.submitted = true;
		if (e.target.value) {
			this.filterCDetails.get("toDate").setValidators(Validators.required);
			this.filterCDetails.get("toDate").updateValueAndValidity();
		}
	}

	selectedToDate(e) {
		this.submitted = true;
		if (e.target.value) {
			this.filterCDetails.get("fromDate").setValidators(Validators.required);
			this.filterCDetails.get("fromDate").updateValueAndValidity();
		}
	}

// for date compare in the from and to date...
  static dateLessThan(fromDate: string, toDate: string, validatorField: { [key: string]: boolean }): ValidatorFn {
    return (c: AbstractControl): { [key: string]: boolean } | null => {
      const date1 = c.get(fromDate).value;
      const date2 = c.get(toDate).value;
      if ((date1 !== null && date2 !== null) && date1 > date2) {
        return validatorField;
      }
      return null;
    };
  }
}
