import { Component, OnInit } from '@angular/core';
import { AbstractControl, FormBuilder, FormControl, FormGroup, ValidatorFn, Validators } from '@angular/forms';
import { trigger, transition, style, animate, state } from '@angular/animations';
import { ResellerService } from '../reseller.service';
import { ActivatedRoute, ParamMap } from '@angular/router';
declare var $:any;
@Component({
  selector: 'app-customer-details',
  templateUrl: './customer-details.component.html',
  styleUrls: ['./customer-details.component.css'],
  animations: [
    trigger('widthGrow', [
      state(
        'closed',
        style({
          border: "0px",
          height: "0px",
          margin: "0px 0px 20px 0px",
        })
      ),
      state(
        'open',
        style({

          margin: "0px 0px 20px 0px",
        })
      ),
      transition('* => *', animate(500)),
    ]),
  ],
})
export class CustomerDetailsComponent implements OnInit {
  responseMessage: any = "";
  errMessage: any = "";
  searchText = { count: 0 };
  count = 0;
  tableSize = 25;
  tableSizes = [25, 50, 100];
  show: boolean = false;
  filterIconVal: any;
  state: any;
  idUser: string;
  submitted: boolean = false;
  customerfilter: any =[];
  public custoDfilter: FormGroup;

  constructor(private data: ResellerService, private route: ActivatedRoute,public fb: FormBuilder) { }

  ngOnInit(): void {
    this.state = 'closed';
    this.filterIconVal = "1";

    this.route.paramMap.subscribe((params: ParamMap) => {
      this.idUser = params.get('id');
    });

    this.custoDfilter = this.fb.group({
      fromDate: new FormControl(this.startDate(), [Validators.required]),
      toDate: new FormControl(this.current_datetime(), [Validators.required]),
      san:[''],	
			username: [],
      commission_amount:[],
      id:[this.idUser]   		
		},{
      validator: Validators.compose([
        CustomerDetailsComponent.dateLessThan('fromDate', 'toDate', { 'fromDate': true })
      ])
    }
    );


    /*add filter for commission details */   
     this.getCustomerDetails();

  }

  getCustomerDetails(){
    this.data.applyCustomerDFilter(JSON.stringify(this.custoDfilter.value)).subscribe(response => {
      if (response.data) {
        this.customerfilter = response.data;  
        $('#basic-datatables').DataTable().clear();
        $('#basic-datatables').DataTable().destroy();    
        $.getScript('./assets/table.js');
      }
    });
  }
  /**Function for filter hide open**/
  showField() {
    if (this.show == false) {
      this.show = true;
    }
    else {
      this.show = false;
    }
  }
  /*change value of filter button*/
  changeState(val): void {
    this.state == 'closed' ? (this.state = 'open') : (this.state = 'closed');
    val == '1' ? (this.filterIconVal = '2') : (this.filterIconVal = '1');
  }


  resetFilter() {
    this.ngOnInit();
    // this.custoDfilter.reset();
    this.getCustomerDetails();
    this.custoDfilter.patchValue({
			fromDate: this.startDate(),
			toDate: this.current_datetime(),
		})
  }

  customerDetailFilter() {
    let ddata = JSON.stringify(this.custoDfilter.value);
            this.data.applyCustomerDFilter(ddata).subscribe(res => {
              if (res.status == 200) {
                this.customerfilter = res.data;                  
                $('#basic-datatables').DataTable().clear();
                $('#basic-datatables').DataTable().destroy();
                $.getScript('./assets/table.js');
              }
              else {
                this.errMessage = res.message;
                setTimeout(() => {
                  this.errMessage = "";
                }, 5000);
              }
            })
  }

  numberOnly(event): boolean {
		const charCode = (event.which) ? event.which : event.keyCode;
		if (charCode > 31 && (charCode < 48 || charCode > 57)) {
		  return false;
		}
		return true;
	}

  startDate() {
    let now = new Date();
    let year = "" + now.getFullYear();
    let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
    let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
    let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
    let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
    let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
    return year + '-' + month;
  }


  current_datetime() {
    let now = new Date();
    let year = "" + now.getFullYear();
    let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
    let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
    let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
    let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
    let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }  
    return year + '-' + month;
  }

  static dateLessThan(fromDate: string, toDate: string, validatorField: { [key: string]: boolean }): ValidatorFn {
    return (c: AbstractControl): { [key: string]: boolean } | null => {
      const date1 = c.get(fromDate).value;
      const date2 = c.get(toDate).value;
      if ((date1 !== null && date2 !== null) && date1 > date2) {
        return validatorField;
      }
      return null;
    };
  }
}
