import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { CommissionDetailsComponent } from './commission-details/commission-details.component';
import { CommissionPlanComponent } from './commission-plan/commission-plan.component';
import { CommissionTermComponent } from './commission-term/commission-term.component';
import { CommissionTierComponent } from './commission-tier/commission-tier.component';
import { ResellerComponent } from './reseller/reseller.component';
import { CustomerDetailsComponent } from './customer-details/customer-details.component';

const routes: Routes = [
  {
    path: '',
    children: [
        {
            path: 'reseller',
            component: ResellerComponent,
            data: {
                title: 'Reseller List',
                urls: [
                    {
                        title: 'Reseller',

                    },
                    {
                        title: 'Reseller List'
                    }
                ]
            }
        },
        {
        path: 'commission-details',
        component: CommissionDetailsComponent,
        data: {
            title: 'Reseller Commission Details',
            urls: [
                {
                    title: 'Reseller'
                },
                {
                    title: 'Reseller Commission Details'
                }
            ]
        }
    },
    {
        path: 'commission-plan',
        component: CommissionPlanComponent,
        data: {
            title: 'Reseller Commission Plan',
            urls: [
                {
                    title: 'Reseller'
                },
                {
                    title: 'Reseller Commission Plan'
                }
            ]
        }
    },
    {
        path: 'commission-term',
        component: CommissionTermComponent,
        data: {
            title: 'Reseller Commission Term',
            urls: [
                {
                    title: 'Reseller'
                },
                {
                    title: 'Reseller Commission Term'
                }
            ]
        }
    },
    {
    path: 'commission-tier/:id',
    component: CommissionTierComponent,
    data: {
        title: 'Reseller Commission Tier',
        urls: [
            {
                title: 'Reseller'
            },
            {
                title: 'Reseller Commission Tier'
            }
        ]
    }
    },
    {
    path: 'customer_details/:id',
    component: CustomerDetailsComponent,
    data: {
        title: 'Reseller Customer details',
        urls: [
            {
                title: 'Reseller'
            },
            {
                title: 'Reseller Customer details'
            }
        ]
    }
    }
]
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class ResellerRoutingModule { }
