import { Component, OnInit, Input, OnDestroy } from '@angular/core';
import { Router } from '@angular/router';
declare var $: any;
import { FormGroup } from '@angular/forms';
import { Observable, Subscription} from 'rxjs';
import { ProfileService } from '../../profile/profile.service';
import { AuthenticationService } from 'src/app/authentication/authentication.service';
import { Theme } from '../service/AutoTheme';
import { BillingService } from 'src/app/billing/billing.service';
import { InboundService } from 'src/app/inbound/inbound.service';
import { Store } from '@ngrx/store';
import * as fromInbound from '../../inbound/inbound.reducer';
import * as inboundAction from '../../inbound/inbound.action';
import { Cart } from 'src/app/inbound/inbound.class';
import { BalanceComponent } from 'src/app/usermanagement/profile/balance/balance.component';
import { MatDialog } from '@angular/material/dialog';
import { ImportantNoticeComponent } from '../important-notice/important-notice.component';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service'; 

@Component({
  selector: 'app-header-navigation',
  templateUrl: './header-navigation.component.html',
  styleUrls: ['./header-navigation.component.css']
})

export class HeaderNavigationComponent implements OnInit, OnDestroy {
 /*  currDiv: string = 'A';
  layout: string = 'vertical'; */
  @Input() leftsetting: boolean;
  themeForm: FormGroup;
  submitted = false;
  /* sipstatus: Observable<string>; */
  sessionType: any;
  isAdmin: boolean = false;
  isCustomer: boolean = false;
  isSubCustomer: boolean = false;
  responseMessage: any = "";
  errMessage: any = "";
  balanceData: any;
  billingAddress: any;
 /*  active = 'call'; */
  /* currentJustify = 'justified';
  currentOrientation = 'horizontal'; */
  public calltype: any;
  tabStatus = 'justified';
  public isCollapsed = false;
  public userlist: any
  public username: string;
  public email: any;
  profile_pic: any;
  public innerWidth: any;
  public defaultSidebar: any;
  public showSettings = false;
  public showMobileMenu = false;
 /*  public expandLogo = false; */
  /* public showSettings1;
  public showSettings2; */
  balance: any;
  isSignUpLogin: Boolean = false;
  disabled: boolean = false;
  isMyRates: Boolean = false;

  @Input() atttheme = "black";
  @Input() header = "#1269DB";

  counter$: Observable<Cart[]>;
 /*  min_balance: any;
  current_balance: any; */
  errrrMessage: string;
  isalert:boolean=false;
  alrt: any;
  kycHeader: any;
  kycRes: any;
  newUserStatus: any;
  san: any;
  private subscriptionName: Subscription

  //   ShowDiv(divVal: string) {
  //       this.currDiv = divVal;
  //     }


  constructor(protected inboundService: InboundService,
    protected billingService: BillingService,
    protected authService: AuthenticationService,
    protected data: ProfileService,
    public router: Router, public them: Theme,
    public dialog: MatDialog,
    private store: Store<fromInbound.inboundState>,
    private theme: Theme,
    protected userSerive: UsermanagementService,
  ) {

    this.inboundService.getCart().subscribe(res => {
      let cartItems: any = [];
      res.data.forEach(element => {
        cartItems.push({ did: element.did })
      });
      this.store.dispatch(new inboundAction.Set(cartItems));
    });

    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.sessionType = session.type;
    this.newUserStatus = session.newUser_status; 
    if(session.newUser_status==0)
    {
      if (session.isEmailVerify == "true" && session.isMobileVerify == "true" && session.isAddress == "true" && session.isPlan == "true") {
        this.disabled = true;
      }
      else {
        this.disabled = false;
      }
    }
    if(session.newUser_status==1)
    {
      if (session.isEmailVerify == "true" && session.isMobileVerify == "true" && session.isAddress == "true" && session.isPlan == "true" && session.isCard == "true") {
        this.disabled = true;
      }
      else {
        this.disabled = false;
      }
    }

  
    if (session.isPlan == "true") {
      this.isMyRates = true;
    }
    else {
      this.isMyRates = false;
    }

    if (session$) {
      this.isSignUpLogin = true;
    }
    this.subscriptionName= this.userSerive.getUpdate().subscribe
      (message => {
        if(message.text){
          this.ngOnInit();
        }
    });
  }


  ngOnInit() {
    this.alrt = "2"
    this.counter$ = this.store.select(fromInbound.getCartItems);

    this.data.getUsers("detail").subscribe(res => {
      if (res.data.length > 0) {
        this.userlist = res.data[0];
        this.username = this.userlist[0].user_name;
        this.san = this.userlist[0].san;
        this.email = this.userlist[0].email;
        this.profile_pic = this.userlist[0].profile_pic;
        if (this.profile_pic == undefined) {
          this.profile_pic = './assets/img/profile.jpg';
        }
      }
    }, error => {
      console.log(error.message);
    });

     /*Service for kyc response*/ 
     this.userSerive.getKycHeader().subscribe(res => {
      if (res.status == 200) {
        this.kycHeader = res.data;
        this.kycRes = res.data[0].kyc_verify_status;
        if(this.kycRes == 0)
        {
          this.kycRes = "Unverified"
        }
        if(this.kycRes == 1)
        {
          this.kycRes = "Verified"
        }
        if(this.kycRes == 2)
        {
          this.kycRes = "Verification Pending"
        }
      }
    //   else {
    //     this.errMessage = res.message;
    //     setTimeout(() => {
    //       this.errMessage = "";
    //     }, 5000);
    //   }
    // }, err => {
    //   this.errMessage = err.message;
    //   setTimeout(() => {
    //     this.errMessage = "";
    //   }, 5000);
    });

    this.billingService.getBillingAddress().subscribe(res => {
      if (res.status == 200) {
        this.billingAddress = res.data;
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });

    this.billingService.getBalance()
      .subscribe(response => {
        if (response.status = 200) {
          if (response.data.length > 0) {
            this.balance = response.data[0].balance;
            this.balanceData = response.data[0];
            if (!this.balance) {
              this.balance = 0;
            }

            // Low Balance Alert Grayout
            if (this.balance < this.balanceData.min_balance) { 
             /*  this.isalert=true;  
              this.alrt = "1"  
              setTimeout(() => {
                this.errrrMessage = "Your current balance is low!";
              }); */
            }

          }
          else {
            this.balance = 0;
          }
        }
        else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });

   /*  this.userManagement.getBalance().subscribe(response => {
      if (response.status == 200) {     
          this.min_balance = response.data[0].min_balance;
          this.current_balance = response.data[0].balance  
        if (this.current_balance < this.min_balance) {     
          setTimeout(() => {
            this.errrrMessage = "Your current balance is low!";
          });
        }  
      }
      
    }) */

  }

  makePayment() {
    const dialogRef = this.dialog.open(BalanceComponent, {
      data: { balance: this.balanceData, userProfile: this.userlist, address: this.billingAddress },
      disableClose: true
    });

    dialogRef.afterClosed().subscribe(result => {
      if (result.reload) {
        this.disabled = false;
        window.location.reload();
        this.responseMessage = result.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }
      else {
        this.errMessage = result.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  importantNotice() {
    const dialogRef = this.dialog.open(ImportantNoticeComponent, {
      data: { },
      disableClose: true
    });
  }
  
  onClickAlr(){
    this.alrt="2"
  }
  onLogout() {
    this.authService.logout();
  }

  ngOnDestroy() {
    this.leftsetting = false;
  }
}