import { OnInit, ViewChild, AfterViewInit, OnDestroy } from "@angular/core";
import { Router, ActivatedRoute, ChildActivationEnd } from "@angular/router";
import { AppService } from './AppService.class';
import {MatSnackBar} from '@angular/material/snack-bar'
import { FormBuilder } from "@angular/forms";
import { environment } from '../../../environments/environment';
import { filter, take } from 'rxjs/operators';
import { BehaviorSubject, Observable } from "rxjs";

export class AppComponentClass<T1, T2> implements OnInit {
  public userid: number;
  public displayedColumns: any[];
  public cdata: T2;
  public cur_row: T1;
  protected keyfield: number;
  public state: boolean;
  protected amount: number;
  protected pkgselected: number;
  private debug = environment.production;

  public tag_label: string;
  dataSource: any;

  //////@for role permissions//////
  permissions?: any = {}
  user_type: number = 0
  user_key: string = ""
  role_type: number = 0
  userData: any = {}
  //////@for role permissions//////

  constructor(
    protected data: AppService<T1>,
    protected router: Router,
    protected fb?: FormBuilder,
    public aRoute?: ActivatedRoute,
    protected snackBar?: MatSnackBar
  ) {
    this.userid = parseInt(this.userData?.id); //localStorage.getItem('userid')
    this.keyfield = -1;
    this.amount = null;
    this.pkgselected = -1;

    //////@for role permissions//////
    this.user_type = parseInt(this.userData?.role_type) //localStorage.getItem("type")
    this.user_key = this.userData?.role_key || ""  //localStorage.getItem("role_key")
    this.role_type = parseInt(this.userData?.role_type) //sessionStorage.getItem("role_type")

    this.router.events.pipe(
      filter(event => event instanceof ChildActivationEnd),
      take(1),
    ).subscribe((e: ChildActivationEnd) => {
      if (typeof e.snapshot?.data?.permissions != 'undefined' && Array.isArray(e.snapshot?.data?.permissions)) {
        let modules: any = e.snapshot?.data?.permissions
        for (let x of modules) [
          this.permissions[x.mod_short_key] = {
            exec_w: x.exec_w,
            exec_r: x.exec_r,
            exec_x: x.exec_x
          }
        ]
      }
    })
    //////@for role permissions//////

    // this.userData = this?.router?.config[1]?.data?.sessdata.gSDt
  }

  getRouteData(): Observable<any> {
    let tmp = new BehaviorSubject<any>(null);
    this?.router?.config[1]?.data?.gvdata?.getData().subscribe(res => {
      tmp.next(res);
    });
    return tmp;
  }

  setRouteData(data: any) {
    this?.router?.config[1]?.data?.gvdata?.setData(data);
  }


  /*getMute(): Observable<any> {
    let tmp = new BehaviorSubject<any>(null);
    this?.router?.config[1]?.data?.gvdata?.getMute().subscribe(res => {
      tmp.next(res)
    });
    return tmp;
  }

  setMute(data: any) {
    this?.router?.config[1]?.data?.gvdata?.setMute(data)
  }

  getHold(): Observable<any> {
    let tmp = new BehaviorSubject<any>(null);
    this?.router?.config[1]?.data?.gvdata?.getHold().subscribe(res => {
      tmp.next(res)
    });
    return tmp;
  }

  setHold(data: any) {
    this?.router?.config[1]?.data?.gvdata?.setHold(data)
  }

  getCalling(): Observable<any> {
    let tmp = new BehaviorSubject<any>(null);
    this?.router?.config[1]?.data?.gvdata?.getCalling().subscribe(res => {
      tmp.next(res)
    });
    return tmp;
  }

  setCalling(data: any) {
    this?.router?.config[1]?.data?.gvdata?.setCalling(data)
  }*/
  // getRouteData(): Observable<any> {
  //   let tmp = new BehaviorSubject<any>(null);
  //   this.router.events.pipe(
  //     filter(event => event instanceof ChildActivationEnd),
  //     take(1),
  //   ).subscribe((e: ChildActivationEnd) => {
  //     tmp.next(e.snapshot.data.gvdata.getData());

  //   });
  //   return tmp;
  // }

  // setRouteData(data: any) {
  //   this.router.events.pipe(
  //     filter(event => event instanceof ChildActivationEnd),
  //     take(1),
  //   ).subscribe((e: ChildActivationEnd) => {
  //     e.snapshot.data.gvdata.setData(data);

  //   });
  // }

  // @it will print debug log of submitted form
  public debug_log(log: string) {
    if (!this.debug){}
  }

  ngOnInit() {
    this.data.frm_label.subscribe(res => {
      this.tag_label = res;
    });

    this.data.status.subscribe(res => {
      this.state = res;
    });

  

    //  this.loadDataSource();
  }

  nextButtonClickEvent(): void {
    //do next particular records like  101 - 200 rows.
    //we are calling to api
  }

  // loadDataSource() {
  //   this.data.getService().subscribe(res => {
  //     // this.debug_log(res.toString());
  //     this.dataSource = res;
  //   });
  // }

  // @to edit the current row data
  Edit(row: T1) {
    this.data.changelabel("Edit Details");
    this.data.Data = row;
    this.data.changefrm(true);
  }

  // @to delete the current row data
  Delete(id: number) {
    this.openSnackBar("Data is deleted successfully","Clear");
  }

  // @it will submit form-data
  onSubmit() {
    this.debug_log("Thanks for submitting! Data: " + JSON.stringify(this.cdata));
    this.debug_log(this.keyfield.toString());
    if (this.keyfield == -1) {
      this.data.saveService(JSON.stringify(this.cdata)).subscribe(rs => {
        this.data.changefrm(false);
        this.openSnackBar("Data is added successfully","Clear");
        this.data.changelabel("List Details");
      });
    }
    else {
      this.data.updateService(JSON.stringify(this.cdata), this.keyfield).subscribe(rs => {
        this.data.changefrm(false);
        this.data.Data = null;
        this.data.changelabel("List Details");
      });
    }
  }

  openSnackBar(message: string, action: string) {
    this.snackBar.open(message, action, {
      duration: 2000,
    });
  }

  // @get current date-time
  current_datetime() {
    let now: any = new Date(),
      year: string = "" + now.getFullYear(),
      month: string = "" + (now.getMonth() + 1),
      day: string = "" + now.getDate(),
      hour: string = "" + now.getHours(),
      minute: string = "" + now.getMinutes(),
      second: string = "" + now.getSeconds()

    month = (month.length == 1) ? "0" + month : month
    day = (day.length == 1) ? day = "0" + day : day
    hour = (hour.length == 1) ? hour = "0" + hour : hour
    minute = (minute.length == 1) ? minute = "0" + minute : minute
    second = (second.length == 1) ? second = "0" + second : second

    return year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second
  }

  // @unsubscribe observable behaviour on ngDestroy
  onDestroy() {
    this.data.frm_label.unsubscribe();
  }
}