import { NgModule } from '@angular/core';
import { CommonModule, DecimalPipe } from '@angular/common';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { RouterModule } from '@angular/router';
import { BreadcrumbComponent} from './breadcrumb/breadcrumb.component';
import { MenuService } from './sidebar/menu.service';
import { SidebarComponent } from './sidebar/sidebar.component';
import { Theme } from './service/AutoTheme';
import { HeaderNavigationComponent } from './header-navigation/header-navigation.component';
import { UploadviewComponent } from './uploadview/uploadview.component';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { DemoMaterialModule } from '../demo-material-module';
import { DynamicformComponent } from './dynamicform/dynamicform.component';
import { DynamictableComponent } from './dynamictable/dynamictable.component';
import { AlertComponent } from './alert/alert.component';
import { LoaderComponent } from './loader/loader.component';
import { NgApexchartsModule } from 'ng-apexcharts';
import { DialogComponent } from './dialog/dialog.component';
import { FilterListPipe } from './filter-pipe.pipe';
import { ProfileService } from '../profile/profile.service';
import { ReportService } from '../reports/reports.service';
import { ReportComponent } from './report/report.component';
import { NgxPaginationModule } from 'ngx-pagination';
import { FloorDecimal1 } from './decimal.pipe';
import { NgxEditorModule } from 'ngx-editor';
import { CenterAlertComponent } from './center-alert/center-alert.component';
import { ImportantNoticeComponent } from './important-notice/important-notice.component';


@NgModule({
  imports:[
     CommonModule,
     RouterModule,
     FormsModule,
     NgbModule,
     ReactiveFormsModule,
     DemoMaterialModule,
     NgApexchartsModule,
     NgxPaginationModule,
     NgxEditorModule.forRoot({
      locals: {
        bold: 'Bold',
        italic: 'Italic',
        code: 'Code',
        underline: 'Underline',
        // ...
      },
    })
  ],

  declarations: [
    BreadcrumbComponent,
    SidebarComponent,
    HeaderNavigationComponent,
    UploadviewComponent,
    DynamicformComponent,
    DynamictableComponent,
    AlertComponent,
    LoaderComponent,
    DialogComponent,
    FilterListPipe,
    ReportComponent,
    FloorDecimal1,
    CenterAlertComponent,
    ImportantNoticeComponent
  ],

  exports: [
    BreadcrumbComponent,
    SidebarComponent,
    HeaderNavigationComponent,
    UploadviewComponent,
    DynamicformComponent,
    DynamictableComponent,
    AlertComponent,
    LoaderComponent,
    FilterListPipe,
    ReportComponent,
    NgxEditorModule,
    CenterAlertComponent
   ],
   entryComponents: [],
   providers: [MenuService, Theme, ProfileService, ReportService]

})

export class SharedModule { }
