import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { FactorauthenticationComponent } from './factorauthentication/factorauthentication.component';
import { FactorauthenticationdetailsComponent } from './factorauthenticationdetails/factorauthenticationdetails.component';
import { MdrsComponent } from './mdrs/mdrs.component';
import { SmssettingComponent } from './smssetting/smssetting.component';
import { TestmessageComponent } from './testmessage/testmessage.component';
import { AddfavoiceComponent } from './addfavoice/addfavoice.component';
import { FavoicedetailsComponent } from './favoicedetails/favoicedetails.component';
import { MmsMDRComponent } from './mms-mdr/mms-mdr.component';


const routes: Routes = [
    {
        path: '',
        children: [
            {
                path: '',
                component: MdrsComponent,
                data: {
                    title: 'Dashboard',
                    urls: [
                        {
                            title: 'Dashboard',
                            url: '/dashboards/dashboard'
                        },
                        {
                            title: 'Dashboard'
                        }
                    ]
                }
            },
            {
                path: 'mdrs',
                component: MdrsComponent,
                data: {
                    title: 'SMS',
                    urls: [
                        {
                            title: 'SMS',
                            //   url: '/sms/mdrs'
                        },
                        {
                            title: 'Mdrs'
                        }
                    ]
                }
            },
            {
                path: 'mms-mdr',
                component: MmsMDRComponent,
                data: {
                    title: 'MMS',
                    urls: [
                        {
                            title: 'MMS',
                            //   url: '/sms/mdrs'
                        },
                        {
                            title: 'MMS Mdrs'
                        }
                    ]
                }
            },



            {
                path: 'sms-setting',
                component: SmssettingComponent,
                data: {
                    title: 'SMS',
                    urls: [
                        {
                            title: 'SMS ',

                        },
                        {
                            title: 'OTP Setting'
                        }
                    ]
                }
            },


            {
                path: 'add-2fa-voice',
                component: AddfavoiceComponent,
                data: {
                    title: 'SMS',
                    urls: [
                        {
                            title: 'SMS ',

                        },
                        {
                            title: 'Add 2FA Voice'
                        }
                    ]
                }
            },

            {
                path: 'add-2fa-voice/:id',
                component: AddfavoiceComponent,
                data: {
                    title: 'SMS',
                    urls: [
                        {
                            title: 'SMS ',

                        },
                        {
                            title: 'Edit 2FA Voice'
                        }
                    ]
                }
            },

            {
                path: '2fa-voicedetails',
                component: FavoicedetailsComponent,
                data: {
                    title: 'SMS',
                    urls: [
                        {
                            title: 'SMS ',

                        },
                        {
                            title: 'Voice Details'
                        }
                    ]
                }
            },



            {
                path: 'test-message',
                component: TestmessageComponent,
                data: {
                    title: 'SMS',
                    urls: [
                        {
                            title: 'SMS',
                            //   url: '/sms/test-message'
                        },
                        {
                            title: 'Test Message'
                        }
                    ]
                }
            },
            {
                path: 'factor-authentication',
                component: FactorauthenticationComponent,
                data: {
                    title: 'Factor Authentication',
                    urls: [
                        {
                            title: 'SMS',

                        },
                        {
                            title: 'Add 2FA Sms'
                        }
                    ]
                }
            },

            {
                path: 'factor-authentication/:id',
                component: FactorauthenticationComponent,
                data: {
                    title: 'Factor Authentication',
                    urls: [
                        {
                            title: 'SMS',

                        },
                        {
                            title: 'Edit 2FA Sms'
                        }
                    ]
                }
            },

            {
                path: 'factor-authentication-details',
                component: FactorauthenticationdetailsComponent,
                data: {
                    title: 'Factor Authentication Details',
                    urls: [
                        {
                            title: 'SMS',

                        },
                        {
                            title: 'SMS details'
                        }
                    ]
                }
            },


            //   {
            //     path: 'ip-whitelists',
            //     component: IpWhitelistsComponent,
            //     data: {
            //         title: 'SMS',
            //         urls: [
            //             {
            //                 title: 'SMS',
            //                 url: '/sms/ip-whitelists'
            //             },
            //             {
            //                 title: 'SMS IP Whitelists'
            //             }
            //         ]
            //     }
            // },

            // {
            //   path: 'sms-configuration',
            //   component: SmsConfigurationComponent,
            //   data: {
            //       title: 'SMS',
            //       urls: [
            //           {
            //               title: 'SMS',
            //               url: '/sms/sms-configuration'
            //           },
            //           {
            //               title: 'SMS Configuration'
            //           }
            //       ]
            //   }
            // },

        ]
    }
];

@NgModule({
    imports: [RouterModule.forChild(routes)],
    exports: [RouterModule]
})
export class SmsRoutingModule { }
