
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
// sms : ip_address last_octet
export interface ip
{
    ip_address:string,
    last_octet:string,
}

export interface HTTPip
{
    ip_address:string,
    last_octet:string,
}

export class ipForm implements HTTPip
{
   public ip_address:string;
   public last_octet:string;
   
    constructor(data : ipForm) 
    {
        if(data==null)
        {        
           this.ip_address="";
           this.last_octet="";
        }
        else
        {         
            this.ip_address = data.ip_address;
            this.last_octet = data.last_octet;
        }
    }

    public makeform(fb:FormBuilder):FormGroup
    {
        return fb.group({          
            ip_address:[this.ip_address, [Validators.required]],
            last_octet:[this.last_octet, [Validators.required]],
        });
    }

    public saveForm(fg:FormGroup):boolean
    {
        if(fg.valid)
        {          
            this.ip_address=  fg.get("ip_address").value;
            this.last_octet=  fg.get("last_octet").value;
            return true;
        }
        else
        {
            return false;
        }
    }
  }


// sms : mdrs

export interface mdrs
{
    from_date:string,
    to_date:string,
    from_ani:string,
    to_did:string,
    call_id:string,
    result:string,
    status:string
}

export interface HTTPmdrs
{
    from_date:string,
    to_date:string,
    from_ani:string,
    to_did:string,
    call_id:string,
    result:string,
    status:string
}

export class mdrsForm implements HTTPmdrs
{
    from_date:string;
    to_date:string;
    from_ani:string;
    to_did:string;
    call_id:string;
    result:string;
    status:string
   
    constructor(data : mdrs) 
    {
        if(data==null)
        {        
           this.from_date="";
           this.to_date="";
           this.from_ani="";
           this.to_did="";
           this.call_id="";
           this.result="";
           this.status="";
        }
        else
        {         
            this.from_date = data.from_date;
            this.to_date = data.to_date;
            this.from_ani = data.from_ani;
            this.to_did = data.to_did;
            this.call_id = data.call_id;
            this.result = data.result;
            this.status = data.status;
        }
    }

    public makeform(fb:FormBuilder):FormGroup
    {
        return fb.group({          
            from_date:[this.from_date, [Validators.required]],
            to_date:[this.to_date, [Validators.required]],
            from_ani:[this.from_ani, [Validators.required]],
            to_did:[this.to_did ],
            call_id:[this.call_id, [Validators.required]],
            result:[this.result, [Validators.required]],
            status:[this.status, [Validators.required]]
        });
    }

    public saveForm(fg:FormGroup):boolean
    {
        if(fg.valid)
        {          
            this.from_date=  fg.get("from_date").value;
            this.to_date=  fg.get("to_date").value;
            this.from_ani=  fg.get("from_ani").value;
            this.to_did=  fg.get("to_did").value;
            this.call_id=  fg.get("call_id").value;
            this.result=  fg.get("result").value;
            this.status=  fg.get("status").value;
            return true;
        }
        else
        {
            return false;
        }
    }
  }




  // text Message

export interface textmessage
{
    FROM:string,
    TO:string,
    BODY:string,
    
}

export interface HTTPtextmessage
{
    FROM:string,
    TO:string,
    BODY:string,
}

export class testmessageForm implements HTTPtextmessage
{
    FROM:string;
    TO:string;
    BODY:string;
   
    constructor(data : textmessage) 
    {
        if(data==null)
        {        
           this.FROM="";
           this.TO="";
           this.BODY="";
           
        }
        else
        {         
            this.FROM = data.FROM;
            this.TO = data.TO;
            this.BODY = data.BODY;
            
        }
    }

    public makeform(fb:FormBuilder):FormGroup
    {
        return fb.group({          
            FROM:[this.FROM, [Validators.required]],
            TO:[this.TO, [Validators.required]],
            BODY:[this.BODY, [Validators.required]],
          
        });
    }

    public saveForm(fg:FormGroup):boolean
    {
        if(fg.valid)
        {          
            this.FROM=  fg.get("FROM").value;
            this.TO=  fg.get("TO").value;
            this.BODY=  fg.get("BODY").value;
          
            return true;
        }
        else
        {
            return false;
        }
    }
  }



  // sms : outboundsms

export interface outboundsms

{
    url:string,
    optionsRadios:string,
   
}

export interface HTTPoutboundsms
{
    url:string,
    optionsRadios:string,
}

export class outboundsmsForm implements HTTPoutboundsms
{
    url:string;
    optionsRadios:string;
   
    constructor(data : outboundsms) 
    {
        if(data==null)
        {        
           this.url="";
           this.optionsRadios="";
          
        }
        else
        {         
            this.url = data.url;
            this.optionsRadios = data.optionsRadios;
            
        }
    }

    public makeform(fb:FormBuilder):FormGroup
    {
        return fb.group({          
            url:[this.url, [Validators.required]],
            optionsRadios:[this.optionsRadios, [Validators.required]],
           
        });
    }

    public saveForm(fg:FormGroup):boolean
    {
        if(fg.valid)
        {          
            this.url=  fg.get("url").value;
            this.optionsRadios=  fg.get("optionsRadios").value;
          
            return true;
        }
        else
        {
            return false;
        }
    }
  }



  
  // sms : inboundsms

export interface inboundsms

{
    inboundurl:string,
    optionsRadio:string,
   
}

export interface HTTPinboundsms
{
    inboundurl:string,
    optionsRadio:string,
}

export class inboundsmsForm implements HTTPinboundsms
{
    inboundurl:string;
    optionsRadio:string;
   
    constructor(data : inboundsms) 
    {
        if(data==null)
        {        
           this.inboundurl="";
           this.optionsRadio="";
          
        }
        else
        {         
            this.inboundurl = data.inboundurl;
            this.optionsRadio = data.optionsRadio;
            
        }
    }

    public makeform(fb:FormBuilder):FormGroup
    {
        return fb.group({          
            inboundurl:[this.inboundurl, [Validators.required]],
            optionsRadio:[this.optionsRadio, [Validators.required]],
           
        });
    }

    public saveForm(fg:FormGroup):boolean
    {
        if(fg.valid)
        {          
            this.inboundurl=  fg.get("inboundurl").value;
            this.optionsRadio=  fg.get("optionsRadio").value;
          
            return true;
        }
        else
        {
            return false;
        }
    }
  }

