import { NgModule } from '@angular/core';
import { CommonModule, DatePipe } from '@angular/common';
import { ChartsModule } from 'ng2-charts';
import { SmsRoutingModule } from './sms-routing.module';
import { MdrsComponent } from './mdrs/mdrs.component';
import { TestmessageComponent } from './testmessage/testmessage.component';
import { IpWhitelistsComponent } from './ip-whitelists/ip-whitelists.component';
import { SmsConfigurationComponent } from './sms-configuration/sms-configuration.component';
import { ReactiveFormsModule } from '@angular/forms';
import { SmsService } from './sms.service';
import { Ng2SearchPipeModule } from 'ng2-search-filter';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { FormsModule } from '@angular/forms';
import { NgxPaginationModule } from 'ngx-pagination';
import { OutboundsmsComponent } from './outboundsms/outboundsms.component';
import { InboundsmsComponent } from './inboundsms/inboundsms.component';
import { DemoMaterialModule } from '../demo-material-module';
import { SharedModule } from '../shared/shared.module';
import { NgMultiSelectDropDownModule } from 'ng-multiselect-dropdown';
import { DateFilter } from './datefilter.pipe';
import { SmssettingComponent } from './smssetting/smssetting.component';
import { FloorDecimal3 } from './decimal.pipe';
import { FactorauthenticationdetailsComponent } from './factorauthenticationdetails/factorauthenticationdetails.component';
import { FactorauthenticationComponent } from './factorauthentication/factorauthentication.component';
import { AddfavoiceComponent } from './addfavoice/addfavoice.component';
import { FavoicedetailsComponent } from './favoicedetails/favoicedetails.component';
import { TimeFormatPipe } from './time-format.pipe';
import { OrderPipe } from './orderPipe.pipe';
import { MmsMDRComponent } from './mms-mdr/mms-mdr.component';


@NgModule({
  declarations: [MdrsComponent, TestmessageComponent, IpWhitelistsComponent, SmsConfigurationComponent, OutboundsmsComponent, InboundsmsComponent, DateFilter, SmssettingComponent, FloorDecimal3, FactorauthenticationdetailsComponent, FactorauthenticationComponent, AddfavoiceComponent, FavoicedetailsComponent, TimeFormatPipe, OrderPipe, MmsMDRComponent],
  imports: [
    CommonModule,
    SmsRoutingModule,
    ReactiveFormsModule,
    ChartsModule,
    NgbModule,
    Ng2SearchPipeModule,
    FormsModule,
    NgxPaginationModule,
    DemoMaterialModule,
    SharedModule,
    NgMultiSelectDropDownModule
  ],
  providers: [
    SmsService,
    DatePipe, OrderPipe
  ]
})
export class SmsModule { }
