import { tassign } from 'tassign'; 
export const UPDATE_PROFILE = 'PROFILE';
export const REFRESH_PROFILE = "REFRESH_PROFILE"
export const UPDATE_BALANCE = 'BALANCE';
export const REFRESH_BALANCE= 'REFRESH_BALANCE';
export const LOGIN_SETTING = 'LOGIN';

export interface IProfile {
    image: string;
    username: string;
    email: any;
    iduser: number,
    first_name: string,
    last_name: string,
    contact_number: number,
    password: any,
    balance:number
}

export const INITIAL_PROFILE: IProfile = { 
    iduser: 0,
    image: "",
    username: "",
    email: "",
    first_name: "",
    last_name: "",
    contact_number: 0,
    password: "",
    balance:0
}

export function ProfileReducer(state: IProfile, action): IProfile {
    switch(action.type)
    {
        case UPDATE_PROFILE:{
            let cur=tassign(state, {image:action.image, username: action.username, email: action.email, iduser: action.iduser, first_name: action.first_name, last_name: action.last_name, contact_number: action.contact_number, password: action.password,balance:state.balance});
            sessionStorage.setItem("Profile", JSON.stringify(cur));
            return cur;
        }
        case REFRESH_PROFILE:{
            let cur=tassign(state, {image:action.image, username: action.username, email: action.email, iduser: action.iduser, first_name: action.first_name, last_name: action.last_name, contact_number: action.contact_number, password: action.password, balance:state.balance});
            return cur;
        }
        case REFRESH_BALANCE:{
            let cur=tassign(state, {image:state.image, username: state.username, email: state.email, iduser: state.iduser, first_name: state.first_name, last_name: state.last_name, contact_number: state.contact_number, password: state.password, balance:action.balance});
            sessionStorage.setItem("Profile", JSON.stringify(cur));
            return cur;
        }
        case UPDATE_BALANCE:{
            let cur=tassign(state, {image:state.image, username: state.username, email: state.email, iduser: state.iduser, first_name: state.first_name, last_name: state.last_name, contact_number: state.contact_number, password: state.password,balance:state.balance+action.balance});
            sessionStorage.setItem("Profile", JSON.stringify(cur));
            return cur;
        }
        case LOGIN_SETTING:{
            let cur=tassign(state, {image:state.image, username: state.username, email: state.email, iduser: state.iduser, first_name: state.first_name, last_name: state.last_name, contact_number: state.contact_number, password: state.password,balance:state.balance+action.balance});
            sessionStorage.setItem("Profile", JSON.stringify(cur));
            return cur;
        }
        default:
        {
            let cur=sessionStorage.getItem("Profile");
            return tassign(state, JSON.parse(cur));
        }
    }
    return state;
}