import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { TariffService } from '../tariff.service';
declare var $:any;
@Component({
  selector: 'app-service',
  templateUrl: './service.component.html',
  styleUrls: ['./service.component.css']
})
export class ServiceComponent implements OnInit {
  searchText = { count: 0 };
	filtre: string;
  hide:boolean=true;
  tariffs: any;
  page = 1;
	count = 0;
	tableSize = 50;
	tableSizes = [50, 100, 150];
  filterTerm: string;
	row: any;
  responseMessage = "";
  errMessage: any = "";
  preferenceServices: any = [];

  constructor(private data: UsermanagementService,
              private tariffService: TariffService,
              private fb: FormBuilder ) { }

  ngOnInit(): void {
      this.tariffService.getPreferenceService().subscribe(res => {
        this.preferenceServices = res.data;        
        $('#basic-datatables').DataTable().clear();
				$('#basic-datatables').DataTable().destroy();
        $.getScript('./assets/table.js');
      }, err => {
          console.log(err);
      })
  }

  setAsDefaultService(idservice,iduser) {
		let data = idservice+ '-' + iduser;    
    this.tariffService.setDefault(data).subscribe((res) => {
			if (res.status == 201) {
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
				this.ngOnInit();
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}


  deleteService(idservice){
    if(confirm("Are you sure you want delete data!")){
      this.tariffService.deletePreferenceService(idservice).subscribe(res => {
        this.responseMessage = res.message;
        setTimeout(()=>{
          this.responseMessage= "";
        }, 5000);
        this.ngOnInit();
      }, err => {
        this.responseMessage = err.message;
        setTimeout( () => {
          this.responseMessage = "";
        }, 5000)
      })
    }else{
      "Cancel!";
    }
  }


}
