import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, ParamMap } from '@angular/router';
import { Observable } from 'rxjs';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { environment } from 'src/environments/environment';
import { TariffService } from '../tariff.service';
declare var $: any;

@Component({
  selector: 'app-surcharge',
  templateUrl: './surcharge.component.html',
  styleUrls: ['./surcharge.component.css']
})
export class SurchargeComponent implements OnInit {
  searchText = { count: 0 };
  filtre: string;
  page = 1;
  count = 0;
  tableSize = 50;
  tableSizes = [50, 100, 150];
  filterTerm: string;
  responseMessage = "";
  errMessage = "";
  resAlertMessage = "";
  surcharges: any = [];
  surchargeForm: FormGroup;
  surchargeData: any = [];
  public submitted: boolean = false;
  dName: any;
  constructor(private data: UsermanagementService, private fb: FormBuilder,
    private tariffService: TariffService, private route: ActivatedRoute) {
  }

  ngOnInit(): void {
    this.surchargeForm = this.fb.group({
      idsurcharge: ['', [Validators.required]],
      name: ['', [Validators.required]],
      description: ['', [Validators.required]],
    });
    
    this.getSurchargeList();
  }

  getSurchargeList(){
    this.tariffService.getSurcharge().subscribe(res => {
      if(res.status == 200){
        this.surcharges = res.data;
        $.getScript('./assets/table.js');
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  deleteSurcharge(idsurcharge) {
    this.tariffService.deleteSurcharge(idsurcharge).subscribe(res => {
      if(res.status == 200){
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
        this.ngOnInit();
      }
      else{
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
      
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    })
  }
  onSurcharge(data: any) {
    this.dName = data.name
    this.surchargeForm.patchValue({
      idsurcharge:data.idsurcharge,
      name:data.name,
      description:data.description
    })
  }

  editSercharge() {
    this.submitted = false;
    if(this.surchargeForm.invalid){
      this.submitted = true;
      return true;
    }
    else{
      this.tariffService.editSurcharge(this.surchargeForm.value).subscribe(res => {
        if(res.status == 201){
          document.getElementById("closeModal").click();
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
          this.getSurchargeList();
        }  
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }      
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      })
    }
  }
  resetModal(){
    this.submitted = false;
  }
}
