import { Component, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { MatAccordion } from '@angular/material/expansion';
import { MatSlideToggleChange } from '@angular/material/slide-toggle';
import { ActivatedRoute, ParamMap } from '@angular/router';
import { TariffService } from '../../tariff.service';

@Component({
	selector: 'app-clonetariff',
	templateUrl: './clonetariff.component.html',
	styleUrls: ['./clonetariff.component.css']
})
export class ClonetariffComponent implements OnInit {

	@ViewChild(MatAccordion) accordion: MatAccordion;
	rowdata: any;
	filterTerm: string
	count = 0;
	tableSize: any;
	page: number;
	headerdetails: any;
	tariffForm: FormGroup;
	addedTariff: any;
	resAlertMessage = "";
	responseMessage: any = "";
	submitted: boolean = false;
	status: boolean = false;
	idtariff: any;
	voiceApiForm: FormGroup;
	headerApi: any;
	voiceApiFields: any;
	iVoiceHeader: any;
	iVoiceFields: any;
	iVoiceForm: any;
	numberPriceForm: FormGroup;
	numberFields: any;
	numberHeader: any;
	depthFields: any;
	depthHeader: any;
	depthForm: FormGroup;
	sipForm: FormGroup;
	sipFields: any;
	sipHeader: any;
	iSipHeader: any;
	iSipFields: any;
	iSipForm: FormGroup;
	sipNumberForm: FormGroup;
	sipNumberFields: any;
	sipNumberHeader: any;
	depthSipForm: FormGroup;
	depthSipHeader: any;
	depthSipFields: any;
	msgActForm: FormGroup;
	msgFields: any;
	msgHeader: any;
	smsHeader: any;
	smsFields: any;
	smsRateForm: FormGroup;
	tariffName: any;
	rateType: Boolean = false;
	voiceApiForm1: FormGroup;
	iVoiceForm1: FormGroup;
	numberPriceForm1: FormGroup;
	depthForm1: FormGroup;
	sipForm1: FormGroup;
	iSipForm1: FormGroup;
	sipNumberForm1: FormGroup;
	depthSipForm1: FormGroup;
	smsRateForm1: FormGroup;
	msgActForm1: FormGroup;
	public ifregistered: String = "";
	oldidtariff: any;
	dayUpdate: FormGroup;
	tariffData: any;
	tariffDayNum: number;
	proration: any;
	errMessage: any;
	acccordian: boolean = false;
	lookupFields: any;
	lookupForm: FormGroup;
	lookupHeader: any;
	campaignReviewForm: FormGroup;
	campaignReviewFields: any =[];
	campaignReviewHeader: any;
	activateheader: any;
	activateFields: any;
	activatemsgForm: FormGroup;
	activatemsgForm1: FormGroup;

	constructor(private fb: FormBuilder, private data: TariffService, private tariffService: TariffService, private route: ActivatedRoute) { }

	ngOnInit(): void {

		this.dayUpdate = this.fb.group({
			day_num: new FormControl("", [Validators.required]),
			idtariff: ['', [Validators.required]]
		});

		this.route.paramMap.subscribe((params: ParamMap) => {
			this.idtariff = params.get('id');
			this.tariffService.getTariff(this.idtariff).subscribe(res => {
				this.tariffData = res.data[0];
				this.tariffName = res.data[0].name;
				this.tariffDayNum = res.data[0].day_num;
				this.proration = res.data[0].proration;

				this.dayUpdate.patchValue({
					day_num: this.tariffDayNum,
					idtariff: this.idtariff,
				});

			});
		});

		this.tariffForm = this.fb.group({
			id: [''],
			name: ['', [Validators.required, Validators.minLength(3)]],
			description: ['', [Validators.required, Validators.minLength(10)]],
		});

		this.route.paramMap.subscribe((params: ParamMap) => {
			this.idtariff = params.get('id');
			this.tariffService.getTariff(this.idtariff).subscribe(res => {
				this.tariffName = res.data[0].name;

				this.tariffForm.patchValue({
					id: res.data[0].idtariff,
					name: res.data[0].name,
					description: res.data[0].description
				});
				this.oldidtariff = this.idtariff;
			})
		});

		this.tariffService.get_voiceapi().subscribe(res => {
			this.headerApi = res[0].header;
			this.voiceApiFields = res[0].fields;
			let voiceApiField = [];
			this.voiceApiFields.forEach(element => {
				voiceApiField["priority_" + element.priority] = [element.priority],
					voiceApiField["idtariff_" + element.priority] = [this.idtariff],
					voiceApiField["type_" + element.priority] = ["voice"],
					voiceApiField["subtype_" + element.priority] = ["voice_api"],
					voiceApiField["category_" + element.priority] = [element.categoryValue],
					voiceApiField["mo_" + element.priority] = [0],
					voiceApiField["mt_" + element.priority] = [0]
			});
			this.voiceApiForm = this.fb.group(voiceApiField);

			this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "voice", subtype: "voice_api" }).subscribe(res => {
				// this.voiceApiFields = res.data;
				let tmp = [];
				res.data.forEach(element => {
					tmp["idrates_" + element.priority] = [element.idrates],
						tmp["category_" + element.priority] = [element.category],
						tmp["mo_" + element.priority] = [element.mo],
						tmp["mt_" + element.priority] = [element.mt]
				});

				this.voiceApiForm = this.fb.group(tmp);
			});


			this.iVoiceHeader = res[1].header1;
			this.iVoiceFields = res[1].fields1;
			let iVoiceFields1$ = [];
			this.iVoiceFields.forEach(element => {
				iVoiceFields1$["priority_" + element.priority] = [element.priority],
					iVoiceFields1$["idtariff_" + element.priority] = [this.idtariff],
					iVoiceFields1$["type_" + element.priority] = ["voice"],
					iVoiceFields1$["subtype_" + element.priority] = ["inteligent"],
					iVoiceFields1$["category_" + element.priority] = [element.categoryValue],
					iVoiceFields1$["price_" + element.priority] = [0]
			});
			this.iVoiceForm = this.fb.group(iVoiceFields1$);

			this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "voice", subtype: "inteligent" }).subscribe(res => {
				// this.voiceApiFields = res.data;
				let tmp = [];
				res.data.forEach(element => {
					tmp["idrates_" + element.priority] = [element.idrates],
						tmp["category_" + element.priority] = [element.category],
						tmp["price_" + element.priority] = [element.rate]
					// tmp["mt_"+element.priority]=[element.mt]
				});

				this.iVoiceForm = this.fb.group(tmp);

			});

			this.numberHeader = res[2].header2;
			this.numberFields = res[2].fields2;
			let numberFields$ = [];
			this.numberFields.forEach(element => {
				numberFields$["priority_" + element.priority] = [element.priority],
					numberFields$["idtariff_" + element.priority] = [this.idtariff],
					numberFields$["type_" + element.priority] = ["voice"],
					numberFields$["subtype_" + element.priority] = ["number"],
					numberFields$["category_" + element.priority] = [element.categoryValue],
					numberFields$["price_" + element.priority] = [0]
			});
			this.numberPriceForm = this.fb.group(numberFields$);

			this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "voice", subtype: "number" }).subscribe(res => {
				let tmp = [];
				res.data.forEach(element => {
					tmp["idrates_" + element.priority] = [element.idrates],
						tmp["category_" + element.priority] = [element.category],
						tmp["price_" + element.priority] = [element.rate]
				});

				this.numberPriceForm = this.fb.group(tmp);
			});

			this.depthHeader = res[3].header3;
			this.depthFields = res[3].fields3;
			let depthFields$ = [];
			this.depthFields.forEach(element => {
				depthFields$["priority_" + element.priority] = [element.priority],
					depthFields$["idtariff_" + element.priority] = [this.idtariff],
					depthFields$["type_" + element.priority] = ["voice"],
					depthFields$["subtype_" + element.priority] = ["depth_voice"],
					depthFields$["category_" + element.priority] = [element.categoryValue],
					depthFields$["mo_" + element.priority] = [0],
					depthFields$["mt_" + element.priority] = [0]
			});
			this.depthForm = this.fb.group(depthFields$);

			this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "voice", subtype: "depth_voice" }).subscribe(res => {
				let tmp = [];
				res.data.forEach(element => {
					tmp["idrates_" + element.priority] = [element.idrates],
						tmp["category_" + element.priority] = [element.category],
						tmp["mo_" + element.priority] = [element.mo],
						tmp["mt_" + element.priority] = [element.mt]
				});

				this.depthForm = this.fb.group(tmp);
			});
		});

		this.tariffService.get_elasticSip().subscribe(res => {
			this.sipFields = res[0].fields;
			this.sipHeader = res[0].header;
			let sipFields$ = [];
			this.sipFields.forEach(element => {
				sipFields$["priority_" + element.priority] = [element.priority],
					sipFields$["idtariff_" + element.priority] = [this.idtariff],
					sipFields$["type_" + element.priority] = ["elastic"],
					sipFields$["subtype_" + element.priority] = ["sip_trunking"],
					sipFields$["category_" + element.priority] = [element.categoryValue],
					sipFields$["mo_" + element.priority] = [0],
					sipFields$["mt_" + element.priority] = [0]
			});
			this.sipForm = this.fb.group(sipFields$);

			this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "elastic", subtype: "sip_trunking" }).subscribe(res => {
				let tmp = [];
				res.data.forEach(element => {
					tmp["idrates_" + element.priority] = [element.idrates],
						tmp["category_" + element.priority] = [element.category],
						tmp["mo_" + element.priority] = [element.mo],
						tmp["mt_" + element.priority] = [element.mt]
				});

				this.sipForm = this.fb.group(tmp);
			});

			this.iSipFields = res[1].fields1;
			this.iSipHeader = res[1].header1;
			let iSipFields$ = [];
			this.iSipFields.forEach(element => {
				iSipFields$["priority_" + element.priority] = [element.priority],
					iSipFields$["idtariff_" + element.priority] = [this.idtariff],
					iSipFields$["type_" + element.priority] = ["elastic"],
					iSipFields$["subtype_" + element.priority] = ["inteligent"],
					iSipFields$["category_" + element.priority] = [element.categoryValue],
					iSipFields$["price_" + element.priority] = [0]
			});
			this.iSipForm = this.fb.group(iSipFields$);

			this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "elastic", subtype: "inteligent" }).subscribe(res => {
				let tmp = [];
				res.data.forEach(element => {
					tmp["idrates_" + element.priority] = [element.idrates],
						tmp["category_" + element.priority] = [element.category],
						tmp["price_" + element.priority] = [element.rate]
				});

				this.iSipForm = this.fb.group(tmp);
			});

			this.sipNumberFields = res[2].fields2;
			this.sipNumberHeader = res[2].header2;
			let sipNumberFields$ = [];
			this.sipNumberFields.forEach(element => {
				sipNumberFields$["priority_" + element.priority] = [element.priority],
					sipNumberFields$["idtariff_" + element.priority] = [this.idtariff],
					sipNumberFields$["type_" + element.priority] = ["elastic"],
					sipNumberFields$["subtype_" + element.priority] = ["number"],
					sipNumberFields$["category_" + element.priority] = [element.categoryValue],
					sipNumberFields$["price_" + element.priority] = [0]
			});
			this.sipNumberForm = this.fb.group(sipNumberFields$);

			this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "elastic", subtype: "number" }).subscribe(res => {
				let tmp = [];
				res.data.forEach(element => {
					tmp["idrates_" + element.priority] = [element.idrates],
						tmp["category_" + element.priority] = [element.category],
						tmp["price_" + element.priority] = [element.rate]
				});

				this.sipNumberForm = this.fb.group(tmp);
			});

			this.depthSipFields = res[3].fields3;
			this.depthSipHeader = res[3].header3;
			let depthSipFields$ = [];
			this.depthSipFields.forEach(element => {
				depthSipFields$["priority_" + element.priority] = [element.priority],
					depthSipFields$["idtariff_" + element.priority] = [this.idtariff],
					depthSipFields$["type_" + element.priority] = ["elastic"],
					depthSipFields$["subtype_" + element.priority] = ["depth_voice"],
					depthSipFields$["category_" + element.priority] = [element.categoryValue],
					depthSipFields$["mo_" + element.priority] = [0],
					depthSipFields$["mt_" + element.priority] = [0]
			});
			this.depthSipForm = this.fb.group(depthSipFields$);

			this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "elastic", subtype: "depth_voice" }).subscribe(res => {
				let tmp = [];
				res.data.forEach(element => {
					tmp["idrates_" + element.priority] = [element.idrates],
						tmp["category_" + element.priority] = [element.category],
						tmp["mo_" + element.priority] = [element.mo],
						tmp["mt_" + element.priority] = [element.mt]
				});

				this.depthSipForm = this.fb.group(tmp);
			});
		});

		this.tariffService.get_MessagePricing().subscribe(res => {

			this.smsHeader = res[5].header5;
			this.smsFields = res[5].fields5;

			let tmp = [];
			this.smsFields.forEach(element => {
				tmp["priority_" + element.priority] = [element.priority],
					tmp["idtariff_" + element.priority] = [this.idtariff],
					tmp["category_" + element.priority] = [element.categoryValue],
					tmp["categoryValue_" + element.priority] = [element.category],
					tmp["subCategory_" + element.priority] = [element.SubCategory],
					tmp["type_" + element.priority] = ["unregistered"],
					tmp["MO_" + element.priority] = [0],
					tmp["MT_" + element.priority] = [0]
			});
			this.smsRateForm = this.fb.group(tmp);

			this.tariffService.GetSmsRate({ idtariff: this.idtariff, type: "unregistered" }).subscribe(res => {
				let tmp = [];
				res.data.forEach(element => {
					tmp["idsmsrate_" + element.priority] = [element.idsmsrate],
						tmp["category_" + element.priority] = [element.category],
						tmp["MO_" + element.priority] = [element.MO_rates],
						tmp["MT_" + element.priority] = [element.MT_rates]
				});
				this.smsRateForm = this.fb.group(tmp);
			});

			this.msgHeader = res[1].header1;
			this.msgFields = res[1].fields1;
			let msgFields$ = [];
			this.msgFields.forEach(element => {
				msgFields$["priority_" + element.priority] = [element.priority],
					msgFields$["idtariff_" + element.priority] = [this.idtariff],
					msgFields$["type_" + element.priority] = ["message"],
					msgFields$["subtype_" + element.priority] = ["message_activation"],
					msgFields$["category_" + element.priority] = [element.categoryValue],
					msgFields$["price_" + element.priority] = [0],
					//msgFields$["rateType_"+element.priority] = [this.rateType],
					msgFields$["mo_" + element.priority] = [0],
					msgFields$["mt_" + element.priority] = [0]
			});
			this.msgActForm = this.fb.group(msgFields$);
			this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "message", subtype: "message_activation" }).subscribe(res => {
					let tmp = [];
					res.data.forEach(element => {
						this.rateType = element.rateType;
						tmp["idrates_" + element.priority] = [element.idrates],
							tmp["category_" + element.priority] = [element.category],
							tmp["price_" + element.priority] = [element.rate],
							//tmp["rateType_"+element.priority]= [element.rateType];
							tmp["mo_" + element.priority] = [element.mo],
							tmp["mt_" + element.priority] = [element.mt]
					});
					this.msgActForm = this.fb.group(tmp);
				});			
		});

		/*FOR ACTIVATION MESSAGE PRICING */
		this.tariffService.get_activateMsg().subscribe(res => {
			this.activateheader = res[0].header;
			this.activateFields = res[0].fields;
			let activateField = [];
			this.activateFields.forEach(element => {
				activateField["priority_" + element.priority] = [element.priority],
					activateField["idtariff_" + element.priority] = [this.idtariff],
					activateField["type_" + element.priority] = ["message_activation"],
					activateField["category_" + element.priority] = [element.categoryValue],
					activateField["mrc_" + element.priority] = [0],
					activateField["nrc_" + element.priority] = [0]
			});
			this.activatemsgForm = this.fb.group(activateField);

			this.tariffService.getactivate_msg({ idtariff: this.idtariff, type: "message_activation" }).subscribe(res => {
				let tmp = [];
				res.data.forEach(element => {
					// tmp["idratesnew_" + element.priority] = undefined,
						tmp["idrates_" + element.priority] = [element.idrates],
						tmp["category_" + element.priority] = [element.category],
						tmp["mrc_" + element.priority] = [element.mrc],
						tmp["nrc_" + element.priority] = [element.nrc]
				});
				this.activatemsgForm = this.fb.group(tmp);
			});

		});

	 

		this.tariffService.get_lookuprates().subscribe(res => {
			this.lookupHeader = res[0].header;
			this.lookupFields = res[0].fields;
			let lookuptmp = [];
			this.lookupFields.forEach(element => {
				lookuptmp["priority_" + element.priority] = [element.priority],
					lookuptmp["idtariff_" + element.priority] = [this.idtariff],
					lookuptmp["category_" + element.priority] = [element.category],
					lookuptmp["categoryValue_" + element.priority] = [element.categoryValue],
					lookuptmp["type_" + element.priority] = ["lookup"],
					lookuptmp["price_" + element.priority] = [0]
			});
			this.lookupForm = this.fb.group(lookuptmp);

			     // campaign review rates 
				 this.campaignReviewHeader = res[1].headers1;
				 this.campaignReviewFields = res[1].fields1;
				 let campaignReviewtmp = [];
				 this.campaignReviewFields.forEach(element => {
					 campaignReviewtmp["priority_" + element.priority] = [element.priority],
					 campaignReviewtmp["idtariff_" + element.priority] = [this.idtariff],
					 campaignReviewtmp["category_" + element.priority] = [element.category],
					 campaignReviewtmp["type_" + element.priority] = ["campaign"],
					 campaignReviewtmp["price_" + element.priority] = [0]
				 });
				 this.campaignReviewForm = this.fb.group(campaignReviewtmp);
		});

		this.tariffService.lookupRates({ idtariff: this.idtariff, type: "lookup" }).subscribe(res => {
			let tmp = [];
			res.data.forEach(element => {
				tmp["idrates_" + element.priority] = [element.idrates],
					tmp["category_" + element.priority] = [element.category],
					tmp["price_" + element.priority] = [element.rate]
			});

			this.lookupForm = this.fb.group(tmp);
		});

		this.tariffService.campaignReviewRates({ idtariff: this.idtariff, type: "campaign"}).subscribe(res => {      
			let tmp = [];
			res.data.forEach(element => {
				tmp["idrates_" + element.priority] = [element.campaign_rate_id],
				tmp["category_" + element.priority] = [element.category],
				tmp["price_" + element.priority] = [element.rate]
			});
	  
			this.campaignReviewForm = this.fb.group(tmp);
		  });
	}
	copyTariff() {

		this.submitted = true;
		if (this.tariffForm.invalid) {
			return false;
		}
		else {
			this.tariffService.copyTariff(this.tariffForm.value).subscribe(res => {

				if (res.data[0]) {
					this.addedTariff = res.data[0].name;
					this.idtariff = res.data[0].idtariff;
					this.status = true;
					this.acccordian = true;
					this.tariffService.getUnregisteredRate({ idtariff: this.oldidtariff, type: "voice", subtype: "voice_api" }).subscribe(res => {
						// this.voiceApiFields = res.data;
						let tmp = [];
						res.data.forEach(element => {
							tmp["idrates_" + element.priority] = [element.idrates],
								tmp["category_" + element.priority] = [element.category],
								tmp["mo_" + element.priority] = [element.mo],
								tmp["mt_" + element.priority] = [element.mt]
						});
						this.voiceApiForm = this.fb.group(tmp);

					});
					this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "voice", subtype: "voice_api" }).subscribe(res => {
						let tmp = [];
						res.data.forEach(element => {
							tmp["idratesnew_" + element.priority] = [element.idrates]
						});
						this.voiceApiForm1 = this.fb.group(tmp);
					});


					this.tariffService.getUnregisteredRate({ idtariff: this.oldidtariff, type: "voice", subtype: "inteligent" }).subscribe(res => {
						// this.voiceApiFields = res.data;
						let tmp = [];
						res.data.forEach(element => {
							tmp["idrates_" + element.priority] = [element.idrates],
								tmp["category_" + element.priority] = [element.category],
								tmp["price_" + element.priority] = [element.rate]
							// tmp["mt_"+element.priority]=[element.mt]
						});
						this.iVoiceForm = this.fb.group(tmp);

					});
					this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "voice", subtype: "inteligent" }).subscribe(res => {
						// this.voiceApiFields = res.data;
						let tmp = [];
						res.data.forEach(element => {
							tmp["idratesnew_" + element.priority] = [element.idrates]
						});
						this.iVoiceForm1 = this.fb.group(tmp);
					});

					this.tariffService.getUnregisteredRate({ idtariff: this.oldidtariff, type: "voice", subtype: "number" }).subscribe(res => {
						let tmp = [];
						res.data.forEach(element => {
							tmp["idrates_" + element.priority] = [element.idrates],
								tmp["category_" + element.priority] = [element.category],
								tmp["price_" + element.priority] = [element.rate]
						});

						this.numberPriceForm = this.fb.group(tmp);
					});
					this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "voice", subtype: "number" }).subscribe(res => {
						let tmp = [];
						res.data.forEach(element => {
							tmp["idratesnew_" + element.priority] = [element.idrates]
						});

						this.numberPriceForm1 = this.fb.group(tmp);
					});

					this.tariffService.getUnregisteredRate({ idtariff: this.oldidtariff, type: "voice", subtype: "depth_voice" }).subscribe(res => {
						let tmp = [];
						res.data.forEach(element => {
							tmp["idrates_" + element.priority] = [element.idrates],
								tmp["category_" + element.priority] = [element.category],
								tmp["mo_" + element.priority] = [element.mo],
								tmp["mt_" + element.priority] = [element.mt]
						});

						this.depthForm = this.fb.group(tmp);
					});
					this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "voice", subtype: "depth_voice" }).subscribe(res => {
						let tmp = [];
						res.data.forEach(element => {
							tmp["idratesnew_" + element.priority] = [element.idrates]
						});

						this.depthForm1 = this.fb.group(tmp);
					});

					this.tariffService.getUnregisteredRate({ idtariff: this.oldidtariff, type: "elastic", subtype: "sip_trunking" }).subscribe(res => {
						let tmp = [];
						res.data.forEach(element => {
							tmp["idrates_" + element.priority] = [element.idrates],
								tmp["category_" + element.priority] = [element.category],
								tmp["mo_" + element.priority] = [element.mo],
								tmp["mt_" + element.priority] = [element.mt]
						});

						this.sipForm = this.fb.group(tmp);
					});
					this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "elastic", subtype: "sip_trunking" }).subscribe(res => {
						let tmp = [];
						res.data.forEach(element => {
							tmp["idratesnew_" + element.priority] = [element.idrates]
						});

						this.sipForm1 = this.fb.group(tmp);
					});

					this.tariffService.getUnregisteredRate({ idtariff: this.oldidtariff, type: "elastic", subtype: "inteligent" }).subscribe(res => {
						let tmp = [];
						res.data.forEach(element => {
							tmp["idrates_" + element.priority] = [element.idrates],
								tmp["category_" + element.priority] = [element.category],
								tmp["price_" + element.priority] = [element.rate]
						});
						this.iSipForm = this.fb.group(tmp);
					});
					this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "elastic", subtype: "inteligent" }).subscribe(res => {
						let tmp = [];
						res.data.forEach(element => {
							tmp["idratesnew_" + element.priority] = [element.idrates]
						});
						this.iSipForm1 = this.fb.group(tmp);
					});

					this.tariffService.getUnregisteredRate({ idtariff: this.oldidtariff, type: "elastic", subtype: "number" }).subscribe(res => {
						let tmp = [];
						res.data.forEach(element => {
							tmp["idrates_" + element.priority] = [element.idrates],
								tmp["category_" + element.priority] = [element.category],
								tmp["price_" + element.priority] = [element.rate]
						});

						this.sipNumberForm = this.fb.group(tmp);
					});
					this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "elastic", subtype: "number" }).subscribe(res => {
						let tmp = [];
						res.data.forEach(element => {
							tmp["idratesnew_" + element.priority] = [element.idrates]
						});

						this.sipNumberForm1 = this.fb.group(tmp);
					});

					this.tariffService.getUnregisteredRate({ idtariff: this.oldidtariff, type: "elastic", subtype: "depth_voice" }).subscribe(res => {
						let tmp = [];
						res.data.forEach(element => {
							tmp["idrates_" + element.priority] = [element.idrates],
								tmp["category_" + element.priority] = [element.category],
								tmp["mo_" + element.priority] = [element.mo],
								tmp["mt_" + element.priority] = [element.mt]
						});

						this.depthSipForm = this.fb.group(tmp);
					});
					this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "elastic", subtype: "depth_voice" }).subscribe(res => {
						let tmp = [];
						res.data.forEach(element => {
							tmp["idratesnew_" + element.priority] = [element.idrates]
						});

						this.depthSipForm1 = this.fb.group(tmp);
					});

					this.tariffService.GetSmsRate({ idtariff: this.oldidtariff, type: "unregistered" }).subscribe(res => {
						let tmp = [];
						res.data.forEach(element => {
							tmp["idsmsrate_" + element.priority] = [element.idsmsrate],
								tmp["category_" + element.priority] = [element.category],
								tmp["MO_" + element.priority] = [element.MO_rates],
								tmp["MT_" + element.priority] = [element.MT_rates]
						});
						this.smsRateForm = this.fb.group(tmp);
					});
					this.tariffService.GetSmsRate({ idtariff: this.idtariff, type: "unregistered" }).subscribe(res => {
						let tmp = [];
						res.data.forEach(element => {
							tmp["idsmsratenew_" + element.priority] = [element.idsmsrate]
						});
						this.smsRateForm1 = this.fb.group(tmp);
					});

					this.tariffService.getUnregisteredRate({ idtariff: this.oldidtariff, type: "message", subtype: "message_activation" }).subscribe(res => {
						let tmp = [];
						res.data.forEach(element => {
							tmp["idrates_" + element.priority] = [element.idrates],
								tmp["category_" + element.priority] = [element.category],
								tmp["price_" + element.priority] = [element.rate],
								tmp["mo_" + element.priority] = [element.mo],
								tmp["mt_" + element.priority] = [element.mt]
						});
						this.msgActForm = this.fb.group(tmp);
					});
					this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "message", subtype: "message_activation" }).subscribe(res => {
						let tmp = [];
						res.data.forEach(element => {
							tmp["idratesnew_" + element.priority] = [element.idrates]
						});
						this.msgActForm1 = this.fb.group(tmp);
					});

					/*for activate msg */
					this.tariffService.getactivate_msg({ idtariff: this.oldidtariff, type: "message_activation" }).subscribe(res => {
						let tmp = [];
						res.data.forEach(element => {
							tmp["idrates_" + element.priority] = [element.idrates],
								tmp["category_" + element.priority] = [element.category],
								tmp["mrc_" + element.priority] = [element.mrc],
								tmp["nrc_" + element.priority] = [element.nrc]
						});
						this.activatemsgForm = this.fb.group(tmp);
					});
					this.tariffService.getactivate_msg({ idtariff: this.idtariff, type: "message_activation" }).subscribe(res => {
						let tmp = [];
						res.data.forEach(element => {
							tmp["idrates_" + element.priority] = [element.idrates]
						});
						this.activatemsgForm1 = this.fb.group(tmp);
					});

					/*closed here activate msg*/

					this.tariffService.lookupRates({ idtariff: this.idtariff, type: "lookup" }).subscribe(res => {
						let tmp = [];
						res.data.forEach(element => {
							tmp["idrates_" + element.priority] = [element.idrates],
								tmp["category_" + element.priority] = [element.category],
								tmp["price_" + element.priority] = [element.rate]
						});

						this.lookupForm = this.fb.group(tmp);
					});

					this.tariffService.campaignReviewRates({ idtariff: this.idtariff, type: "campaign"}).subscribe(res => {      
					let tmp = [];
					res.data.forEach(element => {
						tmp["idrates_" + element.priority] = [element.campaign_rate_id],
						tmp["category_" + element.priority] = [element.category],
						tmp["price_" + element.priority] = [element.rate]
					});
					 this.campaignReviewForm = this.fb.group(tmp);
					});


					this.responseMessage = res.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
					this.ifregistered = '1';
					//return this.oldidtariff = res.data[0].idtariff;
				}
				else {
					this.resAlertMessage = res.message;
					setTimeout(() => {
						this.resAlertMessage = "";
					}, 5000);
				}
			});

		}
	}
	onRateTypes(e) {
		this.rateType = e.target.checked;
	}
	updateDays(value: any) {
		this.tariffService.updateTariffDay({ day_num: value, idtariff: this.idtariff }).subscribe(response => {
			if (response.status == 201) {
				this.responseMessage = response.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
				this.dayUpdate.patchValue({
					day_num: value
				});
				//this.ngOnInit();
			}
			else {
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}
	onProRate(e: MatSlideToggleChange) {
		let proration: any;
		if (e.checked) {
			proration = 'true';
		}
		else {
			proration = 'false';
		}
		this.tariffService.updateProRate({ proration: proration, idtariff: this.idtariff }).subscribe(response => {
			if (response.status == 201) {
				this.responseMessage = response.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
				//this.ngOnInit();
			}
			else {
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});

	}
	onVoiceApi() {
		let response: any = [];
		response[0] = [];
		response[1] = [];
		response[2] = [];
		response[3] = [];
		response[4] = [];
		for (let key of Object.keys(this.voiceApiForm.value)) {
			let tmp = key.split('_');
			response[tmp[1]].push({ field: tmp[0], value: this.voiceApiForm.value[key] });
		}
		if (this.voiceApiForm1.value !== '') {
			for (let key of Object.keys(this.voiceApiForm1.value)) {
				let tmp = key.split('_');
				response[tmp[1]].push({ field: tmp[0], value: this.voiceApiForm1.value[key] });
			}
		}
		let temp = response.slice(1, 4);
		this.tariffService.updateVoiceRate(temp).subscribe(resp => {
			this.responseMessage = resp.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		}, err => {
			this.responseMessage = err.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});
	}

	oniVoice() {
		let response: any = [];
		response[0] = [];
		response[1] = [];
		response[2] = [];
		response[3] = [];
		response[4] = [];
		response[5] = [];
		response[6] = [];

		for (let key of Object.keys(this.iVoiceForm.value)) {
			let tmp = key.split('_');
			response[tmp[1]].push({ field: tmp[0], value: this.iVoiceForm.value[key] });
		}
		if (this.iVoiceForm1.value !== '') {
			for (let key of Object.keys(this.iVoiceForm1.value)) {
				let tmp = key.split('_');
				response[tmp[1]].push({ field: tmp[0], value: this.iVoiceForm1.value[key] });
			}
		}
		let temp = response.slice(1, 6);
		this.tariffService.updateVoiceRate(temp).subscribe(resp => {
			this.responseMessage = resp.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		}, err => {
			this.responseMessage = err.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});
	}

	onlookup() {
		let response: any = [];
		response[0] = [];
		response[1] = [];
		response[2] = [];
		for (let key of Object.keys(this.lookupForm.value)) {
			let tmp = key.split('_');
			response[tmp[1]].push({ field: tmp[0], value: this.lookupForm.value[key] });
		}
		let temp = response.slice(1, 6);
		this.tariffService.updatelookupRate(temp).subscribe(resp => {
			this.responseMessage = resp.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		}, err => {
			this.responseMessage = err.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});
	}
	oncampaignReviewForm() {
		let response: any = [];
		response[0] = [];
		response[1] = [];
		for (let key of Object.keys(this.campaignReviewForm.value)) {
		  let tmp = key.split('_');
		  response[tmp[1]].push({ field: tmp[0], value: this.campaignReviewForm.value[key] });
		}
		let temp = response.slice(1, 6)
		this.tariffService.updateCampaignReviewRate(temp).subscribe(resp => {
		  this.responseMessage = resp.message;
		  setTimeout(() => {
			this.responseMessage = "";
		  }, 5000);
		}, err => {
		  this.responseMessage = err.message;
		  setTimeout(() => {
			this.responseMessage = "";
		  }, 5000);
		});
	  }
	onNumberPrice() {
		let response: any = [];
		response[0] = [];
		response[1] = [];
		response[2] = [];
		response[3] = [];

		for (let key of Object.keys(this.numberPriceForm.value)) {
			let tmp = key.split('_');
			response[tmp[1]].push({ field: tmp[0], value: this.numberPriceForm.value[key] });
		}
		if (this.numberPriceForm1.value !== '') {
			for (let key of Object.keys(this.numberPriceForm1.value)) {
				let tmp = key.split('_');
				response[tmp[1]].push({ field: tmp[0], value: this.numberPriceForm1.value[key] });
			}
		}
		let temp = response.slice(1, 3);
		this.tariffService.updateVoiceRate(temp).subscribe(resp => {
			this.responseMessage = resp.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		}, err => {
			this.responseMessage = err.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});
	}

	onDepthRate() {

		let response: any = [];
		response[0] = [];
		response[1] = [];
		response[2] = [];
		response[3] = [];
		response[4] = [];
		response[5] = [];
		response[6] = [];
		response[7] = [];
		response[8] = [];

		for (let key of Object.keys(this.depthForm.value)) {
			let tmp = key.split('_');
			response[tmp[1]].push({ field: tmp[0], value: this.depthForm.value[key] });
		}
		if (this.depthForm1.value !== '') {
			for (let key of Object.keys(this.depthForm1.value)) {
				let tmp = key.split('_');
				response[tmp[1]].push({ field: tmp[0], value: this.depthForm1.value[key] });
			}
		}
		let temp = response.slice(1, 8);
		this.tariffService.updateVoiceRate(temp).subscribe(resp => {
			this.responseMessage = resp.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		}, err => {
			this.responseMessage = err.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});
	}

	onSipPrice() {
		let response: any = [];
		response[0] = [];
		response[1] = [];
		response[2] = [];
		response[3] = [];

		for (let key of Object.keys(this.sipForm.value)) {
			let tmp = key.split('_');
			response[tmp[1]].push({ field: tmp[0], value: this.sipForm.value[key] });
		}
		if (this.sipForm1.value !== '') {
			for (let key of Object.keys(this.sipForm1.value)) {
				let tmp = key.split('_');
				response[tmp[1]].push({ field: tmp[0], value: this.sipForm1.value[key] });
			}
		}
		let temp = response.slice(1, 3);
		this.tariffService.updateVoiceRate(temp).subscribe(resp => {
			this.responseMessage = resp.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		}, err => {
			this.responseMessage = err.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});
	}

	oniSipPrice() {
		let response: any = [];
		response[0] = [];
		response[1] = [];
		response[2] = [];
		response[3] = [];
		response[4] = [];
		response[5] = [];
		response[6] = [];
		response[7] = [];

		for (let key of Object.keys(this.iSipForm.value)) {
			let tmp = key.split('_');
			response[tmp[1]].push({ field: tmp[0], value: this.iSipForm.value[key] });
		}
		if (this.iSipForm1.value !== '') {
			for (let key of Object.keys(this.iSipForm1.value)) {
				let tmp = key.split('_');
				response[tmp[1]].push({ field: tmp[0], value: this.iSipForm1.value[key] });
			}
		}
		let temp = response.slice(1, 7);
		this.tariffService.updateVoiceRate(temp).subscribe(resp => {
			this.responseMessage = resp.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		}, err => {
			this.responseMessage = err.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});
	}

	onSipNumber() {
		let response: any = [];
		response[0] = [];
		response[1] = [];
		response[2] = [];
		response[3] = [];

		for (let key of Object.keys(this.sipNumberForm.value)) {
			let tmp = key.split('_');
			response[tmp[1]].push({ field: tmp[0], value: this.sipNumberForm.value[key] });
		}
		if (this.sipNumberForm1.value !== '') {
			for (let key of Object.keys(this.sipNumberForm1.value)) {
				let tmp = key.split('_');
				response[tmp[1]].push({ field: tmp[0], value: this.sipNumberForm1.value[key] });
			}
		}
		let temp = response.slice(1, 3);
		this.tariffService.updateVoiceRate(temp).subscribe(resp => {
			this.responseMessage = resp.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		}, err => {
			this.responseMessage = err.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});
	}

	onDepthSipRate() {
		let response: any = [];
		response[0] = [];
		response[1] = [];
		response[2] = [];
		response[3] = [];
		response[4] = [];
		response[5] = [];
		response[6] = [];
		response[7] = [];
		response[8] = [];

		for (let key of Object.keys(this.depthSipForm.value)) {
			let tmp = key.split('_');
			response[tmp[1]].push({ field: tmp[0], value: this.depthSipForm.value[key] });
		}
		if (this.depthSipForm1.value !== '') {
			for (let key of Object.keys(this.depthSipForm1.value)) {
				let tmp = key.split('_');
				response[tmp[1]].push({ field: tmp[0], value: this.depthSipForm1.value[key] });
			}
		}
		let temp = response.slice(1, 8);
		this.tariffService.updateVoiceRate(temp).subscribe(resp => {
			this.responseMessage = resp.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		}, err => {
			this.responseMessage = err.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});
	}
	onSmsRates() {

		let response: any = [];
		response[0] = [];
		response[1] = [];
		response[2] = [];
		response[3] = [];
		response[4] = [];
		response[5] = [];
		response[6] = [];
		response[7] = [];

		for (let key of Object.keys(this.smsRateForm.value)) {
			let tmp = key.split('_');
			response[tmp[1]].push({ field: tmp[0], value: this.smsRateForm.value[key] });
		}
		if (this.smsRateForm1.value !== '') {
			for (let key of Object.keys(this.smsRateForm1.value)) {
				let tmp = key.split('_');
				response[tmp[1]].push({ field: tmp[0], value: this.smsRateForm1.value[key] });
			}
		}
		let temp = response.slice(1, 7);
		this.tariffService.updateSMSRate(temp).subscribe(resp => {
			this.responseMessage = resp.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});
	}

	//   onSmsRates() {
	// 		let response: any = [];
	// 		response[0] = [];
	// 		response[1] = [];
	// 		response[2] = [];
	// 		response[3] = [];
	// 		response[4] = [];
	// 		response[5] = [];
	// 		response[6] = [];
	// 		response[7] = [];

	// 		for (let key of Object.keys(this.smsRateForm.value)) {
	// 			let tmp = key.split('_');
	// 			response[tmp[1]].push({ field: tmp[0], value: this.smsRateForm.value[key] });
	// 		}
	// 		if(this.smsRateForm1.value !==''){
	// 			for (let key of Object.keys(this.smsRateForm1.value)) {
	// 				let tmp = key.split('_');
	// 				response[tmp[1]].push({ field: tmp[0], value: this.smsRateForm1.value[key] });
	// 			}
	// 		}
	// 		let temp = response.slice(1, 7);
	// 		this.tariffService.updateVoiceRate(temp).subscribe(resp => {
	// 			this.responseMessage = resp.message;
	// 			setTimeout(() => {
	// 				this.responseMessage = "";
	// 			}, 5000);
	// 		});
	// 	}


	msgActivationRates() {
		let response: any = [];
		response[0] = [];
		response[1] = [];
		response[2] = [];
		response[3] = [];
		response[4] = [];
		response[5] = [];
		response[6] = [];
		response[7] = [];

		for (let key of Object.keys(this.msgActForm.value)) {
			let tmp = key.split('_');
			response[tmp[1]].push({ field: tmp[0], value: this.msgActForm.value[key] });
		}
		if (this.msgActForm1.value !== '') {
			for (let key of Object.keys(this.msgActForm1.value)) {
				let tmp = key.split('_');
				response[tmp[1]].push({ field: tmp[0], value: this.msgActForm1.value[key] });
			}
		}
		let temp = response.slice(1, 7);
		this.tariffService.updateVoiceRate(temp).subscribe(resp => {
			this.responseMessage = resp.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		}, err => {
			this.responseMessage = err.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});
	}

	/*Clone Activate Msg Pricing*/
	activateclone() {
		let response: any = [];
		response[0] = [];
		response[1] = [];
		response[2] = [];
		response[3] = [];
		response[4] = [];
		for (let key of Object.keys(this.activatemsgForm.value)) {
			let tmp = key.split('_');
			response[tmp[1]].push({ field: tmp[0], value: this.activatemsgForm.value[key] });
		}
		console.log(this.activatemsgForm.value)
		if (this.activatemsgForm1.value !== '') {
			for (let key of Object.keys(this.activatemsgForm1.value)) {
				let tmp = key.split('_');
				response[tmp[1]].push({ field: tmp[0], value: this.activatemsgForm1.value[key] });
			}
		}
		let temp = response.slice(1, 4);
		this.tariffService.updateactivatemessage(temp).subscribe(resp => {
			this.responseMessage = resp.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});
	}
	//   msgActivationRates() {
	// 		let response: any = [];
	// 		response[0] = [];
	// 		response[1] = [];
	// 		response[2] = [];
	// 		response[3] = [];
	// 		response[4] = [];
	// 		response[5] = [];

	// 		for (let key of Object.keys(this.msgActForm.value)) {
	// 			let tmp = key.split('_');
	// 			response[tmp[1]].push({ field: tmp[0], value: this.msgActForm.value[key] });
	// 		}
	// 		if(this.msgActForm1.value !==''){
	// 			for (let key of Object.keys(this.msgActForm1.value)) {
	// 				let tmp = key.split('_');
	// 				response[tmp[1]].push({ field: tmp[0], value: this.msgActForm1.value[key] });
	// 			}
	// 		}
	// 		let temp = response.slice(1, 5);
	// 		console.log('new',temp);
	// 		this.tariffService.updateVoiceRate(temp).subscribe(resp => {
	// 			this.responseMessage = resp.message;
	// 			setTimeout(() => {
	// 				this.responseMessage = "";
	// 			}, 5000);
	// 		}, err => {
	// 			this.responseMessage = err.message;
	// 			setTimeout(() => {
	// 				this.responseMessage = "";
	// 			}, 5000);
	// 		});
	// 	}

	resetMsgActForm() {
		for (let i of this.msgFields) {
			this.msgActForm.get('price_' + i.priority).setValue('');
			this.msgActForm.get('mo_' + i.priority).setValue('');
			this.msgActForm.get('mt_' + i.priority).setValue('');
		}
	}

	resetSmsRates() {
		for (let data of this.smsFields) {
			this.smsRateForm.get('MO_' + data.priority).setValue('');
			this.smsRateForm.get('MT_' + data.priority).setValue('');
		}
	}

	resetVoiceApi() {
		for (let data of this.voiceApiFields) {
			this.voiceApiForm.get('mo_' + data.priority).setValue('');
			this.voiceApiForm.get('mt_' + data.priority).setValue('');
		}
	}

	resetiVoiceForm() {
		for (let data of this.iVoiceFields) {
			this.iVoiceForm.get('price_' + data.priority).setValue('');
		}
	}

	resetdepthForm() {
		for (let data of this.depthFields) {
			this.depthForm.get('mo_' + data.priority).setValue('');
			this.depthForm.get('mt_' + data.priority).setValue('');
		}
	}

	resetiSipForm() {
		for (let data of this.iSipFields) {
			this.iSipForm.get('price_' + data.priority).setValue('');
		}
	}
	resetlookupForm() {
		for (let data of this.lookupFields) {
			this.lookupForm.get('price_' + data.priority).setValue('');
		}
	}
	resetCampReviewForm() {
		for (let data of this.campaignReviewFields) {
			this.campaignReviewForm.get('price_' + data.priority).setValue('');
		}
	}

	resetdepthSipForm() {
		for (let data of this.depthSipFields) {
			this.depthSipForm.get('mo_' + data.priority).setValue('');
			this.depthSipForm.get('mt_' + data.priority).setValue('');
		}
	}

	// activation message 
	resetactivatemsgForm() {
		for (let data of this.activateFields) {
			this.activatemsgForm.get('mrc_' + data.priority).setValue('');
			this.activatemsgForm.get('nrc_' + data.priority).setValue('');
		}
	}

}
