import { Component, ViewChild, Input } from '@angular/core';
import { ActivatedRoute, ParamMap } from '@angular/router';
import { Validators, FormBuilder, FormControl, FormGroup } from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { MatDialog } from '@angular/material/dialog';
import { usermanagement, usermanagementForm } from '../user.class';
import { UsermanagementService } from '../usermanagement.service';
import { Router } from '@angular/router';
import { BehaviorSubject, Observable } from 'rxjs';
import { MatAccordion } from '@angular/material/expansion';
declare var $: any;
@Component({
  selector: 'app-deleteuser',
  templateUrl: './deleteuser.component.html',
  styleUrls: ['./deleteuser.component.css']
})


export class DeleteuserComponent extends AppComponentClass<usermanagement, usermanagementForm> {

  @ViewChild(MatAccordion) accordion: MatAccordion;
  @Input() usertype: Observable<boolean>;
  @Input() curuserid?: number = -1;
  searchText = { count: 0 };
  filtre: string;
  p: number = 1;

  private userlist$ = new BehaviorSubject<any>([{ iduser: -1, first_name: "", last_name: "", user_name: "", email: "", contact_number: "", password: "", profile_pic: "", pShow: false, pswd: "password" }]);
  userlist: any = this.userlist$.asObservable();


  list: any;
  listdata: any;
  sessData: any;
  defaultUser: any;
  sesiduser: any;
  data1: any;
  isDeleted: any = '2';
  page = 1;
  count = 0;
  tableSize = 50;
  tableSizes = [50, 100, 150];
  public userlistheader: any;
  public subuserlistheader: any;
  filterTerm: string;
  file: any;
  headers: any;
  newFeatures: Observable<any>;
  row: any;
  ids: any = [];
  responseMessage = "";
  countUser: any;
  filteredItems: any;
  errMessage: any = "";
  deleteUsers: any = [];
  tooltp: string;
  filterForm: FormGroup;
  dids: any = [];
  campaigns: any;
  balance: any;
  planname: string = "";
  ismonthly: boolean = false;
  price: string = "";
  userlength: any;
  subCustomer: any = [];

  returnsms: boolean = false;
  checkdelete: boolean = false;

  iduser: string;
  idaccount: string;

  active = {
    style1: "cursor: pointer;",
    style2: "cursor: pointer;",
    style3: "cursor: pointer;",
  }
  authService: any;
  user_id: any;
  account_id: any;
  tmplist: any;

  constructor(public data: UsermanagementService, public router: Router,
    public fb: FormBuilder, public dialog: MatDialog, private route: ActivatedRoute
  ) {
    super(data, router, fb);
  }

  ngOnInit(): void {
    this.data.getuserheader().subscribe((result) => {
      this.userlistheader = result.DeletedAdminHeader;
    });

    // To load the users list
    this.GetUsers()

    this.filterForm = this.fb.group({
      selectedUser: new FormControl(''),
      didnumber: new FormControl(''),
      didnpa: new FormControl(''),
      selectState: new FormControl(''),
      selectSMS: new FormControl('')
    });

    this.data.getuserheader().subscribe((result) => {
      this.subuserlistheader = result.headers_sub_details1;
    });

  }

  editSubUserdata(idaccount, iduser) {
    this.user_id = iduser;
    this.account_id = idaccount;
    this.data.getSubListUsers({ idaccount: idaccount, iduser: iduser, type: "profile" }).subscribe((result: any) => {
      this.userlist = result.data[0];
      this.userlength = result.data[0].length;
      this.subCustomer = result.data[0];
      $('#basic-datatabless2').dataTable().fnClearTable();
      $('#basic-datatabless2').dataTable().fnDraw();
      $('#basic-datatabless2').dataTable().fnDestroy();
      $.getScript('./assets/table.js');
    }, err => {
      console.log(err.message);
    });
  }

  /**
   * It will load the user's list
   */
  GetUsers(): void {
    this.data.getUsers("main").subscribe(res => {
      $('#basic-datatabless11').dataTable().fnClearTable();
      $('#basic-datatabless11').dataTable().fnDraw();
      $('#basic-datatabless11').dataTable().fnDestroy();
      this.userlist = res.data[0];
      this.deleteUsers = [];
      this.userlist.forEach(element => {
        if (element.is_deleted == 2) {
          this.deleteUsers.push(element);
        }
      });
      $.getScript('./assets/table.js');
      this.countUser = res.data[0];
    });
  }

  callCheck() {
    this.returnsms = false;
  }
  onYes() {
    this.data1 = {
      sesiduser: this.user_id,
      sesidaccount: this.account_id,
      isDeleted: this.isDeleted
    }
    if (!this.checkdelete || !this.data1.sesiduser || !this.data1.isDeleted) {
      this.returnsms = true;
      return;
    }
    else {
      this.data.onFinalDeleteAccount(this.data1).subscribe((res) => {
        if (res.status == 201) {
          ($('#DeleteModal') as any).modal('hide');
          this.responseMessage = "You have successfully deleted this account!";
          setTimeout(() => {
            this.responseMessage = "";
          }, 3000);
        }
      });
    }
  }

  showAllCampData(idaccount, iduser) {
    this.user_id = iduser;
    this.account_id = idaccount;

    let payLoad = JSON.stringify({
      idaccount: idaccount,
      iduser: iduser
    })
    // get campaign
    this.campaigns = '';
    this.data.getCampaignForReview(payLoad).subscribe(result => {
      if (result.status == 200) {
        this.campaigns = result.data.length;
      }
      else {
        this.errMessage = result.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });

    //Balance
    this.balance = '';
    this.data.getcustBalance({ idaccount: idaccount, iduser: iduser }).subscribe(response => {
      if (response.status == 200) {
        if (response.data.length > 0) {
          this.balance = response.data[0].balance;
        }
      }
      else {
        this.errMessage = response.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });

    //subCustomer
    this.userlength = '';
    this.data.getSubListUsers({ idaccount: idaccount, iduser: iduser, type: "profile" }).subscribe((result: any) => {
      if (result.status == 200) {
        this.userlength = result.data[0].length;
      }
    });

    // Dids
    this.dids = [];
    this.filterForm = this.fb.group({
      selectedUser: this.user_id + '-' + this.account_id
    });
    this.dids[0] = 'comming...';
    this.data.custDidsCount(this.filterForm.value).subscribe(res => {
      if (res.status == 200) {
        this.dids = res.data.length;
      }
    });

    // get plan
    this.planname = '';
    this.data.getSubscriptionPlan(payLoad).subscribe(result => {
      if (result.status == 200) {
        this.tmplist = result.data[0];
        if (this.tmplist != undefined) {
          switch (this.tmplist.idtariff) {
            case 142:
            case "142":
              {
                this.planname = "LAUNCH PLAN";
                this.price = "Pay As You Go"
              }
              break;
            case 143:
            case "143":
              {
                this.planname = "GROWTH PLAN";
                this.price = "99";
                this.ismonthly = true;
              }
              break;
            case 145:
            case "145":
              {
                this.planname = "SCALE PLAN";
                this.price = "2499";
                this.ismonthly = true;
              }
              break;
            default:
              this.planname = "CUSTOM PLAN";
              break;
          }
        }
      }
      else {
        this.errMessage = result.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  restoreUser() {
    if (confirm("Are you sure you want Restore Account!")) {
      let payLoad = {
        sesidaccount: this.account_id,
        iduser: this.user_id,
        isDeleted: 0
      }
      this.data.onDeleteAccount(payLoad).subscribe((res) => {
        if (res.status == 201) {
          this.responseMessage = "Customer Account Restored Succussfully.";
          setTimeout(() => {
            this.responseMessage = "";
            window.location.reload();
          }, 3000);
        }
      });
    }
  }

  loginUser(data: any) {
    let userLogin = { username: data.user_name, password: data.password, typeCheck: 'admin_checking', sessionType: "MORPHING" };
    this.data.userLogin(userLogin).subscribe(res => {
      if (res.authkey) {
        let userData = res;
        this.router.navigate([], { state: { userData: userData } }).then(result => {
          window.open(window.location.origin + '/#/dashboards/dashboard/' + userData.authkey, '_blank');
        });
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }
}


