import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, ParamMap } from '@angular/router';
import { MatDialog } from '@angular/material/dialog';
import { UsermanagementService } from '../usermanagement.service';
import { Router } from '@angular/router';
import { FormBuilder, FormControl } from '@angular/forms';
declare var $: any;
@Component({
  selector: 'app-pending-to-release',
  templateUrl: './pending-to-release.component.html',
  styleUrls: ['./pending-to-release.component.css']
})
export class PendingToReleaseComponent implements OnInit {
  userlistheader: any;
  userlist: any;
  PendingTodeleteUsers: any[];
  countUser: any;
  user_id: any;
  account_id: any;
  userlength: any;
  subCustomer: any;
  dids: any[];
  filterForm: any;
  campaigns: any;
  errMessage: any;
  balance: any;
  planname: string;
  ismonthly: boolean;
  price: string;
  checkdelete: boolean = false;
  sesiduser: any;
  data1: any;
  active = {
    style1: "cursor: pointer;",
    style2: "cursor: pointer;",
    style3: "cursor: pointer;",
  }
  returnsms: boolean;
  responseMessage: string;
  subuserlistheader: any;
  tmplist: any;

  constructor(

    public data: UsermanagementService, public router: Router,
    public dialog: MatDialog, private route: ActivatedRoute,
    public fb: FormBuilder
  ) {
  }

  ngOnInit(): void {

    this.data.getuserheader().subscribe((result) => {
      this.userlistheader = result.PendingToReleaseHeader;
    });
    this.GetUsers()

    this.data.getuserheader().subscribe((result) => {
      this.subuserlistheader = result.headers_sub_details1;
    });

  }
  // calledUsermanagement(){
  //   this.GetUsers();
  //   return;
  // }
  GetUsers(): void {
    this.data.getUsers("main").subscribe(res => {
      $('#basic-datatabless12').dataTable().fnClearTable();
      $('#basic-datatabless12').dataTable().fnDraw();
      $('#basic-datatabless12').dataTable().fnDestroy();
      this.userlist = res.data[0];
      this.PendingTodeleteUsers = [];
      this.userlist.forEach(element => {
        if (element.is_deleted == 1) {
          this.PendingTodeleteUsers.push(element);
        }
      });
      $.getScript('./assets/table.js');
      this.countUser = res.data[0];
    });
  }

  showAllCampData(idaccount, iduser) {
    this.campaigns = '';
    let payLoad = JSON.stringify({
      idaccount: idaccount,
      iduser: iduser
    })

    this.data.getCampaignForReview(payLoad).subscribe(result => {
      if (result.status == 200) {
        this.campaigns = result.data.length;
      }
      else {
        this.errMessage = result.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  getSubscriptionPlan(idaccount, iduser) {
    this.planname = '';
    let payLoad = JSON.stringify({
      idaccount: idaccount,
      iduser: iduser
    })
    this.data.getSubscriptionPlan(payLoad).subscribe(result => {
      if (result.status == 200) {
        this.tmplist = result.data[0];
        if (this.tmplist != undefined) {
          switch (this.tmplist.idtariff) {
            case 142:
            case "142":
              {
                this.planname = "LAUNCH PLAN";
                this.price = "Pay As You Go"
              }
              break;
            case 143:
            case "143":
              {
                this.planname = "GROWTH PLAN";
                this.price = "99";
                this.ismonthly = true;
              }
              break;
            case 145:
            case "145":
              {
                this.planname = "SCALE PLAN";
                this.price = "2499";
                this.ismonthly = true;
              }
              break;
            default:
              this.planname = "CUSTOM PLAN";
              break;
          }
        }

      }
      else {
        this.errMessage = result.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  showUserdata(idaccount, iduser) {
    this.user_id = iduser;
    this.account_id = idaccount;
    this.dids = [];
    this.balance = '';
    this.userlength = '';

    this.filterForm = this.fb.group({
      selectedUser: this.user_id + '-' + this.account_id
    });
    this.dids[0] = 'comming...';
    this.data.custDidsCount(this.filterForm.value).subscribe(res => {
      if (res.status == 200) {
        this.dids = res.data.length;
      }
    });

    this.data.getSubListUsers({ idaccount: idaccount, iduser: iduser, type: "profile" }).subscribe((result: any) => {
      this.userlist = result.data[0];
      this.userlength = result.data[0].length;
      this.subCustomer = result.data[0];
      $('#basic-datatables1').dataTable().fnClearTable();
      $('#basic-datatables1').dataTable().fnDraw();
      $('#basic-datatables1').dataTable().fnDestroy();
      $.getScript('./assets/table.js');
    }, err => {
      console.log(err.message);
    });

    // this.data.getCampaign({ idaccount: idaccount, iduser: iduser }).subscribe((result: any) => {


    //   this.campaigns=result.data.length; 
    // })

    this.showAllCampData(idaccount, iduser)
    this.getSubscriptionPlan(idaccount, iduser)

    this.data.getcustBalance({ idaccount: idaccount, iduser: iduser }).subscribe(response => {
      if (response.status == 200) {
        if (response.data.length > 0) {
          this.balance = response.data[0].balance;
        }
      }
      else {
        this.errMessage = response.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  callCheck() {
    this.returnsms = false;
  }

  resetCheckbox() {
    this.checkdelete = false;
  }


  onYes() {
    this.data1 = {
      sesiduser: this.user_id,
      sesidaccount: this.account_id,
      isDeleted: 2
    }
    if (!this.checkdelete || !this.data1.sesiduser || !this.data1.isDeleted) {
      this.returnsms = true;
      return;
    }
    else {
      this.data.onFinalDeleteAccount(this.data1).subscribe((res) => {
        if (res.status == 201) {
          document.getElementById("PendingModal").click();
          // this.ngOnInit();
          window.location.reload();
          this.responseMessage = "You have successfully deleted this account!";
          setTimeout(() => {
            this.responseMessage = "";
          }, 3000);
        }
      });
    }
  }

  restoreUser(idaccount, iduser) {
    if (confirm("Are you sure you want Restore Account!")) {
      this.responseMessage = "Customer Account Restored Succussfully.";
      let payLoad = {
        sesidaccount: idaccount,
        iduser: iduser,
        isDeleted: 0

      }      
      this.data.onDeleteAccount(payLoad).subscribe((res) => {
        if (res.status == 201) {
          this.responseMessage = "Customer Account Restored Succussfully.";
          setTimeout(() => {
            this.responseMessage = "";
            window.location.reload();
          }, 3000);
        }
      });
    }
  }

  loginUser(data: any) {
    let userLogin = { username: data.user_name, password: data.password, typeCheck: 'admin_checking', sessionType: "MORPHING" };
    this.data.userLogin(userLogin).subscribe(res => {
      if (res.authkey) {
        let userData = res;
        this.router.navigate([], { state: { userData: userData } }).then(result => {
          window.open(window.location.origin + '/#/dashboards/dashboard/' + userData.authkey, '_blank');
        });
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

}
