import { Component, Inject, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';
import { BillingService } from 'src/app/billing/billing.service';
import { UsermanagementService } from '../../usermanagement.service';

@Component({
  selector: 'app-address',
  templateUrl: './address.component.html',
  styleUrls: ['./address.component.css']
})
export class AddressComponent implements OnInit {

  billingAddressForm: FormGroup;
  responseMessage: any = "";
  errMessage: any = "";
  submitted: boolean = false;
  USA: boolean = false;
  Canada: boolean = false;
  countryVal: any;
  zipLength: any;
  billingadrs: any;
  corporationLimitedCountry: any =[];
	solePropCountry: any[];
	internationalBusiCountry: any =[];
	noneProfitCountry: any =[];
	allCountry: any =[];
	Country:any;

  constructor(public dialogRef: MatDialogRef<AddressComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any, private billingAddress: BillingService,private user: UsermanagementService, private fb: FormBuilder) { }

  ngOnInit(): void {

    this.billingAddressForm = this.fb.group({
      idbilling_address: this.data.idbilling_address,
      address1: ['', [Validators.required, Validators.pattern(/^(\s+\S+\s*)*(?!\s).*$/)]],
      address2: ['', [Validators.pattern(/^(\s+\S+\s*)*(?!\s).*$/)]],
      city: ['', [Validators.required, Validators.pattern(/^(\s+\S+\s*)*(?!\s).*$/), Validators.pattern("^[a-zA-Z \'][a-zA-Z \']*$")]],
      state: ['', [Validators.required, Validators.pattern(/^(\s+\S+\s*)*(?!\s).*$/), Validators.pattern("^[a-zA-Z \'][a-zA-Z \']*$")]],
      // postal_code: ['', [Validators.required, Validators.minLength(5), Validators.maxLength(5), Validators.pattern(/^(\s+\S+\s*)*(?!\s).*$/)]],
      // postal_code: ['', [Validators.required, Validators.pattern(/^(\s+\S+\s*)*(?!\s).*$/)]],
      postal_code: ['', [Validators.required]],
      // country: ['', [Validators.required, Validators.pattern(/^(\s+\S+\s*)*(?!\s).*$/), Validators.pattern("^[a-zA-Z ]*$")]],
      country: ['', [Validators.required, Validators.minLength(2)]],
      currentDateTime: []
    });

    this.getCountry();
  }

  getCountry(){
		this.user.getCountry().subscribe(res => {
			this.corporationLimitedCountry = [];
			this.solePropCountry = [];
			this.internationalBusiCountry = [];
			this.noneProfitCountry = [];
			if (res.status == 200) {			
				this.allCountry = res.data;
				console.log("this.allCountry",this.allCountry);
				
				this.allCountry.forEach(element => {
					// To get Corporation / Limited Liability Company (USA Only)
					if(element.corporation_or_limited_liability_company_only_us == '1')
						this.corporationLimitedCountry.push(element);

					// To get Sole Proprietor / Individual
					if(element.sole_proprietor_or_individual == '1')
						this.solePropCountry.push(element);

					// To get International Business (non-US)
					if(element.international_business_none_us == '1')
						this.internationalBusiCountry.push(element);

					// To get Non-Profit, 501C
					if(element.none_profit_501c == '1')
						this.noneProfitCountry.push(element);
				});		
        this.setValue();
			}
			else{
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = "Something went wrong with country list!";
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}

  setValue(){
    if(this.data.customerType == 'Corporation'){
      this.Country = this.corporationLimitedCountry;
    }
    else if(this.data.customerType == 'International_business'){
      this.Country = this.internationalBusiCountry
    }else if(this.data.customerType == 'Sole_Proprietor'){
      this.Country = this.solePropCountry
    }
    else{
      this.Country = this.noneProfitCountry
    }
    if (this.data.id_billing_address) {
      this.billingadrs= this.data;
      this.billingAddressForm.patchValue({
        idbilling_address: this.data.id_billing_address,
        address1: this.data.address1,
        address2: this.data.address2,
        city: this.data.city,
        state: this.data.state,
        postal_code: this.data.postal_code,
      });
      if(this.data.customerType == 'Corporation'){
        this.billingAddressForm.patchValue({
          country:"Us"
        });
      }
      else{
        this.billingAddressForm.patchValue({
         country: this.data.country
        });
      }
      this.countryVal = this.billingAddressForm.value.country;
      if(this.countryVal=='US')
      {
        this.Canada=false;
      }
      else{
        this.Canada=true;
      }
    }
  }

  updateAddress() {
    if (this.billingAddressForm.invalid) {
      return false;
    }
    else {
      if (this.data.id_billing_address || this.data.id_billing_address != undefined) {
        if (this.countryVal == 'US') {
          this.billingAddress.getGeoCodeAdd(this.billingAddressForm.value).subscribe(res => {
            if (res.status == 200) {
              this.updateBilling();
              this.dialogRef.close({ message: "Address Updated Successfully!", error: 0 });
            }
            else {
              this.dialogRef.close({ message: "Address Validation Failed!", error: 1 });
            }
          }, err => {
            this.dialogRef.close({ message: err.message, error: 1 });
          });
        }
        else {
          this.updateBilling();
        }
      }
      else {
        if (this.countryVal == 'US') {
          this.billingAddress.getGeoCodeAdd(this.billingAddressForm.value).subscribe(res => {
            if (res.status == 200) {
              this.addBilling();
              this.dialogRef.close({ message: "Address Saved Successfully!", error: 0 });

            }
            else {
              this.dialogRef.close({ message: "Address Validation Failed!", error: 0 });
            }
          }, err => {
            this.dialogRef.close({ message: err.message, error: 1 });
          });
        }
        else {
          this.addBilling();
        }
      }
    }
  }

  addBilling() {
    this.billingAddress.addBillingAddress(this.billingAddressForm.value).subscribe(response => {
      if (response.status == 201) {
        this.dialogRef.close({ message: response.message, error: 0 });
      }
      else {
        this.dialogRef.close({ message: response.message, error: 1 });
      }
    },
      err => {
        this.dialogRef.close({ message: err.message, error: 1 });
      });
  }

  updateBilling() {
    this.billingAddress.updateBillingAddress(this.billingAddressForm.value).subscribe(response => {
      if (response.status == 201) {
        this.dialogRef.close({ message: response.message, error: 0 });
      }
      else {
        this.dialogRef.close({ message: response.message, error: 1 });
      }
    },
      err => {
        this.dialogRef.close({ message: err.message, error: 1 });
      });
  }

  onClose() {
    this.dialogRef.close(this.data);
  }

  onCountry(e: any) {
    if (e.target.value == 'US') {
      this.USA = true;
      this.Canada = false;
      this.countryVal = 'US';
      this.zipLength = '';
      let post = this.billingAddressForm.get('postal_code').value;
      if (post.length != 5) {
        this.billingAddressForm.get('postal_code').setValue('');
      }
    }
    else if (e.target.value == 'CA') {
      this.Canada = true;
      this.USA = false;
      this.countryVal = 'CA';
      let post = this.billingAddressForm.get('postal_code').value;
      if (post.length != 10) {
        this.billingAddressForm.get('postal_code').setValue('');
      }
    }
    else {
      this.Canada = false;
      this.USA = false;
      this.countryVal = '';
    }
  }

  PostalCode(event: any): boolean {
    if (this.Canada == true) {
      this.zipLength = 10;
      let Post: any = this.billingAddressForm.get("postal_code");
      Post.setValidators([Validators.required, Validators.minLength(0), Validators.maxLength(this.zipLength)]);
      Post.updateValueAndValidity();

      var regex = new RegExp("^[0-9a-zA-Z \b]+$");
      var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
      if (!regex.test(key)) {
        event.preventDefault();
        return false;
      }
    }
    else {
      this.zipLength = 5;
      let Post: any = this.billingAddressForm.get("postal_code");
      Post.setValidators([Validators.required, Validators.minLength(this.zipLength), Validators.maxLength(this.zipLength)]);
      Post.updateValueAndValidity();

      const charCode = (event.which) ? event.which : event.keyCode;
      if (charCode > 31 && (charCode < 48 || charCode > 57)) {
        return false;
      }
      return true;
    }
  }

}
