import { Component, Inject, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';
import { BehaviorSubject } from 'rxjs';
import { BillingService } from 'src/app/billing/billing.service';
import { environment } from 'src/environments/environment';
import { UsermanagementService } from '../../usermanagement.service';

@Component({
  selector: 'app-balance',
  templateUrl: './balance.component.html',
  styleUrls: ['./balance.component.css']
})

export class BalanceComponent implements OnInit {

  billingAddressForm: FormGroup;
  amount: any = 20;
  submitted: boolean = false;
  address: any;
  userProfile: any;
  paymentHandler: any;
  errMessage: any = "";
  stripeCards: any = [];
  isCards: boolean = false;
  valMessage$ = new BehaviorSubject<string>('');
  valMessage = this.valMessage$.asObservable();
  isNewCard: Boolean = false;
  checked: boolean = false;
  stripeDefaultCards: any;
  stripeDefCard: any;
  public show: boolean = false;
  message: string;

  constructor(public dialogRef: MatDialogRef<BalanceComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any = {}, private billingAddress: BillingService,
    private fb: FormBuilder, private userService: UsermanagementService) { }

  ngOnInit(): void {

    this.address = this.data.address[0] || {};    
    this.userProfile = this.data.userProfile[0] || {};    

    this.billingAddressForm = this.fb.group({
      amount: [this.amount, [Validators.required,
      Validators.min(20),
      Validators.max(500000),
      Validators.pattern(/^\d*(?:[.,]\d{1,2})?$/),
      ]],
      customer_id: [''],
      first_name: [''],
      last_name: [''],
      contact: [''],
      email: [''],
      address1: [''],
      address2: [''],
      city: [''],
      state: [''],
      postal_code: [''],
      country: [''],
      currentDateTime: []
    });

    this.billingAddressForm.patchValue({
      amount: this.amount || 0,
      first_name: this.userProfile.first_name,
      last_name: this.userProfile.last_name,
      contact: this.userProfile.contact_number,
      email: this.userProfile.email,
      address1: this.address.address1,
      address2: this.address.address2,
      city: this.address.city,
      state: this.address.state,
      postal_code: this.address.postal_code,
      country: this.address.country,
    });

    this.userService.stripeCards().subscribe(res => {
      if (res.status == 200) {
        if (res.data.length > 0) {
          this.stripeCards = res.data;
          this.isCards = true;
          if (this.stripeCards.length >= 5) {
            this.isNewCard = false;
          }
          else {
            this.isNewCard = false;
          }
        }
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });

    this.invokeStripe();
  }

  // getAmount(e) {
  //   this.amount = e.target.value;
  //   this.billingAddressForm.patchValue({
  //     amount: this.amount
  //   });
  // }

  getAmount(e:any) { 
    this.billingAddressForm.patchValue({
      // amount: this.amount
      amount: e.target.value
    });
    let data = e.target.value;    
    this.submitted = false; 
    e.target.value = (data.indexOf(".") >= 0) ? (data.substr(0, data.indexOf(".")) + data.substr(data.indexOf("."), 3)) : data;
    return  this.amount = e.target.value;   
  }

  selectCard(customer_id) {
    this.stripeCards.find(res => {
      if (customer_id == res.customer_id) {
        this.billingAddressForm.patchValue({
          customer_id: res.customer_id
        })
      }
    });
  }

  addWithExisting() {
    let card: any;
    this.stripeCards.find(res => {
      if (res.customer_id == this.billingAddressForm.value.customer_id) {
        card = res.exp_month + '/' + res.exp_year + '**** ' + res.last4;
      }
    });
    if (this.billingAddressForm.value.customer_id) {
      if (confirm(`Please Confirm Card ${card}`)) {
        this.billingAddress.updateBalance(JSON.stringify({ pdata: this.billingAddressForm.value })).subscribe(response => {
          if (response.status == 201) {
            this.dialogRef.close({ message: response.message, reload: true });
          }
          else {
            this.valMessage$.next(response.message);
            setTimeout(() => {
              this.valMessage$.next("");
            }, 5000);
          }
        });
      }
      else {
        return
      }
    }
    else {
      this.valMessage$.next("Please Select Card");
      setTimeout(() => {
        this.valMessage$.next("");
      }, 5000);
    }
  }

  addAmount() {   
    if (this.billingAddressForm.invalid) {
      this.submitted = true; 
      // this.valMessage$.next("Invalid Amount or Account Profile");
      // setTimeout(() => {
      //   this.valMessage$.next("");
      // }, 5000);
    }
    else {
      this.billingAddressForm.patchValue({
        amount: this.amount,
        currentDateTime: this.current_datetime(),
      });
      // if(this.billingAddressForm.value.customer_id){
      //     this.addWithExisting();
      // }
      // else{

      if (this.billingAddressForm.value.customer_id) {
        this.billingAddressForm.patchValue({
          customer_id: this.billingAddressForm.value.customer_id
        })
        this.openCheckout(this.billingAddressForm.value);

      }
      else {
        this.userService.stripeDefaultCards().subscribe(res => {
          if (res.status == 200) {
            this.stripeDefaultCards = res.data[0];
            this.isCards = true;
            this.stripeDefCard = this.stripeDefaultCards.customer_id;
            this.billingAddressForm.patchValue({
              customer_id: this.stripeDefaultCards.customer_id
            })
            this.openCheckout(this.billingAddressForm.value);

          }
          else {
            this.openCheckout(this.billingAddressForm.value);

          }
        });

      }

      // }
    }
  }

  openCheckout(billingData: any) {
    if (billingData.customer_id != '' && billingData.customer_id) {
      this.billingAddress.updateBalance(JSON.stringify({ pdata: billingData })).subscribe(response => {
        if (response.status == 201) {
          this.dialogRef.close({ message: response.message, reload: true });
        }
        else {
          this.valMessage$.next(response.message);
          setTimeout(() => {
            this.valMessage$.next("");
          }, 5000);
        }
      });
    }
    else {
      const paymentHandler = (<any>window).StripeCheckout.configure({
        key: environment.PublicKey,
        locale: 'auto',
        token: (stripeToken: any) => {
          this.billingAddress.addBalance(JSON.stringify({ pdata: billingData, token: stripeToken })).subscribe(response => {
            if (response.status == 201) {
              alert("We are adding this card as a Default Card!");
              this.dialogRef.close({ message: response.message, reload: true });
            }
            else {
              this.errMessage = response.message;
              setTimeout(() => {
                this.errMessage = "";
              }, 5000);
            }
          });
        }
      });
      paymentHandler.open({
        name: 'Signalmash Admin',
        // description: `Amount ${this.amount} Added For Your Signalmash Wallet`,
        amount: this.amount * 100,
        shippingAddress: false,
        billingAddress: true,
      });
    }
  }

  invokeStripe() {
    if (!window.document.getElementById('stripe-script')) {
      const script = window.document.createElement("script");
      script.id = "stripe-script";
      script.type = "text/javascript";
      script.src = "https://checkout.stripe.com/checkout.js";
      script.onload = () => {
        this.paymentHandler = (<any>window).StripeCheckout.configure({
          key: environment.PublicKey,
          locale: 'auto',
          token: (stripeToken: any) => {
            alert('Payment has been successfully!');
          }
        });
      }
      window.document.body.appendChild(script);
    }
  }

  current_datetime() {
    let now = new Date();
    let year = "" + now.getFullYear();
    let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
    let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
    let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
    let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
    let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
    return year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second;
  }

  onClose() {
    this.dialogRef.close({ data: this.data, reload: false });
  }
}
