import { Component, Inject, OnInit } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';
import { Observable } from 'rxjs';
import { SmsService } from 'src/app/sms/sms.service';
import { UsermanagementService } from '../../usermanagement.service';
import 'rxjs/add/observable/timer';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/take';

@Component({
  selector: 'app-otpverify',
  templateUrl: './otpverify.component.html',
  styleUrls: ['./otpverify.component.css']
})
export class OtpverifyComponent implements OnInit {

  otpForm: FormGroup;
  submitted1: boolean = false;
  responseMessage: any = "";
  otpEnable: Boolean = false;
  countDown;
  counter: any;
  tick = 1000;
  num: number;
  errMessage: any = "";
  otpErr: string;
  
  constructor(public dialogRef: MatDialogRef<OtpverifyComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any, private fb: FormBuilder, 
    private userSerive: UsermanagementService, protected smsService: SmsService) { }

  ngOnInit(): void {

      this.otpForm = this.fb.group({
        TO: new FormControl('',[Validators.required]),
        otp: new FormControl('')
    });
    
    this.otpForm.setValidators([Validators.required]);
  }

  sendOtp(){
    this.submitted1 = true;
      if(this.otpForm.invalid){
        return
      }
      else{
            let otp = Math.floor(100000 + Math.random() * 900000);
            let body = `Your Signalmash verification code is ${otp}`;
            this.userSerive.saveOtp({otp: otp, FROM: "2029808085", TO: this.otpForm.value.TO, BODY: body}).subscribe(response => {
              if(response.status == 201){
                sessionStorage.setItem("contact", this.otpForm.value.TO);
                this.responseMessage = response.message;
                this.otpEnable = true;
                this.num=this.otpForm.value.TO;
                this.counter = 120;
                this.countDown = Observable.timer(0, this.tick)
                .take(this.counter)
                .map(() =>  {
                  if(this.counter <= 1){
                    this.otpEnable = false;
                  }
                  return --this.counter
                 });
                
                this.otpForm.get("otp").setValidators([Validators.required, Validators.minLength(6), Validators.maxLength(6)]);
                this.otpForm.get("TO").clearValidators();
                this.otpForm.updateValueAndValidity();
                setTimeout(()=>{
                  this.responseMessage= "";
                }, 3000);
                this.ngOnInit();    
              }
              else{
                if(response.status == 501){
                  this.dialogRef.close({contact: this.data.contact, message: response.message});
                }
                else{
                  this.errMessage = response.message;  
                  setTimeout(()=>{
                    this.errMessage= "";
                  }, 3000);
                }
                
              }               
        }, err => {
          this.errMessage = err.message;  
          setTimeout(()=>{
            this.errMessage= "";
          }, 3000);
        });
        }
    // let otp = Math.floor(100000 + Math.random() * 900000);
    // let body = `Your Signalmash verification code is ${otp}`;
    // this.smsService.sendSMS({FROM: '8662179750', TO: this.data.contact, BODY: body }).subscribe(res => {
    //   if(res.status == 201){
    //     this.data.saveOtp({otp: otp, FROM: "8662179750", TO: this.data.contact}).subscribe(res => {
    //       this.responseMessage = res.message;  
    //         setTimeout(()=>{
    //           this.responseMessage= "";
    //         }, 3000);
    //         this.ngOnInit(); 
    //   });
    //   }  
    //   else{
    //       this.responseMessage = res.errorMessage;
    //       setTimeout(()=>{
    //         this.responseMessage= "";
    //       }, 3000);
    //       this.ngOnInit(); 
    //   }
    // }, err => {
    //   this.responseMessage = err.message;  
    //   setTimeout(()=>{
    //     this.responseMessage= "";
    //   }, 3000);
    // });
  }


  verifyNumber(){
    if(!this.otpForm.value.otp){
      this.otpErr = "Enter The OTP"
      return
    }
    else{
      this.otpErr ="";
      this.otpForm.patchValue({
          TO: this.data.contact
      });
      if(this.otpForm.invalid){
        return
      }
      else{
        this.otpForm.patchValue({
            TO: sessionStorage.getItem("contact")
        });
            this.userSerive.verifyOtp(this.otpForm.value).subscribe(res =>{
              this.dialogRef.close({contact: this.data.contact, message: res.message});
        });
      }
    }
  }

  onClose() {
    this.dialogRef.close(this.data.contact);
  }
}
