import { Component, OnInit } from '@angular/core';
import { environment } from 'src/environments/environment';
import { UsermanagementService } from '../../usermanagement.service';

@Component({
  selector: 'app-payment-method',
  templateUrl: './payment-method.component.html',
  styleUrls: ['./payment-method.component.css']
})
export class PaymentMethodComponent implements OnInit {

  submitted: boolean;
  responseMessage: any;
  subbmitted: boolean = false;
  errMessage: any = "";
  stripeCards: any = [];
  isCard: Boolean = false;
  paymentHandler: any;
  isNewCard: Boolean = false;

  constructor(private data: UsermanagementService) { }

  ngOnInit(): void {
    this.data.stripeCards().subscribe(res => {
      if (res.status == 200) {
        if (res.data.length > 0) {
          this.stripeCards = res.data;
          this.isCard = true;
          if (this.stripeCards.length >= 5) {
            this.isNewCard = true;
          }
          else {
            this.isNewCard = false;
          }
        }
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });

    this.invokeStripe();
  }

  createCard() {
    const paymentHandler = (<any>window).StripeCheckout.configure({
      key: environment.PublicKey,
      locale: 'auto',
      token: (stripeToken: any) => {
        this.data.createCard(stripeToken).subscribe(res => {
          if (res.status == 201) {
            this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
            this.ngOnInit();
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        }, err => {
          this.errMessage = err.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        });
      }
    });
    paymentHandler.open({
      name: 'signalmash',
      description: `Enter card Details`,
      amount: 0 * 100,
      panelLabel: 'Add Card',
      shippingAddress: false,
      billingAddress: true,
    });


  }


  setDefault(customer_id) {
    if (confirm("Are You Sure ?")) {
      this.data.setDefaultCard(customer_id).subscribe(res => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
          this.ngOnInit();
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      });
    }
    else {
      return
    }
  }

  deleteCard(customer_id, status, index) {
    if (status == 'true') {
      this.errMessage = "Default Card cannot be delete!";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    }
    else {
      if (confirm("Are You Sure")) {
        this.data.deleteCard(customer_id).subscribe(res => {
          if (res.status == 201) {
            this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
            this.stripeCards.splice(index, 1);
            this.ngOnInit();
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000)
          }
        }, err => {
          this.errMessage = err.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000)
        });
      }
      else {
        return
      }
    }
  }

  invokeStripe() {
    if (!window.document.getElementById('stripe-script')) {
      const script = window.document.createElement("script");
      script.id = "stripe-script";
      script.type = "text/javascript";
      script.src = "https://checkout.stripe.com/checkout.js";
      //script.src = "https://js.stripe.com/v3";
      script.onload = () => {
        this.paymentHandler = (<any>window).StripeCheckout.configure({
          key: environment.PublicKey,
          locale: 'auto',
          token: (stripeToken: any) => {
            alert('Payment has been successfull!');
          }
        });
      }
      window.document.body.appendChild(script);
    }
  }

  current_datetime() {
    let now = new Date();
    let year = "" + now.getFullYear();
    let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
    let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
    let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
    let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
    let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
    return year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second;
  }

}
